 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                                                                      */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Wed Jul  2 1997                              */
 /* -------------------------------------------------------------------- */
 /* Join at a given pitch period.                                        */
 /*                                                                      */
 /************************************************************************/

#include "FramesJoin.h"

FramesJoin::FramesJoin(void)
{
  p_start_index = -1;
  p_end_index   = -1;
}

FramesJoin::FramesJoin(int end_i, int start_i)
{
  p_end_index   = end_i;
  p_start_index = start_i;
}

FramesJoin::FramesJoin(Unit *before, int end_i, Unit *after, int start_i)
{
  p_end_index   = end_i;
  p_start_index = start_i;
  set_before(before);
  set_after(after);
}

FramesJoin::~FramesJoin(void)
{
  // don't need to do anything.
}

bool FramesJoin::recognise(FILE *stream)
{
  (void)stream; 
  return FALSE;
}

Join * FramesJoin::create(void)
{
  return new FramesJoin;
}

