 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                                                                      */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Mon Jun 30 1997                              */
 /* -------------------------------------------------------------------- */
 /*                                                                      */
 /* Module containing prosody imposition methods.                        */
 /*                                                                      */
 /************************************************************************/

#include "Imposition.h"
#include "just_duration_impose.h"
#include "simple_impose.h"
#include "weighted_impose.h"
#include "wobble_impose.h"
#include "simple_power.h"
#include "no_power.h"

struct imposition_rec *imp_buffer=NULL;
int imp_buffer_size=0;

static EST_TrackMap::ChannelMapping imposition_mapping =
{
  { channel_frame, 0 },		// which lpc frame
  { channel_length,  1 },	// new length
  { channel_unknown},	
};
EST_TrackMap ImpositionTrackMap(imposition_mapping);
static EST_TrackMap::ChannelMapping imposition_mapping_p =
{
  { channel_frame, 0 },		// which lpc frame
  { channel_length,  1 },	// new length
  { channel_power, 2 },		// new power
  { channel_unknown},	
};
EST_TrackMap ImpositionTrackMapP(imposition_mapping_p);

void festival_Imposition_init(void)
{
  just_duration_impose_init();
  simple_impose_init();
  weighted_impose_init();
  wobble_impose_init();
  simple_power_init();
  no_power_init();
}

