#ifndef lint
static char *RCSid() { return RCSid("$Id: amavis.c,v 1.1.2.24 2002/03/06 15:43:14 lhecking Exp $"); }
#endif

/*
 * client for amavisd
 *
 * Author: Geoff Winkless <gwinkless@users.sourceforge.net>
 * Additional work and patches by:
 *   Gregory Ade
 *   Thomas Biege
 *   Pierre-Yves Bonnetain
 *   Ricardo M. Ferreira
 *   Lars Hecking
 *   Rainer Link
 *   Julio Sanchez
 *
 */

/*
 * Add some copyright notice here ...
 *
 * Usage: amavis sender recipient [recipient ...] [-- lda [lda-args]]
 *
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#define BUFFLEN 8192
#define DIRBUFFLEN 108
/* Must be the same as the buffer length for recv() in amavisd */
#define SOCKBUFLEN 8192

#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/stat.h>
#include <sys/utsname.h>
#include <fcntl.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <sysexits.h>
#include <unistd.h>

#define TEMPLATE "/amavis-XXXXXXXX"
#define DEBUGFILE "/tmp/virdebug"

#define DBG_NONE  0
#define DBG_INFO  1
#define DBG_WARN  2
#define DBG_FATAL 4

#define DBG_ALL     (DBG_FATAL | DBG_WARN | DBG_INFO)

static struct utsname myuts;

/* Don't debug by default */
static const int debuglevel = DBG_NONE;
/* static const int debuglevel = DBG_ALL; */
static const char *mydebugfile = RUNTIME_DIR "/amavis.client";

static void mydebug(const int, const char *, ...);
static char *mymktempdir(char *);


#ifndef HAVE_STRLCPY
static size_t
strlcpy(char *dst, const char *src, size_t size)
{
    size_t src_l = strlen(src);
    if(src_l < size) {
	memcpy(dst, src, src_l + 1);
    } else if(size) {
	memcpy(dst, src, size - 1);
	dst[size - 1] = '\0';
    }
    return src_l;
}
#endif


static void
mydebug(const int level, const char *fmt, ...)
{
    FILE *f = NULL;
    int fd = 0;
    time_t tmpt;
    char *timestamp;
    va_list ap;

    if (!(level & debuglevel))
	return;

    /* Set up debug file */
    if (mydebugfile && (f = fopen(mydebugfile, "a")) == NULL) {
	fprintf(stderr, "error while opening '%s'\n", mydebugfile);
	return;
    } else {
	remove(DEBUGFILE);
	if ((fd = open(DEBUGFILE, O_CREAT | O_EXCL | O_RDWR, 0600)) < 0 || (f = fdopen(fd, "a")) == NULL) {
	    fprintf(stderr, "error while opening '%s'\n", DEBUGFILE);
	    return;
	}
    }

    tmpt = time(NULL);
    timestamp = ctime(&tmpt);
    /* A 26 character string according ctime(3c)
     * we cut off the trailing \n\0 */
    timestamp[24] = 0;
    fprintf(f, "%s %s amavis(client)[%ld]: ",
    	timestamp, (myuts.sysname ? myuts.sysname : ""), (long) getpid());

    va_start(ap, fmt);
    vfprintf(f, fmt, ap);
    va_end(ap);

    fputc('\n', f);
    fclose(f);
    close(fd);
}


static char *
mymktempdir(char *s)
{
    char dirname[DIRBUFFLEN];
    char *stt;
    int count = 0;

    strlcpy(dirname, s, sizeof(dirname));

#ifdef HAVE_MKDTEMP
    return mkdtemp(s);
#else
    /* magic number alert */
    while (count++ < 20) {
# ifdef HAVE_MKTEMP
	stt = mktemp(s);
# else
	stt = strchr(dirname, '-') + 1;
	if (stt) {
	    /* more magic number alert */
	    snprintf(stt, sizeof(dirname) - 1 - (stt - dirname), "%08d", lrand48() / 215);
	    /* This assumes that s in the calling function is the same size
	     * as the local dirname! Beware of malicious coders ;-) */
	    strlcpy(s, dirname, sizeof(dirname));
	    stt = dirname;
	} else {
	    /* invalid template */
	    return NULL;
	}
# endif
	if (stt) {
	    if (!mkdir(s, S_IRWXU)) {
		return s;
	    } else {
		continue;
	    }
	}
    }
    return NULL;
#endif /* HAVE_MKDTEMP */
}

/* Simple "protocol" */
const char _LDA = '\2';
const char _EOT = '\3';

/* take input from stdin as an email, with argv as sender and recipients
 * then pass it all to amavisd
 * TODO: sender/recipient parsing for qmail; see qmail-queue(8) for details
 */
int
main(int argc, char **argv)
{
    char atmpfile[BUFFLEN];
    char buff[BUFFLEN];
    char dirname[DIRBUFFLEN];
    char xstat[8] = { 0 };
    struct sockaddr_un saddr;
    FILE *fout = NULL;
    int fd = 0;
    const char *sender;
    size_t rw = 0, msgsize = 0;
    int r, sock, i = 2, lda = 0;
    char retval;
    struct stat StatBuf;
#if !(HAVE_MKDTEMP || HAVE_MKTEMP)
    int mypid = getpid();

    srand48(time(NULL) ^ (mypid + (mypid << 15)));
#endif

    /* */
    uname(&myuts);

    /* Process args first */
    if (argc < 3) {
	mydebug(DBG_FATAL, "Insufficient number of arguments: %s",
		strerror(errno));
	exit(EX_TEMPFAIL);
    }

    umask(0077);

    /* Find out whether an lda was specified (sendmail/local setup) */
    while (++i < argc) {
	if (strcmp(argv[i], "--") == 0) {
	    if (i < argc - 1)
		lda = i + 1;
	    /* once we've located the position of "--", we're done */
	    break;
	}
    }

    /* */
    strlcpy(dirname, RUNTIME_DIR, sizeof(dirname));
    strncat(dirname, TEMPLATE, sizeof(dirname) - 1 - strlen(dirname));
    if (mymktempdir(dirname) == NULL) {
	mydebug(DBG_FATAL, "Failed to create temp dir: %s", strerror(errno));
	exit(EX_TEMPFAIL);
    }

    if (lstat(dirname, &StatBuf) < 0) {
	mydebug(DBG_FATAL, "%s: Error while trying lstat(%s): %s",
		argv[0], dirname, strerror(errno));
	exit(EX_TEMPFAIL);
    }

    /* may be too restrictive for you, but's good to avoid problems */
    if (!S_ISDIR(StatBuf.st_mode) || StatBuf.st_uid != geteuid() ||
	StatBuf.st_gid != getegid() || !(StatBuf.st_mode & (S_IWUSR | S_IRUSR))) {
	mydebug(DBG_FATAL,
		"%s: Security Warning: %s must be a Directory and owned by "
		"User %d and Group %d and just read-/write-able by the User "
		" and noone else. Exit.", argv[0], dirname, geteuid(), getegid());
	exit(EX_TEMPFAIL);
    }
    /* there is still a race condition here if RUNTIME_DIR is writeable by the attacker :-\ */

    snprintf(atmpfile, sizeof(atmpfile), "%s/email.txt", dirname);

    if ((fd = open(atmpfile, O_CREAT | O_EXCL | O_WRONLY, S_IRUSR)) < 0 || (fout = fdopen(fd, "w")) == NULL)
	mydebug(DBG_FATAL, "failed to open a_tmp_file: %s", strerror(errno));

    while (!feof(stdin)) {
	rw = fread(buff, sizeof(char), sizeof(buff), stdin);
	fwrite(buff, sizeof(char), rw, fout);
	msgsize += rw;
    }
    fclose(fout);
    mydebug(DBG_INFO, "size=%d", msgsize);

    r = (sock = socket(PF_UNIX, SOCK_STREAM, 0));
    if (r < 0)
	mydebug(DBG_FATAL, "failed to allocate socket: %s", strerror(errno));
    saddr.sun_family = AF_UNIX;
    strlcpy(saddr.sun_path, AMAVISD_SOCKET, sizeof(saddr.sun_path));
    if (r >= 0) {
	mydebug(DBG_INFO, "connect()");
	r = connect(sock, (struct sockaddr *) &saddr, sizeof(saddr));
	if (r < 0)
	    mydebug(DBG_FATAL, "failed to connect(): %s", strerror(errno));
    }
    if (r >= 0) {
	mydebug(DBG_INFO, "senddir() %s", dirname);
	r = send(sock, dirname, strlen(dirname), 0);
	if (r < 0)
	    mydebug(DBG_FATAL, "failed to send() directory: %s", strerror(errno));
    }
    if (r >= 0) {
	r = recv(sock, &retval, 1, 0);
	if (r < 0)
	    mydebug(DBG_FATAL, "failed to recv() directory confirmation: %s",
		    strerror(errno));
    }
    if (r >= 0) {
	int sender_l;
	sender = (strlen(argv[1]) > 0) ? argv[1] : "<>";
	mydebug(DBG_INFO, "sendfrom() %s", sender);
	sender_l = strlen(sender);
	if (sender_l > SOCKBUFLEN) {
	    mydebug(DBG_WARN, "Sender too long (%d), truncated to %d characters", sender_l, SOCKBUFLEN);
	    sender_l = SOCKBUFLEN;
	}
	r = send(sock, sender, sender_l, 0);
	if (r < 0)
	    mydebug(DBG_FATAL, "failed to send() Sender: %s", strerror(errno));
	else if (r < sender_l)
	    mydebug(DBG_WARN, "failed to send() complete Sender, truncated to %d characters ", r);
    }
    if (r >= 0) {
	r = recv(sock, &retval, 1, 0);
	if (r < 0)
	    mydebug(DBG_FATAL, "failed to recv() ok for Sender info: %s",
		    strerror(errno));
    }
    if (r >= 0) {
	for (i = 2; i < argc; i++) {
	    if (lda == 0) {
	    int recipient_l;
		/* No LDA - this branch is essentially the old code */
		mydebug(DBG_INFO, "sendto() %s", argv[i]);
		recipient_l = strlen(argv[i]);
		if (recipient_l > SOCKBUFLEN) {
		    mydebug(DBG_WARN, "Recipient too long (%d), truncated to %d characters", recipient_l, SOCKBUFLEN);
		    recipient_l = SOCKBUFLEN;
		}
		r = send(sock, argv[i], recipient_l, 0);
		if (r < 0)
		    mydebug(DBG_FATAL, "failed to send() Recipient: %s",
			    strerror(errno));
		else {
		    if (r < recipient_l)
			mydebug(DBG_WARN, "failed to send() complete Recipient, truncated to %d characters ", r);
		    r = recv(sock, &retval, 1, 0);
		    if (r < 0)
			mydebug(DBG_FATAL,
				"failed to recv() ok for recip info: %s",
				strerror(errno));
		}
	    } else {		/* lda != 0 */
		/* LDA specified */
		if (lda == i + 1) {
		    mydebug(DBG_INFO, "sendlda() %s", argv[i]);
		    r = send(sock, &_LDA, 1, 0);
		} else {
		    mydebug(DBG_INFO, "sendlda/arg() %s", argv[i]);
		    r = send(sock, argv[i], strlen(argv[i]), 0);
		}
		if (r < 0)
		    mydebug(DBG_FATAL, "failed to send/lda() recip info: %s",
			    strerror(errno));
		else {
		    r = recv(sock, &retval, 1, 0);
		    if (r < 0)
			mydebug(DBG_FATAL,
				"failed to recv() ok for recip/lda info: %s",
				strerror(errno));
		}

	    }			/* else lda != 0 */
	}
    }
    if (r >= 0) {
	mydebug(DBG_INFO, "sendEOT()");
	r = send(sock, &_EOT, 1, 0);
	/* send "end of args" msg */
	if (r < 0)
	    mydebug(DBG_FATAL, "failed to send() EOT: %s", strerror(errno));
	else {
	    r = recv(sock, xstat, 6, 0);
	    mydebug(DBG_INFO, "received %s from daemon", xstat);
	    if (r < 0)
		mydebug(DBG_FATAL, "Failed to recv() final result: %s",
			strerror(errno));
	    else if (!r)
		mydebug(DBG_FATAL, "Failed to recv() final result: empty status string");
	    /* get back final result */
	}
    }
    close(sock);
    mydebug(DBG_INFO, "finished conversation");
    if (r < 0) {
	/* housekeeping */
	unlink(atmpfile);
	rmdir(dirname);
	mydebug(DBG_FATAL, "failing with EX_TEMPFAIL: %s", strerror(errno));
	exit(EX_TEMPFAIL);
	/* some point of the communication failed miserably - so give up */
    }

    /* Protect against empty return string */
    if (*xstat)
	retval = atoi(xstat);
    else
	retval = 1;

    mydebug(DBG_INFO, "retval is %d\n", retval);

    if (retval)
	exit(EX_TEMPFAIL);

    exit(retval);
}
