/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.SortComparator;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolRedefinitionException;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Utilities {
    public static final String s_self = "self";
    public static final String s_exception = "_ex";
    private static final String s_exceptionFundamentalType = BabelConfiguration.getBaseExceptionType();

    public static ArrayList sort(Collection collection) {
        Object[] objs = collection.toArray();
        Arrays.sort(objs, new SortComparator());
        ArrayList<Object> sorted = new ArrayList<Object>(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            sorted.add(objs[i]);
        }
        return sorted;
    }

    public static int getWidth(Collection collection) {
        int width = 0;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Map.Entry m;
            Object key;
            Object obj = i.next();
            int w = 0;
            if (obj instanceof String) {
                w = ((String)obj).length();
            } else if (obj instanceof Method) {
                w = ((Method)obj).getLongMethodName().length();
            } else if (obj instanceof SymbolID) {
                w = ((SymbolID)obj).getFullName().length();
            } else if (obj instanceof Symbol) {
                w = ((Symbol)obj).getFullName().length();
            } else if (obj instanceof Map.Entry && (key = (m = (Map.Entry)obj).getKey()) instanceof String) {
                w = ((String)key).length();
            }
            if (w <= width) continue;
            width = w;
        }
        return width;
    }

    public static Set getUniqueInterfaces(Class cls) {
        HashSet unique = new HashSet(cls.getParentInterfaces(true));
        Class parent = cls.getParentClass();
        if (parent != null) {
            unique.removeAll(parent.getParentInterfaces(true));
        }
        return unique;
    }

    public static Set getUniqueInterfaceIDs(Class cls) {
        Set unique = Utilities.getUniqueInterfaces(cls);
        HashSet<SymbolID> ids = new HashSet<SymbolID>();
        Iterator p = unique.iterator();
        while (p.hasNext()) {
            ids.add(((Interface)p.next()).getSymbolID());
        }
        return ids;
    }

    public static Set getAllParents(Class cls) {
        HashSet<SymbolID> parents = new HashSet<SymbolID>();
        Collection interfaces = cls.getParentInterfaces(true);
        Iterator p = interfaces.iterator();
        while (p.hasNext()) {
            parents.add(((Interface)p.next()).getSymbolID());
        }
        for (Class parent = cls.getParentClass(); parent != null; parent = parent.getParentClass()) {
            parents.add(parent.getSymbolID());
        }
        return parents;
    }

    public static Symbol lookupSymbol(SymbolID id) throws CodeGenerationException {
        Symbol symbol = null;
        try {
            symbol = SymbolTable.getInstance().resolveSymbol(id);
        }
        catch (SymbolRedefinitionException ex) {
            throw new CodeGenerationException(ex.getMessage());
        }
        if (symbol == null) {
            throw new CodeGenerationException("Symbol \"" + id.getSymbolName() + "\" not found in symbol repository");
        }
        return symbol;
    }

    public static Symbol lookupSymbol(String fqn) throws CodeGenerationException {
        Symbol symbol = SymbolTable.getInstance().resolveSymbol(fqn);
        if (symbol == null) {
            throw new CodeGenerationException("Symbol \"" + fqn + "\" not found in symbol repository");
        }
        return symbol;
    }

    public static Collection convertIdsToSymbols(Collection symbolIDs) {
        SymbolTable table = SymbolTable.getInstance();
        ArrayList<Symbol> symbols = new ArrayList<Symbol>(symbolIDs.size());
        Iterator i = symbolIDs.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            symbols.add(table.lookupSymbol(id));
        }
        return symbols;
    }

    public static String replace(String source, String from, String to) {
        StringTokenizer tokens = new StringTokenizer(source, from);
        StringBuffer buf = new StringBuffer();
        int length = tokens.countTokens();
        buf.append(tokens.nextToken());
        for (int i = 1; i < length; ++i) {
            buf.append(to);
            buf.append(tokens.nextToken());
        }
        return buf.toString();
    }

    public static boolean isPointer(Type t) {
        switch (t.getDetailedType()) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static List extendArgs(SymbolID selfId, Method m, boolean indices) throws CodeGenerationException {
        boolean addExcept;
        boolean addSelf;
        ArrayList origArgs = null;
        origArgs = indices ? m.getArgumentListWithIndices() : m.getArgumentListWithOutIndices();
        int newSize = origArgs.size();
        boolean bl = addSelf = 3 != m.getDefinitionModifier();
        if (addSelf) {
            ++newSize;
        }
        boolean bl2 = addExcept = !m.getThrows().isEmpty();
        if (addExcept) {
            ++newSize;
        }
        ArrayList<Argument> result = new ArrayList<Argument>(newSize);
        if (addSelf) {
            result.add(new Argument(false, 0, new Type(selfId), s_self));
        }
        result.addAll(origArgs);
        if (addExcept) {
            Symbol ex = Utilities.lookupSymbol(s_exceptionFundamentalType);
            result.add(new Argument(false, 2, new Type(ex.getSymbolID()), s_exception));
        }
        return result;
    }
}

