/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.LevelComparator;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.python.Python;
import gov.llnl.babel.backend.python.TranslateArguments;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class PythonClientCSource {
    private String d_shortName = null;
    private Set d_includedFiles;
    private Extendable d_ext = null;
    private LanguageWriterForC d_lw = null;
    private SymbolTable d_symtab = null;
    private Collection d_references = null;
    private boolean d_hasStaticMethods;
    private boolean d_isBaseInterface;
    private String[] d_externalMethods;

    public PythonClientCSource(Extendable ext) {
        Type extType = new Type(ext.getSymbolID());
        this.d_ext = ext;
        this.d_shortName = this.d_ext.getSymbolID().getShortName();
        this.d_symtab = SymbolTable.getInstance();
        this.d_references = Utilities.convertIdsToSymbols(ext.getSymbolReferences());
        this.d_hasStaticMethods = this.d_ext.hasStaticMethod(true);
        this.d_includedFiles = new HashSet();
        this.d_isBaseInterface = BabelConfiguration.getBaseInterface().equals(ext.getFullName());
        if (this.d_isBaseInterface) {
            this.d_externalMethods = new String[10];
            this.d_externalMethods[9] = Python.getBorrowArrayFromSIDL(null);
        } else {
            this.d_externalMethods = new String[9];
        }
        this.d_externalMethods[0] = Python.getExtendableWrapper(this.d_ext);
        this.d_externalMethods[1] = Python.getExtendableConverter(this.d_ext);
        this.d_externalMethods[2] = Python.getBorrowArrayFromPython(extType);
        this.d_externalMethods[3] = Python.getBorrowArrayFromSIDL(extType);
        this.d_externalMethods[4] = Python.getExtendableBorrow(this.d_ext);
        this.d_externalMethods[5] = Python.getExtendableDeref(this.d_ext);
        this.d_externalMethods[6] = Python.getExtendableNewRef(this.d_ext);
        this.d_externalMethods[7] = Python.getExtendableAddRef(this.d_ext);
        this.d_externalMethods[8] = Python.getExtendableType(this.d_ext);
    }

    private void explainExtensionSource() {
        this.d_lw.beginBlockComment(false);
        this.d_lw.println("THIS CODE IS AUTOMATICALLY GENERATED BY THE BABEL");
        this.d_lw.println("COMPILER. DO NOT EDIT THIS!");
        this.d_lw.println();
        this.d_lw.println("This file contains the implementation of a Python C");
        this.d_lw.println("extension type (i.e. a Python type implemented in C).");
        this.d_lw.println("This extension type provides Python interface to the");
        this.d_lw.print("sidl type ");
        this.d_lw.print(this.d_ext.getFullName());
        this.d_lw.println(".");
        this.d_lw.endBlockComment(false);
        this.d_lw.println();
    }

    private void addInclude(String filename, boolean useGuard) {
        if (!this.d_includedFiles.contains(filename)) {
            this.d_includedFiles.add(filename);
            this.d_lw.generateInclude(filename, useGuard);
        }
    }

    private void includeHeaderFiles() {
        this.d_lw.printUnformatted("#define ");
        this.d_lw.printUnformatted(Python.getInternalGuard(this.d_ext));
        this.d_lw.printlnUnformatted(" 1");
        this.addInclude(Python.getCHeaderPath(this.d_ext, "Module"), false);
        this.addInclude(IOR.getHeaderFile(this.d_ext.getSymbolID()), true);
        this.addInclude("sidlObjA.h", false);
        this.addInclude("sidlPyArrays.h", false);
        this.addInclude("Numeric/arrayobject.h", false);
        this.addInclude("sidl_Loader.h", true);
        this.addInclude("sidl_header.h", true);
        this.addInclude("sidl_interface_IOR.h", true);
        Iterator i = this.d_references.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            if (11 == sym.getSymbolType()) continue;
            this.addInclude(Python.getCHeaderPath(sym, "Module"), false);
        }
        this.d_lw.printlnUnformatted("#include <stdlib.h>");
        this.d_lw.printlnUnformatted("#include <string.h>");
        this.d_lw.println();
    }

    private boolean isException() {
        Symbol exceptionInterface = this.d_symtab.lookupSymbol(BabelConfiguration.getBaseExceptionInterface());
        Symbol exceptionClass = this.d_symtab.lookupSymbol(BabelConfiguration.getBaseExceptionClass());
        SymbolID exceptionCID = null;
        SymbolID exceptionIID = null;
        if (exceptionClass != null) {
            exceptionCID = exceptionClass.getSymbolID();
        }
        if (exceptionInterface != null) {
            exceptionIID = exceptionInterface.getSymbolID();
        }
        if (exceptionCID != null && exceptionIID != null) {
            if (this.d_ext instanceof Class) {
                return this.d_ext.getSymbolID().equals(exceptionCID) || ((Class)this.d_ext).hasParentClass(exceptionCID, true) || this.d_ext.hasParentInterface(exceptionIID, true);
            }
            if (this.d_ext instanceof Interface) {
                return this.d_ext.getSymbolID().equals(exceptionIID) || this.d_ext.hasParentInterface(exceptionIID, true);
            }
        }
        return false;
    }

    private void staticMethods() {
        this.d_lw.println("staticforward PyTypeObject _" + this.d_ext.getFullName().replace('.', '_') + "Type;");
        this.d_lw.println();
        if (this.d_hasStaticMethods) {
            this.d_lw.print("static ");
            this.d_lw.print(IOR.getSEPVName(this.d_ext.getSymbolID()));
            this.d_lw.print(" *_sepv");
            this.d_lw.println(" = NULL;");
            this.d_lw.println();
        }
        if (!this.d_ext.isInterface()) {
            this.d_lw.println("static const " + IOR.getExternalName(this.d_ext.getSymbolID()) + " *_implEPV = NULL;");
            this.d_lw.println();
        }
    }

    private void pythonCastSignature() {
        this.d_lw.println("static int");
        this.d_lw.println(this.d_ext.getFullName().replace('.', '_') + "_createCast(PyObject *self, PyObject *args, PyObject *kwds) {");
        this.d_lw.tab();
    }

    private void pythonCastInArguments() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_lw.print(IOR.getObjectName(id));
        this.d_lw.println(" *optarg = NULL;");
        this.d_lw.println("static char *_kwlist[] = { \"sobj\", NULL };");
        this.d_lw.print("int _okay = PyArg_ParseTupleAndKeywords(args, kwds, \"");
        if (!this.d_ext.isAbstract()) {
            this.d_lw.print("|");
        }
        this.d_lw.print("O&\", _kwlist, (void *)");
        this.d_lw.print(Python.getExtendableConverter(this.d_ext));
        this.d_lw.println(", &optarg);");
    }

    private void pythonCastCreate() {
        if (!this.d_ext.isAbstract()) {
            this.d_lw.println("if (!optarg) {");
            this.d_lw.tab();
            this.d_lw.print("optarg = (*(_implEPV->createObject))");
            this.d_lw.println("();");
            this.d_lw.backTab();
            this.d_lw.println("}");
        }
    }

    private void pythonCastWrapAndReturn() {
        this.d_lw.println("return sidl_Object_Init(");
        this.d_lw.tab();
        this.d_lw.println("(SPObject *)self,");
        if (this.d_ext.isInterface()) {
            this.d_lw.println("(struct sidl_BaseInterface__object *)optarg->d_object,");
        } else {
            this.d_lw.println("(struct sidl_BaseInterface__object *)optarg,");
        }
        this.d_lw.println("sidl_PyStealRef);");
        this.d_lw.backTab();
    }

    private void pythonCastConstructor() {
        SymbolID id = this.d_ext.getSymbolID();
        this.pythonCastSignature();
        this.pythonCastInArguments();
        this.d_lw.println("if (_okay) {");
        this.d_lw.tab();
        this.pythonCastCreate();
        this.pythonCastWrapAndReturn();
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("return -1;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void pythonDocComment() {
        if (this.d_ext.getComment() != null && this.d_ext.getComment().getComment() != null) {
            this.copyComment(this.d_ext.getComment());
        } else {
            this.d_lw.printlnUnformatted("SIDL wrapper for the " + this.d_ext.getFullName() + " type.\\");
        }
    }

    private void writePythonType() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_lw.println("static PyTypeObject _" + id.getFullName().replace('.', '_') + "Type = {");
        this.d_lw.tab();
        this.d_lw.println("PyObject_HEAD_INIT(NULL)");
        this.d_lw.println("0,      /* ob_size */");
        this.d_lw.println("\"" + id.getFullName() + "\", /* tp_name */");
        this.d_lw.println("0,      /* tp_basicsize */");
        this.d_lw.println("0,      /* tp_itemsize */");
        this.d_lw.println("0,      /* tp_dealloc */");
        this.d_lw.println("0,      /* tp_print */");
        this.d_lw.println("0,      /* tp_getattr */");
        this.d_lw.println("0,      /* tp_setattr */");
        this.d_lw.println("0,      /* tp_compare */");
        this.d_lw.println("0,      /* tp_repr */");
        this.d_lw.println("0,      /* tp_as_number */");
        this.d_lw.println("0,      /* tp_as_sequence */");
        this.d_lw.println("0,      /* tp_as_mapping */");
        this.d_lw.println("0,      /* tp_hash  */");
        this.d_lw.println("0,      /* tp_call */");
        this.d_lw.println("0,      /* tp_str */");
        this.d_lw.println("0,      /* tp_getattro */");
        this.d_lw.println("0,      /* tp_setattro */");
        this.d_lw.println("0,      /* tp_as_buffer */");
        this.d_lw.println("Py_TPFLAGS_DEFAULT, /* tp_flags */");
        this.d_lw.println("\"\\");
        this.pythonDocComment();
        this.d_lw.printlnUnformatted("\", /* tp_doc */");
        this.d_lw.println("0,      /* tp_traverse */");
        this.d_lw.println("0,       /* tp_clear */");
        this.d_lw.println("0,       /* tp_richcompare */");
        this.d_lw.println("0,       /* tp_weaklistoffset */");
        this.d_lw.println("0,       /* tp_iter */");
        this.d_lw.println("0,       /* tp_iternext */");
        this.d_lw.println("_" + this.d_shortName + "ObjectMethods, /* tp_methods */");
        this.d_lw.println("0,       /* tp_members */");
        this.d_lw.println("0,       /* tp_getset */");
        this.d_lw.println("0,       /* tp_base */");
        this.d_lw.println("0,       /* tp_dict */");
        this.d_lw.println("0,       /* tp_descr_get */");
        this.d_lw.println("0,       /* tp_descr_set */");
        this.d_lw.println("0,       /* tp_dictoffset */");
        this.d_lw.println(id.getFullName().replace('.', '_') + "_createCast,   /* tp_init */");
        this.d_lw.println("0,       /* tp_alloc */");
        this.d_lw.println("0,       /* tp_new */");
        this.d_lw.backTab();
        this.d_lw.println("};");
        this.d_lw.println();
    }

    private void writeMethodSignature(Method m) {
        this.d_lw.println("static PyObject *");
        this.d_lw.print(Python.getStubMethod(this.d_ext.getSymbolID(), m));
        if (m.isStatic()) {
            this.d_lw.println("(PyObject *_ignored, PyObject *_args, PyObject *_kwdict) {");
        } else {
            this.d_lw.println("(PyObject *_self, PyObject *_args, PyObject *_kwdict) {");
        }
        this.d_lw.tab();
        this.d_lw.println("PyObject *_return_value = NULL;");
        if (!m.isStatic()) {
            SymbolID id = this.d_ext.getSymbolID();
            this.d_lw.print(IOR.getObjectName(id));
            this.d_lw.println(" *_self_ior =");
            this.d_lw.tab();
            this.d_lw.print("((");
            this.d_lw.print(IOR.getObjectName(id));
            this.d_lw.println(" *)");
            this.d_lw.print(" sidl_Cast(_self, \"");
            this.d_lw.print(id.getFullName());
            this.d_lw.println("\"));");
            this.d_lw.backTab();
            this.d_lw.println("if (_self_ior) {");
            this.d_lw.tab();
        }
    }

    private void declareVariable(Type t, String name, int mode) throws CodeGenerationException {
        this.d_lw.print(IOR.getReturnString(t));
        this.d_lw.print(" ");
        this.d_lw.print(name);
        if (Utilities.isPointer(t)) {
            this.d_lw.print(" = NULL");
        } else if (t.getDetailedType() == 3) {
            this.d_lw.print(" = { 0.0, 0.0 }");
        } else if (t.getDetailedType() == 5) {
            this.d_lw.print(" = { 0.0, 0.0 }");
        } else {
            this.d_lw.print(" = (" + IOR.getReturnString(t) + ") 0");
        }
        this.d_lw.println(";");
    }

    private void declareArguments(Method m) throws CodeGenerationException {
        Iterator i = m.getArgumentList().iterator();
        while (i.hasNext()) {
            Argument arg = (Argument)i.next();
            this.declareVariable(arg.getType(), arg.getFormalName(), arg.getMode());
        }
        if (!m.getThrows().isEmpty()) {
            this.d_lw.print(IOR.getExceptionFundamentalType());
            this.d_lw.println("_exception = NULL;");
        }
    }

    private boolean hasReturn(Method m) {
        if (m.getReturnType().getType() != 0) {
            return true;
        }
        Iterator i = m.getArgumentList().iterator();
        while (i.hasNext()) {
            if (!PythonClientCSource.isOutgoing((Argument)i.next())) continue;
            return true;
        }
        return false;
    }

    private static final boolean isOutgoing(Argument arg) {
        int mode = arg.getMode();
        return mode == 2 || mode == 1;
    }

    private static final boolean isIncoming(Argument arg) {
        int mode = arg.getMode();
        return mode == 0 || mode == 1;
    }

    private void listArgumentNames(Method m) {
        Iterator i = m.getArgumentList().iterator();
        this.d_lw.println("static char *_kwlist[] = {");
        this.d_lw.tab();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            if (!PythonClientCSource.isIncoming(a)) continue;
            this.d_lw.print("\"");
            this.d_lw.print(a.getFormalName());
            this.d_lw.println("\",");
        }
        this.d_lw.println("NULL");
        this.d_lw.backTab();
        this.d_lw.println("};");
    }

    private void callMethod(Method m, boolean isInterface) {
        boolean addComma = false;
        if (m.getReturnType().getType() != 0) {
            this.d_lw.print("_return = ");
        }
        if (m.isStatic()) {
            this.d_lw.print("(*(_sepv->");
        } else {
            this.d_lw.print("(*(_self_ior->d_epv->");
        }
        this.d_lw.print(IOR.getVectorEntry(m.getLongMethodName()));
        this.d_lw.print("))(");
        if (!m.isStatic()) {
            if (isInterface) {
                this.d_lw.print("_self_ior->d_object");
            } else {
                this.d_lw.print("_self_ior");
            }
            addComma = true;
        }
        Iterator i = m.getArgumentList().iterator();
        while (i.hasNext()) {
            Argument arg = (Argument)i.next();
            if (addComma) {
                this.d_lw.print(", ");
            }
            if (PythonClientCSource.isOutgoing(arg)) {
                this.d_lw.print("&");
            }
            this.d_lw.print(arg.getFormalName());
            addComma = true;
        }
        if (!m.getThrows().isEmpty()) {
            if (addComma) {
                this.d_lw.print(", ");
            }
            this.d_lw.print("&_exception");
            addComma = true;
        }
        this.d_lw.println(");");
    }

    private void processExceptions(Method m) throws CodeGenerationException {
        int i;
        Object[] exceptions = m.getThrows().toArray();
        Arrays.sort(exceptions, new LevelComparator(this.d_symtab));
        for (i = 0; i < exceptions.length; ++i) {
            this.d_lw.print(IOR.getObjectName((SymbolID)exceptions[i]));
            this.d_lw.print(" *_ex");
            this.d_lw.print(Integer.toString(i));
            this.d_lw.println(";");
        }
        for (i = 0; i < exceptions.length; ++i) {
            SymbolID id = (SymbolID)exceptions[i];
            Symbol sym = this.d_symtab.lookupSymbol(id);
            if (i > 0) {
                this.d_lw.print("else ");
            }
            this.d_lw.print("if ((_ex");
            this.d_lw.print(Integer.toString(i));
            this.d_lw.print(" = ");
            this.d_lw.print("(");
            this.d_lw.print(IOR.getObjectName(id));
            this.d_lw.println(" *)");
            this.d_lw.tab();
            this.d_lw.print("sidl_PyExceptionCast(_exception, \"");
            this.d_lw.print(id.getFullName());
            this.d_lw.println("\")))");
            this.d_lw.backTab();
            this.d_lw.println("{");
            this.d_lw.tab();
            this.d_lw.print("PyObject *obj = ");
            this.d_lw.print(Python.getExtendableWrapper(sym));
            this.d_lw.print("(_ex");
            this.d_lw.print(Integer.toString(i));
            this.d_lw.println(");");
            this.d_lw.print("PyErr_SetObject(");
            this.d_lw.print(Python.getExceptionType(sym));
            this.d_lw.println(", obj);");
            this.d_lw.println("Py_XDECREF(obj);");
            this.d_lw.backTab();
            this.d_lw.println("}");
        }
    }

    private void processReturnValues(Method m, TranslateArguments translator) throws CodeGenerationException {
        boolean hasThrows;
        boolean bl = hasThrows = !m.getThrows().isEmpty();
        if (hasThrows) {
            this.d_lw.println("if (_exception) {");
            this.d_lw.tab();
            this.processExceptions(m);
            this.d_lw.backTab();
            this.d_lw.println("}");
            this.d_lw.println("else {");
            this.d_lw.tab();
        }
        if (this.hasReturn(m)) {
            this.d_lw.print("_return_value = ");
            translator.setConvertIncoming(false);
            translator.convertSidlToPython();
        } else {
            this.d_lw.println("_return_value = Py_None;");
            this.d_lw.println("Py_INCREF(_return_value);");
        }
        if (hasThrows) {
            this.d_lw.backTab();
            this.d_lw.println("}");
        }
    }

    private void writeMethodClosing(Method m) {
        if (!m.isStatic()) {
            this.d_lw.backTab();
            this.d_lw.println("}");
            this.d_lw.println("else {");
            this.d_lw.tab();
            this.d_lw.println("PyErr_SetString(PyExc_TypeError, ");
            this.d_lw.tab();
            this.d_lw.disableLineBreak();
            this.d_lw.print("\"self pointer is not a ");
            this.d_lw.print(this.d_ext.getFullName());
            this.d_lw.println("\");");
            this.d_lw.enableLineBreak();
            this.d_lw.backTab();
            this.d_lw.backTab();
            this.d_lw.println("}");
        }
        this.d_lw.println("return _return_value;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void declareReturnValue(Method m, TranslateArguments translator) throws CodeGenerationException {
        if (m.getReturnType().getType() != 0) {
            this.declareVariable(m.getReturnType(), "_return", 2);
            translator.declareProxy(m.getReturnType(), "_return", 2);
        }
    }

    private void destroyArrayArg(Type arrayType, String argName) {
        this.d_lw.print(Python.getDestroyArray(arrayType));
        this.d_lw.print("((struct sidl__array *)");
        this.d_lw.print(argName);
        this.d_lw.println(");");
    }

    private void cleanUpArguments(Method m) throws CodeGenerationException {
        Iterator i = m.getArgumentList().iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            switch (a.getType().getDetailedType()) {
                case 10: {
                    if (!PythonClientCSource.isOutgoing(a)) break;
                    this.d_lw.print("free((void *)");
                    this.d_lw.print(a.getFormalName());
                    this.d_lw.println(");");
                    break;
                }
                case 12: 
                case 13: {
                    if (0 != a.getMode()) break;
                    Extendable ext = (Extendable)Utilities.lookupSymbol(a.getType().getSymbolID());
                    this.d_lw.println(Python.getExtendableDeref(ext) + "(" + a.getFormalName() + ");");
                    break;
                }
                case 16: {
                    this.destroyArrayArg(a.getType().getArrayType(), a.getFormalName());
                }
            }
        }
        if (10 == m.getReturnType().getType()) {
            this.d_lw.println("free((void *)_return);");
        } else if (16 == m.getReturnType().getType()) {
            this.destroyArrayArg(m.getReturnType().getArrayType(), "_return");
        }
    }

    private void convertMethod(Method m, boolean isInterface) throws CodeGenerationException {
        TranslateArguments translator = new TranslateArguments(this.d_lw, m, true, true);
        this.writeMethodSignature(m);
        this.declareArguments(m);
        translator.declareProxies();
        this.listArgumentNames(m);
        translator.setBorrowArrays(true);
        translator.setConvertIncoming(true);
        this.d_lw.print("const int _okay = ");
        translator.convertPythonToSidl("_args", "_kwdict", "_kwlist");
        this.d_lw.println("if (_okay) {");
        this.d_lw.tab();
        this.declareReturnValue(m, translator);
        translator.convertIncomingArguments(false);
        this.callMethod(m, isInterface);
        translator.setConvertIncoming(false);
        translator.setBorrowArrays(false);
        translator.convertOutgoingArguments(true);
        this.processReturnValues(m, translator);
        this.cleanUpArguments(m);
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.writeMethodClosing(m);
    }

    private Collection pythonMethodList(boolean includeStatics) {
        HashSet localMethods = new HashSet(includeStatics ? this.d_ext.getMethods(false) : this.d_ext.getNonstaticMethods(false));
        if (!localMethods.isEmpty()) {
            Iterator i = this.d_ext.getParentInterfaces(false).iterator();
            while (!localMethods.isEmpty() && i.hasNext()) {
                localMethods.removeAll(((Extendable)i.next()).getNonstaticMethods(true));
            }
        }
        return localMethods;
    }

    private void convertMethods(boolean isInterface) throws CodeGenerationException {
        Iterator i = this.pythonMethodList(true).iterator();
        while (i.hasNext()) {
            this.convertMethod((Method)i.next(), isInterface);
        }
    }

    private void copyComment(Comment c) {
        String[] lines;
        if (c != null && (lines = c.getComment()) != null) {
            int i = 0;
            this.d_lw.printlnUnformatted("\\");
            while (i < lines.length) {
                this.d_lw.printUnformatted(LanguageWriterForC.toSafeString(lines[i]));
                if (++i >= lines.length) continue;
                this.d_lw.printlnUnformatted("\\n\\");
            }
        }
    }

    private void documentMethod(Method m) {
        this.d_lw.printlnUnformatted("\"\\");
        this.printMethodSignature(m);
        if (m.getComment() != null && m.getComment().getComment() != null) {
            this.d_lw.printlnUnformatted("\\n\\");
            this.copyComment(m.getComment());
        }
        this.d_lw.printlnUnformatted("\"");
    }

    private String indentString(int width) {
        StringBuffer buf = new StringBuffer(width);
        while (width-- > 0) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private void writeArgumentList(Iterator args, int excluding, int indent, boolean notFirst) {
        String indStr = this.indentString(indent);
        while (args.hasNext()) {
            Argument a = (Argument)args.next();
            if (excluding == a.getMode()) continue;
            if (notFirst) {
                this.d_lw.printlnUnformatted(",\\n\\");
                this.d_lw.printUnformatted(indStr);
            } else {
                notFirst = true;
            }
            this.d_lw.printUnformatted(a.getArgumentString());
        }
        this.d_lw.printlnUnformatted(")\\n\\");
    }

    private void printMethodSignature(Method m) {
        String name = m.getLongMethodName();
        this.d_lw.printUnformatted(name + "(");
        this.writeArgumentList(m.getArgumentList().iterator(), 2, name.length() + 1, false);
        this.d_lw.printlnUnformatted("RETURNS\\n\\");
        if (this.hasReturn(m)) {
            this.d_lw.printUnformatted("   (");
            if (m.getReturnType().getType() != 0) {
                this.d_lw.printUnformatted(m.getReturnType().getTypeString() + " _return");
            }
            this.writeArgumentList(m.getArgumentList().iterator(), 0, 4, m.getReturnType().getType() != 0);
        } else {
            this.d_lw.printlnUnformatted("    None\\n\\");
        }
        if (!m.getThrows().isEmpty()) {
            Iterator i = m.getThrows().iterator();
            this.d_lw.printlnUnformatted("RAISES\\n\\");
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                this.d_lw.printUnformatted("    ");
                this.d_lw.printUnformatted(id.getFullName());
                this.d_lw.printlnUnformatted("\\n\\");
            }
        }
    }

    private void makeVirtualTable(Iterator i) {
        SymbolID id = this.d_ext.getSymbolID();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            this.d_lw.print("{ \"");
            this.d_lw.print(m.getLongMethodName());
            this.d_lw.print("\", (PyCFunction)");
            this.d_lw.print(Python.getStubMethod(id, m));
            this.d_lw.println(",");
            this.d_lw.println("(METH_VARARGS | METH_KEYWORDS),");
            this.documentMethod(m);
            this.d_lw.println(" },");
        }
    }

    private void pythonStaticVirtualTable() {
        this.d_lw.print("static PyMethodDef _");
        this.d_lw.print(this.d_shortName);
        this.d_lw.println("ModuleMethods[] = {");
        this.d_lw.tab();
        this.makeVirtualTable(Utilities.sort(this.d_ext.getStaticMethods(false)).iterator());
        this.d_lw.println("{ NULL, NULL }");
        this.d_lw.backTab();
        this.d_lw.println("};");
        this.d_lw.println();
    }

    private void pythonObjectVirtualTable() {
        this.d_lw.print("static PyMethodDef _");
        this.d_lw.print(this.d_shortName);
        this.d_lw.println("ObjectMethods[] = {");
        this.d_lw.tab();
        this.makeVirtualTable(Utilities.sort(this.pythonMethodList(false)).iterator());
        this.d_lw.println("{ NULL, NULL }");
        this.d_lw.backTab();
        this.d_lw.println("};");
        this.d_lw.println();
    }

    private void wrapperMethod() {
        SymbolID id = this.d_ext.getSymbolID();
        String fullname = id.getFullName();
        String wrapper = Python.getExtendableWrapper(this.d_ext);
        this.d_lw.print(wrapper);
        this.d_lw.println("_RETURN");
        this.d_lw.print(wrapper);
        this.d_lw.print(" ");
        this.d_lw.print(wrapper);
        this.d_lw.println("_PROTO {");
        this.d_lw.tab();
        this.d_lw.println("PyObject *result;");
        this.d_lw.println("if (sidlobj) {");
        this.d_lw.tab();
        this.d_lw.println("result = _" + id.getFullName().replace('.', '_') + "Type.tp_new(&_" + id.getFullName().replace('.', '_') + "Type, NULL, NULL);");
        this.d_lw.println("if (result) {");
        this.d_lw.tab();
        this.d_lw.println("if (sidl_Object_Init(");
        this.d_lw.tab();
        this.d_lw.println("(SPObject *)result,");
        this.d_lw.println("(" + IOR.getInterfaceType() + ")(sidlobj" + (this.d_ext.isInterface() ? "->d_object)," : "),"));
        this.d_lw.println("sidl_PyStealRef))");
        this.d_lw.backTab();
        this.d_lw.println("{");
        this.d_lw.tab();
        this.d_lw.println("Py_DECREF(result);");
        this.d_lw.println("result = NULL;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("else {");
        this.d_lw.tab();
        this.d_lw.println("result = Py_None;");
        this.d_lw.println("Py_INCREF(result);");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("return result;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void derefMethod() {
        SymbolID id = this.d_ext.getSymbolID();
        String fullname = id.getFullName();
        String deref = Python.getExtendableDeref(this.d_ext);
        this.d_lw.print(deref);
        this.d_lw.println("_RETURN");
        this.d_lw.print(deref);
        this.d_lw.print(" ");
        this.d_lw.print(deref);
        this.d_lw.println("_PROTO {");
        this.d_lw.tab();
        this.d_lw.println("if (sidlobj) {");
        this.d_lw.tab();
        if (this.d_ext.isInterface()) {
            this.d_lw.println("(*(sidlobj->d_epv->" + IOR.getVectorEntry("deleteRef") + "))(sidlobj->d_object);");
        } else {
            this.d_lw.println("(*(sidlobj->d_epv->" + IOR.getVectorEntry("deleteRef") + "))(sidlobj);");
        }
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void borrowMethod() {
        SymbolID id = this.d_ext.getSymbolID();
        String fullname = id.getFullName();
        String borrow = Python.getExtendableBorrow(this.d_ext);
        this.d_lw.print(borrow);
        this.d_lw.println("_RETURN");
        this.d_lw.print(borrow);
        this.d_lw.print(" ");
        this.d_lw.print(borrow);
        this.d_lw.println("_PROTO {");
        this.d_lw.tab();
        this.d_lw.println("PyObject *result;");
        this.d_lw.println("if (sidlobj) {");
        this.d_lw.tab();
        this.d_lw.println("result = _" + id.getFullName().replace('.', '_') + "Type.tp_new(&_" + id.getFullName().replace('.', '_') + "Type, NULL, NULL);");
        this.d_lw.println("if (result) {");
        this.d_lw.tab();
        this.d_lw.println("if (sidl_Object_Init(");
        this.d_lw.tab();
        this.d_lw.println("(SPObject *)result,");
        this.d_lw.println("(" + IOR.getInterfaceType() + ")(sidlobj" + (this.d_ext.isInterface() ? "->d_object)," : "),"));
        this.d_lw.println("sidl_PyWeakRef))");
        this.d_lw.backTab();
        this.d_lw.println("{");
        this.d_lw.tab();
        this.d_lw.println("Py_DECREF(result);");
        this.d_lw.println("result = NULL;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("else {");
        this.d_lw.tab();
        this.d_lw.println("result = Py_None;");
        this.d_lw.println("Py_INCREF(result);");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("return result;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void newRefMethod() {
        SymbolID id = this.d_ext.getSymbolID();
        String fullname = id.getFullName();
        String newRef = Python.getExtendableNewRef(this.d_ext);
        this.d_lw.print(newRef);
        this.d_lw.println("_RETURN");
        this.d_lw.print(newRef);
        this.d_lw.print(" ");
        this.d_lw.print(newRef);
        this.d_lw.println("_PROTO {");
        this.d_lw.tab();
        this.d_lw.println("PyObject *result;");
        this.d_lw.println("if (sidlobj) {");
        this.d_lw.tab();
        this.d_lw.println("result = _" + id.getFullName().replace('.', '_') + "Type.tp_new(&_" + id.getFullName().replace('.', '_') + "Type, NULL, NULL);");
        this.d_lw.println("if (result) {");
        this.d_lw.tab();
        this.d_lw.println("if (sidl_Object_Init(");
        this.d_lw.tab();
        this.d_lw.println("(SPObject *)result,");
        this.d_lw.println("(" + IOR.getInterfaceType() + ")(sidlobj" + (this.d_ext.isInterface() ? "->d_object)," : "),"));
        this.d_lw.println("sidl_PyNewRef))");
        this.d_lw.backTab();
        this.d_lw.println("{");
        this.d_lw.tab();
        this.d_lw.println("Py_DECREF(result);");
        this.d_lw.println("result = NULL;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("else {");
        this.d_lw.tab();
        this.d_lw.println("result = Py_None;");
        this.d_lw.println("Py_INCREF(result);");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("return result;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void addRefMethod() {
        SymbolID id = this.d_ext.getSymbolID();
        String fullname = id.getFullName();
        String addRef = Python.getExtendableAddRef(this.d_ext);
        this.d_lw.print(addRef);
        this.d_lw.println("_RETURN");
        this.d_lw.print(addRef);
        this.d_lw.print(" ");
        this.d_lw.print(addRef);
        this.d_lw.println("_PROTO {");
        this.d_lw.tab();
        this.d_lw.println("if (sidlobj) {");
        this.d_lw.tab();
        if (this.d_ext.isInterface()) {
            this.d_lw.println("(*(sidlobj->d_epv->" + IOR.getVectorEntry("addRef") + "))(sidlobj->d_object);");
        } else {
            this.d_lw.println("(*(sidlobj->d_epv->" + IOR.getVectorEntry("addRef") + "))(sidlobj);");
        }
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void typeMethod() {
        SymbolID id = this.d_ext.getSymbolID();
        String fullname = id.getFullName();
        String typeMethod = Python.getExtendableType(this.d_ext);
        this.d_lw.print(typeMethod);
        this.d_lw.println("_RETURN");
        this.d_lw.print(typeMethod);
        this.d_lw.print(" ");
        this.d_lw.print(typeMethod);
        this.d_lw.println("_PROTO {");
        this.d_lw.tab();
        this.d_lw.println("Py_INCREF(&_" + id.getFullName().replace('.', '_') + "Type);");
        this.d_lw.println("return &_" + id.getFullName().replace('.', '_') + "Type;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void converterMethod() {
        SymbolID id = this.d_ext.getSymbolID();
        String fullname = id.getFullName();
        String convert = Python.getExtendableConverter(this.d_ext);
        this.d_lw.print(convert);
        this.d_lw.println("_RETURN");
        this.d_lw.print(convert);
        this.d_lw.print(" ");
        this.d_lw.print(convert);
        this.d_lw.println("_PROTO {");
        this.d_lw.tab();
        this.d_lw.print("*sidlobj = sidl_Cast(obj, \"");
        this.d_lw.print(fullname);
        this.d_lw.println("\");");
        this.d_lw.println("if (*sidlobj) {");
        this.d_lw.tab();
        if (this.d_ext.isInterface()) {
            this.d_lw.println("(*((*sidlobj)->d_epv->" + IOR.getVectorEntry("addRef") + "))((*sidlobj)->d_object);");
        } else {
            this.d_lw.println("(*((*sidlobj)->d_epv->" + IOR.getVectorEntry("addRef") + "))(*sidlobj);");
        }
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("else if (obj != Py_None) {");
        this.d_lw.tab();
        this.d_lw.println("PyErr_SetString(PyExc_TypeError, ");
        this.d_lw.tab();
        this.d_lw.print("\"argument is not a(n) ");
        this.d_lw.print(fullname);
        this.d_lw.println("\");");
        this.d_lw.backTab();
        this.d_lw.println("return 0;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("return 1;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void convertAndStore() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_lw.println("static int");
        this.d_lw.println("_convertPython(void *sidlarray, const int *ind, PyObject *pyobj)");
        this.d_lw.println("{");
        this.d_lw.tab();
        this.d_lw.print(IOR.getObjectName(id));
        this.d_lw.println(" *sidlobj;");
        this.d_lw.print("if (");
        this.d_lw.print(Python.getExtendableConverter(this.d_ext));
        this.d_lw.println("(pyobj, &sidlobj)) {");
        this.d_lw.tab();
        this.d_lw.print("sidl_interface__array_set((struct sidl_interface__array *)");
        this.d_lw.println("sidlarray,");
        this.d_lw.println("ind, (struct sidl_BaseInterface__object *)sidlobj);");
        this.d_lw.println("if (sidlobj) {");
        this.d_lw.tab();
        this.d_lw.println("sidl_BaseInterface_deleteRef((struct sidl_BaseInterface__object *)sidlobj);");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("return FALSE;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("return TRUE;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void convertPythonArray() {
        SymbolID id = this.d_ext.getSymbolID();
        String convert = Python.getBorrowArrayFromPython(new Type(id));
        this.d_lw.print(convert);
        this.d_lw.println("_RETURN");
        this.d_lw.print(convert);
        this.d_lw.print(" ");
        this.d_lw.print(convert);
        this.d_lw.println("_PROTO {");
        this.d_lw.tab();
        this.d_lw.println("int result = 0;");
        this.d_lw.println("*sidlarray = NULL;");
        this.d_lw.println("if (obj == Py_None) {");
        this.d_lw.tab();
        this.d_lw.println("result = TRUE;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("else {");
        this.d_lw.tab();
        this.d_lw.println("PyObject *pya = PyArray_FromObject(obj, PyArray_OBJECT, 0, 0);");
        this.d_lw.println("if (pya) {");
        this.d_lw.tab();
        this.d_lw.println("if (PyArray_OBJECT == ((PyArrayObject *)pya)->descr->type_num) {");
        this.d_lw.tab();
        this.d_lw.println("int dimen, lower[SIDL_MAX_ARRAY_DIMENSION],");
        this.d_lw.tab();
        this.d_lw.println("upper[SIDL_MAX_ARRAY_DIMENSION],");
        this.d_lw.println("stride[SIDL_MAX_ARRAY_DIMENSION];");
        this.d_lw.backTab();
        this.d_lw.println("if (sidl_array__extract_python_info");
        this.d_lw.tab();
        this.d_lw.println("(pya, &dimen, lower, upper, stride))");
        this.d_lw.backTab();
        this.d_lw.println("{");
        this.d_lw.tab();
        this.d_lw.print("*sidlarray = (" + IOR.getArrayName(id) + "*)");
        this.d_lw.tab();
        this.d_lw.println("sidl_interface__array_createRow");
        this.d_lw.println("(dimen, lower, upper);");
        this.d_lw.backTab();
        this.d_lw.println("result = sidl_array__convert_python");
        this.d_lw.tab();
        this.d_lw.println("(pya, dimen, *sidlarray, _convertPython);");
        this.d_lw.backTab();
        this.d_lw.println("if (*sidlarray && !result) {");
        this.d_lw.tab();
        this.d_lw.println("sidl_interface__array_deleteRef(");
        this.d_lw.tab();
        this.d_lw.println("(struct  sidl_interface__array *)*sidlarray);");
        this.d_lw.backTab();
        this.d_lw.println("*sidlarray = NULL;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("Py_DECREF(pya);");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("return result;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void getAndConvert() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_lw.println("static int");
        this.d_lw.println("_convertSIDL(void *sidlarray, const int *ind, PyObject **dest)");
        this.d_lw.println("{");
        this.d_lw.tab();
        this.d_lw.print(IOR.getObjectName(id));
        this.d_lw.println(" *sidlobj = (" + IOR.getObjectName(id) + "*)");
        this.d_lw.println("sidl_interface__array_get((struct sidl_interface__array *)");
        this.d_lw.tab();
        this.d_lw.println("sidlarray, ind);");
        this.d_lw.backTab();
        this.d_lw.print("*dest = ");
        this.d_lw.print(Python.getExtendableWrapper(this.d_ext));
        this.d_lw.println("(sidlobj);");
        this.d_lw.println("return (*dest == NULL);");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void convertSIDLArray() {
        SymbolID id = this.d_ext.getSymbolID();
        String convert = Python.getBorrowArrayFromSIDL(new Type(id));
        this.d_lw.println(convert + "_RETURN");
        this.d_lw.println(convert + " " + convert + "_PROTO {");
        this.d_lw.tab();
        this.d_lw.println("PyObject *pya = NULL;");
        this.d_lw.println("if (sidlarray) {");
        this.d_lw.tab();
        this.d_lw.println("const int dimen = sidlArrayDim(sidlarray);");
        this.d_lw.println("int i;");
        this.d_lw.println("int *lower = (int *)malloc(sizeof(int) * dimen);");
        this.d_lw.println("int *upper = (int *)malloc(sizeof(int) * dimen);");
        this.d_lw.println("int *numelem = (int *)malloc(sizeof(int) * dimen);");
        this.d_lw.println("for(i = 0; i < dimen; ++i) {");
        this.d_lw.tab();
        this.d_lw.println("lower[i] = sidlLower(sidlarray, i);");
        this.d_lw.println("upper[i] = sidlUpper(sidlarray, i);");
        this.d_lw.println("numelem[i] = 1 + upper[i] - lower[i];");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("pya = PyArray_FromDims(dimen, numelem, PyArray_OBJECT);");
        this.d_lw.println("if (pya) {");
        this.d_lw.tab();
        this.d_lw.println("if (!sidl_array__convert_sidl(pya, dimen, lower, upper,");
        this.d_lw.tab();
        this.d_lw.println("numelem, sidlarray, _convertSIDL))");
        this.d_lw.backTab();
        this.d_lw.println("{");
        this.d_lw.tab();
        this.d_lw.println("Py_DECREF(pya);");
        this.d_lw.println("pya = NULL;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("free(numelem);");
        this.d_lw.println("free(upper);");
        this.d_lw.println("free(lower);");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("else {");
        this.d_lw.tab();
        this.d_lw.println("Py_INCREF(Py_None);");
        this.d_lw.println("pya = Py_None;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("return pya;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void convertGenericSIDL() {
        String convert = Python.getBorrowArrayFromSIDL(null);
        this.d_lw.println(convert + "_RETURN");
        this.d_lw.println(convert + " " + convert + "_PROTO {");
        this.d_lw.tab();
        this.d_lw.println("if (sidlarray &&");
        this.d_lw.tab();
        this.d_lw.println("(sidl_interface_array == sidl__array_type(sidlarray))) {");
        this.d_lw.println("return " + Python.getBorrowArrayFromSIDL(new Type(this.d_ext.getSymbolID())) + "(sidlarray);");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("else {");
        this.d_lw.tab();
        this.d_lw.println("return sidl_python_borrow_array(sidlarray);");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
    }

    private void externalMethods() {
        this.wrapperMethod();
        this.borrowMethod();
        this.derefMethod();
        this.newRefMethod();
        this.addRefMethod();
        this.typeMethod();
        this.converterMethod();
        this.convertAndStore();
        this.convertPythonArray();
        this.getAndConvert();
        if (this.d_isBaseInterface) {
            this.convertGenericSIDL();
        }
        this.convertSIDLArray();
    }

    private void preparePythonType() {
        Class parent;
        String typeObj = "_" + this.d_ext.getFullName().replace('.', '_') + "Type";
        String shortName = this.d_ext.getSymbolID().getShortName();
        LinkedList<Class> parents = new LinkedList<Class>(this.d_ext.getParentInterfaces(false));
        if (this.d_ext instanceof Class && (parent = ((Class)this.d_ext).getParentClass()) != null) {
            parents.addFirst(parent);
        }
        if (parents.isEmpty()) {
            this.d_lw.println(typeObj + ".tp_base = sidl_PyType();");
        } else {
            Extendable base = (Extendable)parents.getFirst();
            this.d_lw.println(typeObj + ".tp_base = " + Python.getExtendableType(base) + "();");
            this.d_lw.println(typeObj + ".tp_bases = PyTuple_New(" + parents.size() + ");");
            Iterator i = parents.iterator();
            int count = 0;
            while (i.hasNext()) {
                this.d_lw.println("PyTuple_SetItem(" + typeObj + ".tp_bases," + count++ + ", (PyObject *)" + Python.getExtendableType((Symbol)i.next()) + "());");
            }
        }
        this.d_lw.println("if (PyType_Ready(&" + typeObj + ") < 0) {");
        this.d_lw.tab();
        this.d_lw.println("PyErr_Print();");
        this.d_lw.println("fprintf(stderr, \"PyType_Ready on " + this.d_ext.getFullName() + " failed.\\n\");");
        this.d_lw.println("return;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("Py_INCREF(&" + typeObj + ");");
        this.d_lw.println("PyDict_SetItemString(dict, \"" + shortName + "\", (PyObject *)&" + typeObj + ");");
    }

    private void initModule() {
        SymbolID id = this.d_ext.getSymbolID();
        boolean isBaseClass = BabelConfiguration.isSIDLBaseClass(id);
        boolean docComment = this.d_ext.getComment() != null && this.d_ext.getComment().getComment() != null;
        this.d_lw.println("void");
        this.d_lw.print("init");
        this.d_lw.print(this.d_shortName);
        this.d_lw.println("(void) {");
        this.d_lw.tab();
        this.d_lw.println("PyObject *module, *dict, *c_api;");
        this.d_lw.print("static void *ExternalAPI[");
        this.d_lw.print(Python.getAPIVarName(this.d_ext));
        this.d_lw.println("_NUM];");
        if (!isBaseClass && !this.d_ext.isInterface()) {
            this.d_lw.println("sidl_DLL dll = NULL;");
            this.d_lw.println(IOR.getExternalName(id) + "*(*_extFunc)(void) = NULL;");
        }
        if (docComment) {
            this.d_lw.print("module = Py_InitModule3(\"");
        } else {
            this.d_lw.print("module = Py_InitModule(\"");
        }
        this.d_lw.print(this.d_shortName);
        this.d_lw.print("\", _");
        this.d_lw.print(this.d_shortName);
        this.d_lw.print("ModuleMethods");
        if (docComment) {
            this.d_lw.println(", \"\\");
            this.copyComment(this.d_ext.getComment());
            this.d_lw.printlnUnformatted("\"");
        }
        this.d_lw.println(");");
        this.d_lw.println("dict = PyModule_GetDict(module);");
        for (int i = 0; i < this.d_externalMethods.length; ++i) {
            this.d_lw.print("ExternalAPI[");
            this.d_lw.print(this.d_externalMethods[i]);
            this.d_lw.print("_NUM] = (void*)");
            this.d_lw.print(this.d_externalMethods[i]);
            this.d_lw.println(";");
        }
        this.d_lw.println("import_SIDLObjA();");
        this.d_lw.println("if (PyErr_Occurred()) {");
        this.d_lw.tab();
        this.d_lw.println("Py_FatalError(\"Error importing sidlObjA module.\");");
        this.d_lw.backTab();
        this.d_lw.println("}");
        if (this.isException()) {
            String extType = Python.getExceptionType(this.d_ext);
            this.d_lw.print(extType);
            this.d_lw.print(" = PyErr_NewException(\"");
            this.d_lw.print(this.d_ext.getFullName());
            this.d_lw.println(".Exception\", (PyObject *)sidl_PyType(), NULL);");
            this.d_lw.print("PyDict_SetItemString(dict, \"Exception\", ");
            this.d_lw.print(extType);
            this.d_lw.println(");");
            this.d_lw.print("ExternalAPI[");
            this.d_lw.print(extType);
            this.d_lw.print("_NUM] = ");
            this.d_lw.print(extType);
            this.d_lw.println(";");
        }
        this.d_lw.println("c_api = PyCObject_FromVoidPtr((void *)ExternalAPI, NULL);");
        this.d_lw.println("PyDict_SetItemString(dict, \"_C_API\", c_api);");
        this.d_lw.println("Py_XDECREF(c_api);");
        this.d_lw.println("import_SIDLPyArrays();");
        this.d_lw.println("if (PyErr_Occurred()) {");
        this.d_lw.tab();
        this.d_lw.println("Py_FatalError(\"Error importing sidlPyArrays module.\");");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("import_array();");
        this.d_lw.println("if (PyErr_Occurred()) {");
        this.d_lw.tab();
        this.d_lw.println("Py_FatalError(\"Error importing Numeric Python module.\");");
        this.d_lw.backTab();
        this.d_lw.println("}");
        Iterator i = this.d_references.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            if (sym.equals(this.d_ext) || !(sym instanceof Extendable)) continue;
            this.d_lw.print(Python.getExtendableImport(sym));
            this.d_lw.println("();");
        }
        this.preparePythonType();
        if (!this.d_ext.isInterface()) {
            if (isBaseClass) {
                this.d_lw.println("_implEPV = " + IOR.getExternalFunc(id) + "();");
            } else {
                this.d_lw.writeCommentLine("Load the implementation after initializing the module.");
                this.d_lw.writeCommentLine("Try search global namespace first");
                this.d_lw.println("dll = sidl_DLL__create();");
                this.d_lw.println("if (dll && sidl_DLL_loadLibrary(dll, \"main:\", TRUE, FALSE)) {");
                this.d_lw.tab();
                this.d_lw.println("_extFunc = (" + IOR.getExternalName(id) + "*(*)(void))");
                this.d_lw.tab();
                this.d_lw.println("sidl_DLL_lookupSymbol(dll, \"" + IOR.getExternalFunc(id) + "\");");
                this.d_lw.backTab();
                this.d_lw.println("if (_extFunc) {");
                this.d_lw.tab();
                this.d_lw.println("_implEPV = (*_extFunc)();");
                this.d_lw.backTab();
                this.d_lw.println("}");
                this.d_lw.backTab();
                this.d_lw.println("}");
                this.d_lw.println("if (dll) sidl_DLL_deleteRef(dll);");
                this.d_lw.println("if (!_implEPV) {");
                this.d_lw.tab();
                this.d_lw.println("dll = sidl_Loader_findLibrary(\"" + id.getFullName() + "\",");
                this.d_lw.tab();
                this.d_lw.println("\"ior/impl\", sidl_Scope_SCLSCOPE,");
                this.d_lw.println("sidl_Resolve_SCLRESOLVE);");
                this.d_lw.backTab();
                this.d_lw.println("if (dll) {");
                this.d_lw.tab();
                this.d_lw.println("_extFunc = (" + IOR.getExternalName(id) + "*(*)(void))");
                this.d_lw.tab();
                this.d_lw.println("sidl_DLL_lookupSymbol(dll, \"" + IOR.getExternalFunc(id) + "\");");
                this.d_lw.backTab();
                this.d_lw.println("if (_extFunc) {");
                this.d_lw.tab();
                this.d_lw.println("_implEPV = (*_extFunc)();");
                this.d_lw.backTab();
                this.d_lw.println("}");
                this.d_lw.println("sidl_DLL_deleteRef(dll);");
                this.d_lw.backTab();
                this.d_lw.println("}");
                this.d_lw.backTab();
                this.d_lw.println("}");
            }
            if (this.d_hasStaticMethods) {
                this.d_lw.println("if (_implEPV) {");
                this.d_lw.tab();
                this.d_lw.print("_sepv");
                this.d_lw.println(" = (*_implEPV->getStaticEPV)();");
                this.d_lw.println("if (PyErr_Occurred()) {");
                this.d_lw.tab();
                this.d_lw.print("Py_FatalError(\"Cannot initialize Python module ");
                this.d_lw.print(this.d_ext.getFullName());
                this.d_lw.println(".\");");
                this.d_lw.backTab();
                this.d_lw.println("}");
                this.d_lw.backTab();
                this.d_lw.println("}");
                this.d_lw.println("else {");
            } else {
                this.d_lw.println("if (!_implEPV) {");
            }
            this.d_lw.tab();
            this.d_lw.println("Py_FatalError(\"Cannot load implementation for sidl" + (this.d_ext.isInterface() ? " interface " : " class ") + id.getFullName() + "\");");
            this.d_lw.backTab();
            this.d_lw.println("}");
        }
        this.d_lw.backTab();
        this.d_lw.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        try {
            this.d_lw = Python.createStub(this.d_ext, "implement a C extension type for a sidl extendable");
            this.d_lw.enableLineBreak(78, null, "\\");
            this.explainExtensionSource();
            this.d_lw.writeComment(this.d_ext, true);
            this.includeHeaderFiles();
            this.staticMethods();
            this.convertMethods(this.d_ext.isInterface());
            this.pythonCastConstructor();
            this.pythonStaticVirtualTable();
            this.pythonObjectVirtualTable();
            this.writePythonType();
            this.externalMethods();
            this.initModule();
            Object var2_1 = null;
            if (this.d_lw == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.d_lw == null) throw throwable;
            this.d_lw.close();
            this.d_lw = null;
            throw throwable;
        }
        this.d_lw.close();
        this.d_lw = null;
    }
}

