/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.parsers.xml;

import gov.llnl.babel.parsers.xml.DTDManager;
import gov.llnl.babel.parsers.xml.ParseSymbolException;
import gov.llnl.babel.parsers.xml.StringXML;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Assertion;
import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.BinaryExpression;
import gov.llnl.babel.symbols.BooleanLiteral;
import gov.llnl.babel.symbols.CharacterLiteral;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.DComplexLiteral;
import gov.llnl.babel.symbols.DoubleLiteral;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.FComplexLiteral;
import gov.llnl.babel.symbols.FloatLiteral;
import gov.llnl.babel.symbols.IdentifierLiteral;
import gov.llnl.babel.symbols.IntegerLiteral;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.LongLiteral;
import gov.llnl.babel.symbols.Metadata;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.MethodCall;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.StringLiteral;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolRedefinitionException;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.UnaryExpression;
import gov.llnl.babel.symbols.Version;
import gov.llnl.babel.xml.ElementIterator;
import gov.llnl.babel.xml.XMLUtilities;
import java.io.IOException;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParseSymbolXML {
    private static final String EOL = "\n";
    private Symbol d_symbol;

    public static Symbol convert(InputSource is) throws ParseSymbolException {
        ParseSymbolXML xml2sym = new ParseSymbolXML(is);
        return xml2sym.getSymbol();
    }

    public static Symbol convert(Document doc) throws ParseSymbolException {
        ParseSymbolXML doc2sym = new ParseSymbolXML(doc);
        return doc2sym.getSymbol();
    }

    public ParseSymbolXML(InputSource is) throws ParseSymbolException {
        Document document = null;
        try {
            document = XMLUtilities.parse(is, DTDManager.getInstance());
        }
        catch (IOException ex) {
            this.error("ParseSymbolXML: IOException: " + ex.getMessage());
        }
        catch (SAXException ex) {
            this.error("ParseSymbolXML: SAXException: " + ex.getMessage());
        }
        this.parseSymbol(document.getDocumentElement());
    }

    public ParseSymbolXML(Document doc) throws ParseSymbolException {
        this.parseSymbol(doc.getDocumentElement());
    }

    public Symbol getSymbol() {
        return this.d_symbol;
    }

    private void parseSymbol(Element symbol) throws ParseSymbolException {
        if (symbol == null || !"Symbol".equals(symbol.getNodeName())) {
            this.error("parseSymbol: No <Symbol> root element found in XML/DOM document.");
        }
        SymbolID id = this.parseSymbolID(this.getElement(symbol, "SymbolName"));
        Comment cm = this.parseComment(this.getElement(symbol, "Comment"));
        Metadata md = this.parseMetadata(this.getElement(symbol, "Metadata"));
        if (this.hasChildElement(symbol, "Class")) {
            this.d_symbol = new Class(id, cm, md);
            this.parseClass(this.getElement(symbol, "Class"));
        } else if (this.hasChildElement(symbol, "Enumeration")) {
            this.d_symbol = new Enumeration(id, cm, md);
            this.parseEnum(this.getElement(symbol, "Enumeration"));
        } else if (this.hasChildElement(symbol, "Interface")) {
            this.d_symbol = new Interface(id, cm, md);
            this.parseInterface(this.getElement(symbol, "Interface"));
        } else if (this.hasChildElement(symbol, "Package")) {
            this.d_symbol = new Package(id, cm, md);
            this.parsePackage(this.getElement(symbol, "Package"));
        } else {
            this.error("parseSymbol: Unknown SIDL symbol type in XML document.");
        }
    }

    private void parseClass(Element element) throws ParseSymbolException {
        this.validateSymbolName(element, "Class");
        Class cls = (Class)this.d_symbol;
        Element extends_element = this.getElement(element, "Extends");
        ElementIterator parent = new ElementIterator(extends_element, "SymbolName");
        if (parent.hasNext()) {
            SymbolID id = this.parseSymbolID((Element)parent.next());
            try {
                Symbol sym = SymbolTable.getInstance().resolveSymbol(id);
                if (sym == null) {
                    this.error("parseClass: Class \"" + id.getSymbolName() + "\" not found.");
                } else if (sym.getSymbolType() != 12) {
                    this.error("parseClass: Symbol \"" + id.getSymbolName() + "\"  not a class.");
                } else {
                    cls.setParentClass((Class)sym);
                }
            }
            catch (SymbolRedefinitionException ex) {
                this.error("parseClass: SymbolRedefinitionException: " + ex.getMessage());
            }
        }
        this.parseParentInterfaceBlock(element, cls, false);
        this.parseMethodsBlock(element, cls);
        this.parseInvariantAssertionList(element, cls);
    }

    private void parseEnum(Element element) throws ParseSymbolException {
        this.validateSymbolName(element, "Enumeration");
        Enumeration enm = (Enumeration)this.d_symbol;
        ElementIterator enumerators = new ElementIterator(element, "Enumerator");
        while (enumerators.hasNext()) {
            Element entry = (Element)enumerators.next();
            String name = this.getAttribute(entry, "name");
            String sval = this.getAttribute(entry, "value");
            boolean user = this.getAttribute(entry, "fromuser").equals("true");
            Comment cmt = null;
            if (this.hasChildElement(entry, "Comment")) {
                cmt = this.parseComment(this.getElement(entry, "Comment"));
            }
            try {
                enm.addEnumerator(name, Integer.parseInt(sval), user, cmt);
            }
            catch (NumberFormatException ex) {
                this.error("parseEnum: Invalid integer value \"" + sval + "\" for enumerated type.");
            }
        }
    }

    private void parseInterface(Element element) throws ParseSymbolException {
        this.validateSymbolName(element, "Interface");
        Interface ifc = (Interface)this.d_symbol;
        this.parseParentInterfaceBlock(element, ifc, true);
        this.parseMethodsBlock(element, ifc);
        this.parseInvariantAssertionList(element, ifc);
    }

    private static Version chooseVersion(String version, Version parent) {
        if (version == null) {
            return parent;
        }
        return new Version(version);
    }

    private void parsePackage(Element element) throws ParseSymbolException {
        this.validateSymbolName(element, "Package");
        Package p = (Package)this.d_symbol;
        Version pkgVersion = p.getSymbolID().getVersion();
        p.setFinal("true".equals(this.getAttribute(element, "final")));
        try {
            ElementIterator entries = new ElementIterator(element, "PackageSymbol");
            while (entries.hasNext()) {
                Element entry = (Element)entries.next();
                String name = this.getAttribute(entry, "name");
                String type = this.getAttribute(entry, "type");
                String version = this.getAttribute(entry, "version");
                p.addSymbol(new SymbolID(p.getScopedName(name), ParseSymbolXML.chooseVersion(version, pkgVersion), true), StringXML.fromSymbolXML(type));
            }
        }
        catch (NumberFormatException nfe) {
            this.error("parsePackage: Bad version string: " + nfe.getMessage() + ".");
        }
    }

    private Comment parseComment(Element comment) throws ParseSymbolException {
        this.validateSymbolName(comment, "Comment");
        String s = XMLUtilities.decodeXMLString(XMLUtilities.decodeXMLString(XMLUtilities.decodeXMLString(XMLUtilities.decodeXMLString(XMLUtilities.getXMLString(comment)))));
        int nlines = 0;
        int index = s.indexOf(EOL);
        while (index > 0) {
            ++nlines;
            index = s.indexOf(EOL, index + 1);
        }
        String[] lines = null;
        if (nlines > 1) {
            lines = new String[nlines - 1];
            int start_index = s.indexOf(EOL);
            for (int n = 0; n < nlines - 1; ++n) {
                int end_index = s.indexOf(EOL, start_index + 1);
                lines[n] = s.substring(start_index + 1, end_index);
                start_index = end_index;
            }
        }
        return new Comment(lines);
    }

    private Metadata parseMetadata(Element m) throws ParseSymbolException {
        this.validateSymbolName(m, "Metadata");
        Metadata metadata = null;
        String date = this.getAttribute(m, "date");
        try {
            metadata = new Metadata(date);
        }
        catch (ParseException ex) {
            this.error("parseMetadata: Invalid date format \"" + date + "\" in metadata element.");
        }
        ElementIterator entries = new ElementIterator(m, "MetadataEntry");
        while (entries.hasNext()) {
            Element entry = (Element)entries.next();
            String key = this.getAttribute(entry, "key");
            String val = this.getAttribute(entry, "value");
            metadata.addMetadata(key, val);
        }
        return metadata;
    }

    private void parseParentInterfaceBlock(Element e, Extendable ext, boolean isInterface) throws ParseSymbolException {
        String name = isInterface ? "ExtendsBlock" : "ImplementsBlock";
        Element block = this.getElement(e, name);
        ElementIterator parents = new ElementIterator(block, "SymbolName");
        while (parents.hasNext()) {
            SymbolID id = this.parseSymbolID((Element)parents.next());
            try {
                Symbol sym = SymbolTable.getInstance().resolveSymbol(id);
                if (sym == null) {
                    this.error("parseParentInterfaceBlock: Interface \"" + id.getSymbolName() + "\" not found.");
                    continue;
                }
                if (sym.getSymbolType() != 13) {
                    this.error("parseParentInterfaceBlock: Symbol \"" + id.getSymbolName() + "\"  not interface.");
                    continue;
                }
                ext.addParentInterface((Interface)sym);
            }
            catch (SymbolRedefinitionException ex) {
                this.error("parseParentInterfaceBlock: SymbolRedefinitionException: " + ex.getMessage());
            }
        }
    }

    private void parseMethodsBlock(Element e, Extendable ext) throws ParseSymbolException {
        Element block = this.getElement(e, "MethodsBlock");
        ElementIterator methods = new ElementIterator(block, "Method");
        while (methods.hasNext()) {
            ext.addMethod(this.parseMethod((Element)methods.next(), ext.getFullName()));
        }
    }

    private void parseInvariantAssertionList(Element e, Extendable ext) throws ParseSymbolException {
        if (this.hasChildElement(e, "AssertionList")) {
            Element list = this.getElement(e, "AssertionList");
            ElementIterator iter = new ElementIterator(list, "Assertion");
            while (iter.hasNext()) {
                try {
                    Assertion as = this.parseAssertion((Element)iter.next(), ext.getFullName());
                    ext.addInvariant(as);
                }
                catch (AssertionException aex) {
                    this.error("parseInvariantAssertionList: AssertionException: " + aex.getMessage());
                }
            }
        }
    }

    private Method parseMethod(Element e, String name) throws ParseSymbolException {
        this.validateSymbolName(e, "Method");
        Method method = new Method();
        method.setMethodName(this.getAttribute(e, "shortname"), this.getAttribute(e, "extension"));
        method.setCommunicationModifier(StringXML.fromComXML(this.getAttribute(e, "communication")));
        method.setDefinitionModifier(StringXML.fromDefXML(this.getAttribute(e, "definition")));
        method.setReturnCopy(this.getAttribute(e, "copy").equals("true"));
        method.setComment(this.parseComment(this.getElement(e, "Comment")));
        method.setReturnType(this.parseType(this.getElement(e, "Type")));
        Element arglist = this.getElement(e, "ArgumentList");
        ElementIterator args = new ElementIterator(arglist, "Argument");
        while (args.hasNext()) {
            method.addArgument(this.parseArgument((Element)args.next()));
        }
        Element throwslist = this.getElement(e, "ThrowsList");
        ElementIterator thrws = new ElementIterator(throwslist, "SymbolName");
        while (thrws.hasNext()) {
            method.addThrows(this.parseSymbolID((Element)thrws.next()));
        }
        if (this.hasChildElement(e, "AssertionList")) {
            Element alist = this.getElement(e, "AssertionList");
            ElementIterator iter = new ElementIterator(alist, "Assertion");
            while (iter.hasNext()) {
                try {
                    Assertion as = this.parseAssertion((Element)iter.next(), name);
                    method.addAssertion(as);
                }
                catch (AssertionException aex) {
                    this.error("parseMethod: AssertionException: " + aex.getMessage());
                }
            }
        }
        return method;
    }

    private Argument parseArgument(Element e) throws ParseSymbolException {
        this.validateSymbolName(e, "Argument");
        boolean copy = this.getAttribute(e, "copy").equals("true");
        int mode = StringXML.fromModeXML(this.getAttribute(e, "mode"));
        String name = this.getAttribute(e, "name");
        Type type = this.parseType(this.getElement(e, "Type"));
        return new Argument(copy, mode, type, name);
    }

    private Type parseType(Element e) throws ParseSymbolException {
        this.validateSymbolName(e, "Type");
        int typeid = StringXML.fromTypeXML(this.getAttribute(e, "type"));
        Type type = null;
        if (typeid == 15) {
            type = new Type(this.parseSymbolID(this.getElement(e, "SymbolName")));
        } else if (typeid == 16) {
            Element array = this.getElement(e, "Array");
            String sdim = this.getAttribute(array, "dim");
            String sorder = this.getAttribute(array, "order");
            int dim = 0;
            int order = StringXML.fromOrderXML(sorder);
            Element arrayType = XMLUtilities.lookupElement(array, "Type");
            Element index_elem = XMLUtilities.lookupElement(array, "Index");
            if (null != sdim) {
                try {
                    dim = Integer.parseInt(sdim);
                }
                catch (NumberFormatException ex) {
                    this.error("parseType: Invalid array dimension \"" + sdim + "\"");
                }
            }
            type = null != arrayType ? new Type(this.parseType(this.getElement(array, "Type")), dim, order) : new Type(null, dim, order);
            if (index_elem != null) {
                String index_list = this.getAttribute(index_elem, "name");
                StringTokenizer index_tok = new StringTokenizer(index_list, ",");
                while (index_tok.hasMoreTokens()) {
                    type.addArrayIndex(index_tok.nextToken());
                }
            }
        } else {
            type = new Type(typeid);
        }
        return type;
    }

    private SymbolID parseSymbolID(Element id) throws ParseSymbolException {
        this.validateSymbolName(id, "SymbolName");
        String name = this.getAttribute(id, "name");
        String vers = this.getAttribute(id, "version");
        SymbolID sid = null;
        try {
            sid = new SymbolID(name, new Version(vers), true);
        }
        catch (NumberFormatException ex) {
            this.error("parseSymbolID: Invalid version format \"" + vers + "\" in symbol name.");
        }
        return sid;
    }

    private Assertion parseAssertion(Element e, String source) throws ParseSymbolException {
        this.validateSymbolName(e, "Assertion");
        Comment cm = this.parseComment(this.getElement(e, "Comment"));
        String tag = this.getAttribute(e, "tag");
        int type = StringXML.fromAssertionXML(this.getAttribute(e, "type"));
        Assertion as = null;
        try {
            Element ae = this.getElement(e, "AssertionExpression");
            AssertionExpression expr = this.parseAssertionExpression(ae);
            as = new Assertion(type, source, tag, cm);
            as.setExpression(expr);
        }
        catch (AssertionException aex) {
            this.error("parseAssertion: AssertionException: " + aex.getMessage());
        }
        return as;
    }

    private AssertionExpression parseAssertionExpression(Element e) throws ParseSymbolException {
        this.validateSymbolName(e, "AssertionExpression");
        AssertionExpression expr = null;
        boolean parens = this.getAttribute(e, "parens").equals("true");
        if (this.hasChildElement(e, "BinaryExpression")) {
            Element be = this.getElement(e, "BinaryExpression");
            expr = this.parseBinaryExpression(be, parens);
        } else if (this.hasChildElement(e, "ComplexNumber")) {
            Element cn = this.getElement(e, "ComplexNumber");
            expr = this.parseComplexNumber(cn, parens);
        } else if (this.hasChildElement(e, "MethodCall")) {
            Element mc = this.getElement(e, "MethodCall");
            expr = this.parseMethodCall(mc, parens);
        } else if (this.hasChildElement(e, "SimpleExpression")) {
            Element se = this.getElement(e, "SimpleExpression");
            expr = this.parseSimpleExpression(se, parens);
        } else if (this.hasChildElement(e, "UnaryExpression")) {
            Element ue = this.getElement(e, "UnaryExpression");
            expr = this.parseUnaryExpression(ue, parens);
        } else {
            this.error("parseAssertionExpression: Unable to locate a recognizable/supported child element of an Assertion Expression.");
        }
        return expr;
    }

    private BinaryExpression parseBinaryExpression(Element e, boolean parens) throws ParseSymbolException {
        this.validateSymbolName(e, "BinaryExpression");
        AssertionExpression lhs = null;
        AssertionExpression rhs = null;
        BinaryExpression expr = null;
        int op = StringXML.fromBinaryOpXML(this.getAttribute(e, "op"));
        ElementIterator iter = new ElementIterator(e, "AssertionExpression");
        int num = 0;
        while (iter.hasNext()) {
            Element entry = (Element)iter.next();
            if (++num == 1) {
                lhs = this.parseAssertionExpression(entry);
                continue;
            }
            if (num == 2) {
                rhs = this.parseAssertionExpression(entry);
                continue;
            }
            this.error("parseBinaryExpression: Invalid number of assertion expressions detected when attempting to parse a binary expression.");
        }
        if (lhs != null && rhs != null) {
            try {
                expr = new BinaryExpression(lhs, op, rhs);
                expr.setParens(parens);
            }
            catch (AssertionException aex) {
                this.error("parseBinaryExpression: AssertionException: " + aex.getMessage());
            }
        } else {
            this.error("parseBinaryExpression: either the LHS or RHS of the binary expression did NOT get parsed");
        }
        return expr;
    }

    private AssertionExpression parseComplexNumber(Element e, boolean parens) throws ParseSymbolException {
        this.validateSymbolName(e, "ComplexNumber");
        AssertionExpression expr = null;
        String type = this.getAttribute(e, "type");
        String real = this.getAttribute(e, "real");
        String imag = this.getAttribute(e, "imaginary");
        try {
            if (type.equals("float")) {
                FloatLiteral fr = new FloatLiteral(Float.valueOf(real), real);
                FloatLiteral fi = new FloatLiteral(Float.valueOf(imag), imag);
                FComplexLiteral f = new FComplexLiteral(fr, fi);
                f.setParens(parens);
                expr = f;
            } else if (type.equals("double")) {
                DoubleLiteral dr = new DoubleLiteral(Double.valueOf(real), real);
                DoubleLiteral di = new DoubleLiteral(Double.valueOf(imag), imag);
                DComplexLiteral d = new DComplexLiteral(dr, di);
                d.setParens(parens);
                expr = d;
            } else {
                this.error("parseComplexNumber: unrecongized or unsupported complex type " + type + " encountered.");
            }
        }
        catch (AssertionException aex) {
            this.error("parseComplexNumber: AssertionException: " + aex.getMessage());
        }
        catch (NumberFormatException nfe) {
            this.error("parseComplexNumber: Error parsing real (\"" + real + "\") or " + "imaginary (\"" + imag + "\") part: " + nfe.getMessage());
        }
        return expr;
    }

    private MethodCall parseMethodCall(Element e, boolean parens) throws ParseSymbolException {
        this.validateSymbolName(e, "MethodCall");
        String name = this.getAttribute(e, "name");
        MethodCall expr = null;
        try {
            expr = new MethodCall(name);
            expr.setParens(parens);
            ElementIterator iter = new ElementIterator(e, "AssertionExpression");
            while (iter.hasNext()) {
                expr.addArgument(this.parseAssertionExpression((Element)iter.next()));
            }
        }
        catch (AssertionException aex) {
            this.error("parseMethodCall: AssertionException: " + aex.getMessage());
        }
        return expr;
    }

    private AssertionExpression parseSimpleExpression(Element e, boolean parens) throws ParseSymbolException {
        this.validateSymbolName(e, "SimpleExpression");
        AssertionExpression expr = null;
        String etype = this.getAttribute(e, "etype");
        String value = this.getAttribute(e, "value");
        Type type = this.parseType(this.getElement(e, "Type"));
        try {
            if (etype.equals("identifier")) {
                expr = new IdentifierLiteral(value);
                expr.setParens(parens);
            } else if (etype.equals("constant")) {
                switch (type.getType()) {
                    case 1: {
                        expr = new BooleanLiteral(value.equals("true"));
                        expr.setParens(parens);
                        break;
                    }
                    case 2: {
                        expr = new CharacterLiteral(value.charAt(0));
                        expr.setParens(parens);
                        break;
                    }
                    case 4: {
                        expr = new DoubleLiteral(Double.valueOf(value), value);
                        expr.setParens(parens);
                        break;
                    }
                    case 6: {
                        expr = new FloatLiteral(Float.valueOf(value), value);
                        expr.setParens(parens);
                        break;
                    }
                    case 7: {
                        expr = new IntegerLiteral(Integer.decode(value), value);
                        expr.setParens(parens);
                        break;
                    }
                    case 8: {
                        expr = new LongLiteral(Long.decode(value), value);
                        expr.setParens(parens);
                        break;
                    }
                    case 10: {
                        expr = new StringLiteral(value);
                        expr.setParens(parens);
                        break;
                    }
                    case 15: {
                        expr = new IdentifierLiteral(value);
                        expr.setParens(parens);
                        break;
                    }
                    case 16: {
                        expr = new IdentifierLiteral(value);
                        expr.setParens(parens);
                        break;
                    }
                    default: {
                        this.error("parseSimpleExpression: Unsupported Type value \"" + type.getType() + "\" encountered.");
                    }
                }
            }
        }
        catch (AssertionException aex) {
            this.error("parseSimpleExpression: AssertionException: " + aex.getMessage());
        }
        catch (NumberFormatException nfe) {
            this.error("parseSimpleExpression: NumberFormatException: " + nfe.getMessage());
        }
        return expr;
    }

    private UnaryExpression parseUnaryExpression(Element e, boolean parens) throws ParseSymbolException {
        this.validateSymbolName(e, "UnaryExpression");
        int op = StringXML.fromUnaryOpXML(this.getAttribute(e, "op"));
        UnaryExpression uexpr = null;
        try {
            AssertionExpression expr = this.parseAssertionExpression(this.getElement(e, "AssertionExpression"));
            uexpr = new UnaryExpression(op, expr);
            uexpr.setParens(parens);
        }
        catch (AssertionException aex) {
            this.error("parseUnaryExpression: AssertionException: " + aex.getMessage());
        }
        return uexpr;
    }

    private Element getElement(Element parent, String child) throws ParseSymbolException {
        Element element = XMLUtilities.lookupElement(parent, child);
        if (element == null) {
            this.error("getElement: Child element \"" + child + "\" not found in parent \"" + parent.getTagName() + "\".");
        }
        return element;
    }

    private boolean hasChildElement(Element parent, String child) {
        return XMLUtilities.lookupElement(parent, child) != null;
    }

    private void validateSymbolName(Element e, String name) throws ParseSymbolException {
        String tag = e.getTagName();
        if (!name.equals(tag)) {
            this.error("validateSymbolName: Invalid element name \"" + tag + "\" (expected \"" + name + "\").");
        }
    }

    private String getAttribute(Element e, String attr) throws ParseSymbolException {
        String value = e.getAttribute(attr);
        if (value == null) {
            this.error("getAttribute: Attribute \"" + attr + "\" not found in \"" + e.getTagName() + "\".");
        }
        return value;
    }

    private void error(String message) throws ParseSymbolException {
        throw new ParseSymbolException(message);
    }
}

