/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.FloatLiteral;
import gov.llnl.babel.symbols.LongLiteral;
import gov.llnl.babel.symbols.Method;
import java.util.ArrayList;

public class FComplexLiteral
extends AssertionExpression {
    private FloatLiteral d_real = null;
    private FloatLiteral d_imaginary = null;

    public FComplexLiteral(FloatLiteral r, FloatLiteral i) throws AssertionException {
        super(true);
        if (r == null || !r.isValid()) {
            throw new AssertionException("FComplexLiteral", "Cannot create a complex literal with the real part null or invalid.");
        }
        if (i == null || !i.isValid()) {
            throw new AssertionException("FComplexLiteral", "Cannot create a complex literal with the imaginary part null or invalid.");
        }
        this.d_real = r;
        this.d_imaginary = i;
        this.setReturnToFComplex();
    }

    public FComplexLiteral(LongLiteral r, LongLiteral i) throws AssertionException {
        super(true);
        if (r == null || !r.isValid()) {
            throw new AssertionException("FComplexLiteral", "Cannot create a complex literal with the real part null or invalid.");
        }
        if (i == null || !i.isValid()) {
            throw new AssertionException("FComplexLiteral", "Cannot create a complex literal with the imaginary part null or invalid.");
        }
        this.d_real = new FloatLiteral(new Float(r.getValue().floatValue()), r.getImage());
        this.d_imaginary = new FloatLiteral(new Float(i.getValue().floatValue()), i.getImage());
        this.setReturnToFComplex();
    }

    public FloatLiteral getRealLiteral() {
        return this.d_real;
    }

    public Float getRealValue() {
        return this.d_real.getValue();
    }

    public String getRealImage() {
        return this.d_real.getImage();
    }

    public FloatLiteral getImaginaryLiteral() {
        return this.d_imaginary;
    }

    public Float getImaginaryValue() {
        return this.d_imaginary.getValue();
    }

    public String getImaginaryImage() {
        return this.d_imaginary.getImage();
    }

    public boolean hasPure() {
        return false;
    }

    public boolean hasResult() {
        return false;
    }

    public boolean hasMethodCall() {
        return false;
    }

    public boolean hasReservedMethod(int type) {
        return false;
    }

    public boolean hasUnreservedMethod(boolean any) {
        return false;
    }

    public boolean requiresExtendableContext() {
        return false;
    }

    public boolean requiresMethodContext() {
        return false;
    }

    protected void validateSemantics(Extendable ext, Method m) throws AssertionException {
    }

    public ArrayList getArrayIterMacros(String epvVar, int[] startInd) {
        return null;
    }

    public int getNumArrayIterMacrosByType(char type) {
        return 0;
    }

    public String cExpression(String epvVar, int[] startInd) {
        return "{" + this.d_real.toString() + ", " + this.d_imaginary.toString() + "}";
    }

    public String toString() {
        String expr = this.d_real.toString() + ", " + this.d_imaginary.toString();
        return this.hasParens() ? "(" + expr + ")" : expr;
    }
}

