// 
// File:          gov_cca_Services.hh
// Symbol:        gov.cca.Services-v0.6.3
// Symbol Type:   interface
// Babel Version: 0.10.2
// Description:   Client-side glue code for gov.cca.Services
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_gov_cca_Services_hh
#define included_gov_cca_Services_hh

// declare class before #includes
// (this alleviates circular #include guard problems)[BUG#393]
namespace gov { 
  namespace cca { 

    class Services;
  } // end namespace cca
} // end namespace gov

// Some compilers need to define array template before the specializations
#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
namespace sidl {
  template<>
  class array< ::gov::cca::Services >;
}

#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
#ifndef included_gov_cca_Services_IOR_h
#include "gov_cca_Services_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_gov_cca_CCAException_hh
#include "gov_cca_CCAException.hh"
#endif
#ifndef included_gov_cca_ComponentID_hh
#include "gov_cca_ComponentID.hh"
#endif
#ifndef included_gov_cca_ComponentRelease_hh
#include "gov_cca_ComponentRelease.hh"
#endif
#ifndef included_gov_cca_Port_hh
#include "gov_cca_Port.hh"
#endif
#ifndef included_gov_cca_TypeMap_hh
#include "gov_cca_TypeMap.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif

namespace gov { 
  namespace cca { 

    /**
     * Symbol "gov.cca.Services" (version 0.6.3)
     */
    class Services : public ::sidl::StubBase {

      //////////////////////////////////////////////////
      // 
      // User Defined Methods
      // 

    public:

      /**
       * <p>
       * Add one to the intrinsic reference count in the underlying object.
       * Object in <code>sidl</code> have an intrinsic reference count.
       * Objects continue to exist as long as the reference count is
       * positive. Clients should call this method whenever they
       * create another ongoing reference to an object or interface.
       * </p>
       * <p>
       * This does not have a return value because there is no language
       * independent type that can refer to an interface or a
       * class.
       * </p>
       */
      inline void
      addRef() throw () 
      {

        if ( !d_weak_reference ) {
          /*pack args to dispatch to ior*/
          (*(d_self->d_epv->f_addRef))(d_self->d_object );
          /*dispatch to ior*/
          /*unpack results and cleanup*/
        }
      }



      /**
       * Decrease by one the intrinsic reference count in the underlying
       * object, and delete the object if the reference is non-positive.
       * Objects in <code>sidl</code> have an intrinsic reference count.
       * Clients should call this method whenever they remove a
       * reference to an object or interface.
       */
      inline void
      deleteRef() throw () 
      {

        if ( !d_weak_reference ) {
          /*pack args to dispatch to ior*/
          (*(d_self->d_epv->f_deleteRef))(d_self->d_object );
          /*dispatch to ior*/
          /*unpack results and cleanup*/
          d_self = 0;
        }
      }



      /**
       * Return true if and only if <code>obj</code> refers to the same
       * object as this object.
       */
      bool
      isSame (
        /* in */ ::sidl::BaseInterface iobj
      )
      throw () 
      ;



      /**
       * Check whether the object can support the specified interface or
       * class.  If the <code>sidl</code> type name in <code>name</code>
       * is supported, then a reference to that object is returned with the
       * reference count incremented.  The callee will be responsible for
       * calling <code>deleteRef</code> on the returned object.  If
       * the specified type is not supported, then a null reference is
       * returned.
       */
      ::sidl::BaseInterface
      queryInt (
        /* in */ const ::std::string& name
      )
      throw () 
      ;



      /**
       * Return whether this object is an instance of the specified type.
       * The string name must be the <code>sidl</code> type name.  This
       * routine will return <code>true</code> if and only if a cast to
       * the string type name would succeed.
       */
      bool
      isType (
        /* in */ const ::std::string& name
      )
      throw () 
      ;



      /**
       * Return the meta-data about the class implementing this interface.
       */
      ::sidl::ClassInfo
      getClassInfo() throw () 
      ;


      /**
       * Fetch a previously registered Port (defined by either 
       * addProvidePort or (more typically) registerUsesPort).  
       * @return Will return the Port (possibly waiting forever while
       * attempting to acquire it) or throw an exception. Does not return
       * NULL, even in the case where no connection has been made. 
       * If a Port is returned,
       * there is then a contract that the port will remain valid for use
       * by the caller until the port is released via releasePort(), or a 
       * Disconnect Event is successfully dispatched to the caller,
       * or a runtime exception (such as network failure) occurs during 
       * invocation of some function in the Port. 
       * <p>
       * Subtle interpretation: If the Component is not listening for
       * Disconnect events, then the framework has no clean way to
       * break the connection until after the component calls releasePort.
       * </p>
       * <p>The framework may go through some machinations to obtain
       *    the port, possibly involving an interactive user or network 
       *    queries, before giving up and throwing an exception.
       * </p>
       * 
       * @param portName The previously registered or provide port which
       * 	   the component now wants to use.
       * @exception CCAException with the following types: NotConnected, PortNotDefined, 
       *                NetworkError, OutOfMemory.
       */
      ::gov::cca::Port
      getPort (
        /* in */ const ::std::string& portName
      )
      throw ( 
        ::gov::cca::CCAException
      );



      /**
       * Get a previously registered Port (defined by
       * either addProvide or registerUses) and return that
       * Port if it is available immediately (already connected
       * without further connection machinations).
       * There is an contract that the
       * port will remain valid per the description of getPort.
       * @return The named port, if it exists and is connected or self-provided,
       * 	      or NULL if it is registered and is not yet connected. Does not
       * 	      return if the Port is neither registered nor provided, but rather
       * 	      throws an exception.
       * @param portName registered or provided port that
       * 	     the component now wants to use.
       * @exception CCAException with the following types: PortNotDefined, OutOfMemory.
       */
      ::gov::cca::Port
      getPortNonblocking (
        /* in */ const ::std::string& portName
      )
      throw ( 
        ::gov::cca::CCAException
      );



      /**
       * Notifies the framework that this component is finished 
       * using the previously fetched Port that is named.     
       * The releasePort() method calls should be paired with 
       * getPort() method calls; however, an extra call to releasePort()
       * for the same name may (is not required to) generate an exception.
       * Calls to release ports which are not defined or have never be fetched
       * with one of the getPort functions generate exceptions.
       * @param portName The name of a port.
       * @exception CCAException with the following types: PortNotDefined, PortNotInUse.
       */
      void
      releasePort (
        /* in */ const ::std::string& portName
      )
      throw ( 
        ::gov::cca::CCAException
      );



      /**
       * Creates a TypeMap, potentially to be used in subsequent
       * calls to describe a Port.  Initially, this map is empty.
       */
      ::gov::cca::TypeMap
      createTypeMap() throw ( 
        ::gov::cca::CCAException
      );


      /**
       * Register a request for a Port that will be retrieved subsequently 
       * with a call to getPort().
       * @param portName A string uniquely describing this port.  This string
       * must be unique for this component, over both uses and provides ports.
       * @param type A string desribing the type of this port.
       * @param properties A TypeMap describing optional properties
       * associated with this port. This can be a null pointer, which
       * indicates an empty list of properties.  Properties may be
       * obtained from createTypeMap or any other source.  The properties
       * be copied into the framework, and subsequent changes to the
       * properties object will have no effect on the properties
       * associated with this port.
       * In these properties, all frameworks recognize at least the
       * following keys and values in implementing registerUsesPort:
       * <pre xml:space="preserve">
       * key:              standard values (in string form)     default
       * "MAX_CONNECTIONS" any nonnegative integer, "unlimited".   1
       * "MIN_CONNECTIONS" any integer > 0.                        0
       * "ABLE_TO_PROXY"   "true", "false"                      "false"
       * </pre>
       * The component is not expected to work if the framework
       * has not satisfied the connection requirements.
       * The framework is allowed to return an error if it
       * is incapable of meeting the connection requirements,
       * e.g. it does not implement multiple uses ports.
       * The caller of registerUsesPort is not obligated to define
       * these properties. If left undefined, the default listed above is
       *       assumed.
       * @exception CCAException with the following types: PortAlreadyDefined, OutOfMemory.
       */
      void
      registerUsesPort (
        /* in */ const ::std::string& portName,
        /* in */ const ::std::string& type,
        /* in */ ::gov::cca::TypeMap properties
      )
      throw ( 
        ::gov::cca::CCAException
      );



      /**
       * Notify the framework that a Port, previously registered by this
       * component but currently not in use, is no longer desired. 
       * Unregistering a port that is currently 
       * in use (i.e. an unreleased getPort() being outstanding) 
       * is an error.
       * @param name The name of a registered Port.
       * @exception CCAException with the following types: UsesPortNotReleased, PortNotDefined.
       */
      void
      unregisterUsesPort (
        /* in */ const ::std::string& portName
      )
      throw ( 
        ::gov::cca::CCAException
      );



      /**
       * Exposes a Port from this component to the framework.  
       * This Port is now available for the framework to connect 
       * to other components. 
       * @param inPort An abstract interface (tagged with CCA-ness
       * 	by inheriting from gov.cca.Port) the framework will
       * 	make available to other components.
       * 
       * @param portName string uniquely describing this port.  This string
       * must be unique for this component, over both uses and provides ports.
       * 
       * @param type string describing the type (class) of this port.
       * 
       * @param properties A TypeMap describing optional properties
       * associated with this port. This can be a null pointer, which
       * indicates an empty list of properties.  Properties may be
       * obtained from createTypeMap or any other source.  The properties
       * be copied into the framework, and subsequent changes to the
       * properties object will have no effect on the properties
       * associated with this port.
       * In these properties, all frameworks recognize at least the
       * following keys and values in implementing registerUsesPort:
       * <pre xml:space="preserve">
       * key:              standard values (in string form)     default
       * "MAX_CONNECTIONS" any nonnegative integer, "unlimited".   1
       * "MIN_CONNECTIONS" any integer > 0.                        0
       * "ABLE_TO_PROXY"   "true", "false"                      "false"
       * </pre>
       * The component is not expected to work if the framework
       * has not satisfied the connection requirements.
       * The framework is allowed to return an error if it
       * is incapable of meeting the connection requirements,
       * e.g. it does not implement multiple uses ports.
       * The caller of addProvidesPort is not obligated to define
       * these properties. If left undefined, the default listed above is
       * assumed.
       * @exception CCAException with the following types: PortAlreadyDefined, OutOfMemory.
       */
      void
      addProvidesPort (
        /* in */ ::gov::cca::Port inPort,
        /* in */ const ::std::string& portName,
        /* in */ const ::std::string& type,
        /* in */ ::gov::cca::TypeMap properties
      )
      throw ( 
        ::gov::cca::CCAException
      );



      /**
       * Returns the complete list of the properties for a Port.  This
       * includes the properties defined when the port was registered
       * (these properties can be modified by the framework), two special
       * properties "cca.portName" and "cca.portType", and any other
       * properties that the framework wishes to disclose to the component.
       * The framework may also choose to provide only the subset of input
       * properties (i.e. from addProvidesPort/registerUsesPort) that it
       * will honor.
       */
      ::gov::cca::TypeMap
      getPortProperties (
        /* in */ const ::std::string& name
      )
      throw () 
      ;



      /**
       * Notifies the framework that a previously exposed Port is no longer 
       * available for use. The Port being removed must exist
       * until this call returns, or a CCAException may occur.
       * @param name The name of a provided Port.
       * @exception PortNotDefined. In general, the framework will not dictate 
       * when the component chooses to stop offering services.
       */
      void
      removeProvidesPort (
        /* in */ const ::std::string& portName
      )
      throw ( 
        ::gov::cca::CCAException
      );



      /**
       * Get a reference to the component to which this 
       * Services object belongs. 
       */
      ::gov::cca::ComponentID
      getComponentID() throw () 
      ;


      /**
       * Obtain a callback for component destruction.
       * @param callback an object that implements the ComponentRelease
       * interface that will be called when the component is to be destroyed.
       * 
       * Register a callback to be executed when the component is going
       * to be destroyed.  During this callback, the Services object passed
       * through setServices will still be valid, but after all such
       * callbacks are made for a specific component, subsequent usage
       * of the Services object is not allowed/is undefined.
       */
      void
      registerForRelease (
        /* in */ ::gov::cca::ComponentRelease callback
      )
      throw ( 
        ::gov::cca::CCAException
      );



      //////////////////////////////////////////////////
      // 
      // End User Defined Methods
      // (everything else in this file is specific to
      //  Babel's C++ bindings)
      // 

    public:
      typedef struct gov_cca_Services__object ior_t;
      typedef struct gov_cca_Services__external ext_t;
      typedef struct gov_cca_Services__sepv sepv_t;

      // default constructor
      Services() : d_self(0), d_weak_reference(false) { }

      // default destructor
      virtual ~Services ();

      // copy constructor
      Services ( const Services& original );

      // assignment operator
      Services& operator= ( const Services& rhs );

      // conversion from ior to C++ class
      Services ( Services::ior_t* ior );

      // Alternate constructor: does not call addRef()
      // (sets d_weak_reference=isWeak)
      // For internal use by Impls (fixes bug#275)
      Services ( Services::ior_t* ior, bool isWeak );

      // conversion from a StubBase
      Services ( const ::sidl::StubBase& base );

      ior_t* _get_ior() { return d_self; }

      const ior_t* _get_ior() const { return d_self; }

      void _set_ior( ior_t* ptr ) { d_self = ptr; }

      bool _is_nil() const { return (d_self==0); }

      bool _not_nil() const { return (d_self!=0); }

      bool operator !() const { return (d_self==0); }

    protected:
      virtual void* _cast(const char* type) const;

    private:
      // Pointer to sidl's IOR type (one per instance)
      ior_t * d_self;

      // Weak references (used by Impl's only) don't add/deleteRef()
      bool d_weak_reference;

      // Pointer to external (DLL loadable) symbols (shared among instances)
      static const ext_t * s_ext;

    public:
      static const ext_t * _get_ext() throw ( ::sidl::NullIORException );

    }; // end class Services
  } // end namespace cca
} // end namespace gov

namespace sidl {
  // traits specialization
  template<>
  struct array_traits< ::gov::cca::Services > {
    typedef array< ::gov::cca::Services > cxx_array_t;
    typedef ::gov::cca::Services cxx_item_t;
    typedef struct gov_cca_Services__array ior_array_t;
    typedef sidl_interface__array ior_array_internal_t;
    typedef struct gov_cca_Services__object ior_item_t;
    typedef  cxx_item_t value_type;
    typedef  value_type reference;
    typedef  value_type* pointer;
    typedef  const value_type const_reference;
    typedef  const value_type* const_pointer;
    typedef  array_iter< array_traits< ::gov::cca::Services > > iterator;
    typedef  const_array_iter< array_traits< ::gov::cca::Services > > 
      const_iterator;
  };

  // array specialization
  template<>
  class array< ::gov::cca::Services >: public interface_array< array_traits< 
    ::gov::cca::Services > > {
  public:
    typedef interface_array< array_traits< ::gov::cca::Services > > Base;
    typedef array_traits< ::gov::cca::Services >::cxx_array_t          
      cxx_array_t;
    typedef array_traits< ::gov::cca::Services >::cxx_item_t           
      cxx_item_t;
    typedef array_traits< ::gov::cca::Services >::ior_array_t          
      ior_array_t;
    typedef array_traits< ::gov::cca::Services >::ior_array_internal_t 
      ior_array_internal_t;
    typedef array_traits< ::gov::cca::Services >::ior_item_t           
      ior_item_t;

    /**
     * conversion from ior to C++ class
     * (constructor/casting operator)
     */
    array( struct gov_cca_Services__array* src = 0) : Base(src) {}

    /**
     * copy constructor
     */
    array( const array< ::gov::cca::Services >&src) : Base(src) {}

    /**
     * assignment
     */
    array< ::gov::cca::Services >&
    operator =( const array< ::gov::cca::Services >&rhs ) { 
      if (d_array != rhs._get_baseior()) {
        if (d_array) deleteRef();
        d_array = const_cast<sidl__array *>(rhs._get_baseior());
        if (d_array) addRef();
      }
      return *this;
    }

  };
}

#endif
