// 
// File:          gov_cca_ports_BuilderService.hh
// Symbol:        gov.cca.ports.BuilderService-v0.6.3
// Symbol Type:   interface
// Babel Version: 0.10.2
// Description:   Client-side glue code for gov.cca.ports.BuilderService
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_gov_cca_ports_BuilderService_hh
#define included_gov_cca_ports_BuilderService_hh

// declare class before #includes
// (this alleviates circular #include guard problems)[BUG#393]
namespace gov { 
  namespace cca { 
    namespace ports { 

      class BuilderService;
    } // end namespace ports
  } // end namespace cca
} // end namespace gov

// Some compilers need to define array template before the specializations
#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
namespace sidl {
  template<>
  class array< ::gov::cca::ports::BuilderService >;
}

#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
#ifndef included_gov_cca_ports_BuilderService_IOR_h
#include "gov_cca_ports_BuilderService_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_gov_cca_CCAException_hh
#include "gov_cca_CCAException.hh"
#endif
#ifndef included_gov_cca_ComponentID_hh
#include "gov_cca_ComponentID.hh"
#endif
#ifndef included_gov_cca_ConnectionID_hh
#include "gov_cca_ConnectionID.hh"
#endif
#ifndef included_gov_cca_TypeMap_hh
#include "gov_cca_TypeMap.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif

namespace gov { 
  namespace cca { 
    namespace ports { 

      /**
       * Symbol "gov.cca.ports.BuilderService" (version 0.6.3)
       * 
       *    BuilderService is a Port implemented by a CCA compliant framework for
       * the purpose of composing components into applications in a standard way.
       * It is meant to expose the Component creation and composition functionality
       * without the specific framework implementation. This interface is expected 
       * to be useful for rapid application development in a scripting language. 
       * Other uses are generic application development environments for CCA 
       * applications. 
       * <p>Each of the fundamental component architecture pieces
       *    (instances of Component, Port, and Connection) may have
       *    an associated TypeMap of properties managed by the framework.
       *    The standardized keys in the properties of a Port are documented
       *    in Services.getPortProperties().
       *    The standardized keys in the properties of a Component and Connection
       *    are documented below.
       *  </p>
       *  <p>For connection, thus far:
       *    <pre>
       *    Key         value           meaning
       *    cca.isInUse boolean         true if there have been more successful
       * 				 getPort than releasePort calls for the
       * 				 connection at the the time 
       * 				 properties were fetched.
       *   </pre>
       *   </p>
       *  <P>For component, thus far:
       *   <pre>
       *    Key                 value           meaning
       *    cca.className       string          component type
       *   </pre>
       *  </p>
       */
      class BuilderService : public ::sidl::StubBase {

        //////////////////////////////////////////////////
        // 
        // User Defined Methods
        // 

      public:

        /**
         * <p>
         * Add one to the intrinsic reference count in the underlying object.
         * Object in <code>sidl</code> have an intrinsic reference count.
         * Objects continue to exist as long as the reference count is
         * positive. Clients should call this method whenever they
         * create another ongoing reference to an object or interface.
         * </p>
         * <p>
         * This does not have a return value because there is no language
         * independent type that can refer to an interface or a
         * class.
         * </p>
         */
        inline void
        addRef() throw () 
        {

          if ( !d_weak_reference ) {
            /*pack args to dispatch to ior*/
            (*(d_self->d_epv->f_addRef))(d_self->d_object );
            /*dispatch to ior*/
            /*unpack results and cleanup*/
          }
        }



        /**
         * Decrease by one the intrinsic reference count in the underlying
         * object, and delete the object if the reference is non-positive.
         * Objects in <code>sidl</code> have an intrinsic reference count.
         * Clients should call this method whenever they remove a
         * reference to an object or interface.
         */
        inline void
        deleteRef() throw () 
        {

          if ( !d_weak_reference ) {
            /*pack args to dispatch to ior*/
            (*(d_self->d_epv->f_deleteRef))(d_self->d_object );
            /*dispatch to ior*/
            /*unpack results and cleanup*/
            d_self = 0;
          }
        }



        /**
         * Return true if and only if <code>obj</code> refers to the same
         * object as this object.
         */
        bool
        isSame (
          /* in */ ::sidl::BaseInterface iobj
        )
        throw () 
        ;



        /**
         * Check whether the object can support the specified interface or
         * class.  If the <code>sidl</code> type name in <code>name</code>
         * is supported, then a reference to that object is returned with the
         * reference count incremented.  The callee will be responsible for
         * calling <code>deleteRef</code> on the returned object.  If
         * the specified type is not supported, then a null reference is
         * returned.
         */
        ::sidl::BaseInterface
        queryInt (
          /* in */ const ::std::string& name
        )
        throw () 
        ;



        /**
         * Return whether this object is an instance of the specified type.
         * The string name must be the <code>sidl</code> type name.  This
         * routine will return <code>true</code> if and only if a cast to
         * the string type name would succeed.
         */
        bool
        isType (
          /* in */ const ::std::string& name
        )
        throw () 
        ;



        /**
         * Return the meta-data about the class implementing this interface.
         */
        ::sidl::ClassInfo
        getClassInfo() throw () 
        ;


        /**
         * 	Creates an instance of a CCA component of the type defined by the 
         * 	string className.  The string classname uniquely defines the
         * 	"type" of the component, e.g.
         * 	    doe.cca.Library.GaussianElmination. 
         * 	It has an instance name given by the string instanceName.
         * 	The instanceName may be empty (zero length) in which case
         * 	the instanceName will be assigned to the component automatically.
         * 	@throws CCAException If the Component className is unknown, or if the
         * 		instanceName has already been used, a CCAException is thrown.
         * 	@return A ComponentID corresponding to the created component. Destroying
         * 		the returned ID does not destroy the component; 
         * 		see destroyInstance instead.
         */
        ::gov::cca::ComponentID
        createInstance (
          /* in */ const ::std::string& instanceName,
          /* in */ const ::std::string& className,
          /* in */ ::gov::cca::TypeMap properties
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         *  Get component list.
         *  @return a ComponentID for each component currently created.
         */
        ::sidl::array< ::gov::cca::ComponentID>
        getComponentIDs() throw ( 
          ::gov::cca::CCAException
        );


        /**
         *  Get property map for component.
         *  @return the public properties associated with the component referred to by
         *  ComponentID. 
         *  @throws a CCAException if the ComponentID is invalid.
         */
        ::gov::cca::TypeMap
        getComponentProperties (
          /* in */ ::gov::cca::ComponentID cid
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * 	Causes the framework implementation to associate the given properties 
         * 	with the component designated by cid. 
         * 	@throws CCAException if cid is invalid or if there is an attempted
         * 	change to a property locked by the framework implementation.
         */
        void
        setComponentProperties (
          /* in */ ::gov::cca::ComponentID cid,
          /* in */ ::gov::cca::TypeMap map
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Get component id from stringified reference.
         *    @return a ComponentID from the string produced by 
         * 	ComponentID.getSerialization(). 
         *    @throws CCAException if the string does not represent the appropriate 
         * 	 serialization of a ComponentID for the underlying framework.
         */
        ::gov::cca::ComponentID
        getDeserialization (
          /* in */ const ::std::string& s
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Get id from name by which it was created.
         *  @return a ComponentID from the instance name of the component
         *  produced by ComponentID.getInstanceName().
         *  @throws CCAException if there is no component matching the 
         *  given componentInstanceName.
         */
        ::gov::cca::ComponentID
        getComponentID (
          /* in */ const ::std::string& componentInstanceName
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         *  Eliminate the Component instance, from the scope of the framework.
         *  @param toDie the component to be removed.
         *  @param timeout the allowable wait; 0 means up to the framework.
         *  @throws CCAException if toDie refers to an invalid component, or
         *  if the operation takes longer than timeout seconds.
         */
        void
        destroyInstance (
          /* in */ ::gov::cca::ComponentID toDie,
          /* in */ float timeout
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         *  Get the names of Port instances provided by the identified component.
         *  @param cid the component.
         *  @throws CCAException if cid refers to an invalid component.
         */
        ::sidl::array< ::std::string>
        getProvidedPortNames (
          /* in */ ::gov::cca::ComponentID cid
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         *  Get the names of Port instances used by the identified component.
         *  @param cid the component.
         *  @throws CCAException if cid refers to an invalid component. 
         */
        ::sidl::array< ::std::string>
        getUsedPortNames (
          /* in */ ::gov::cca::ComponentID cid
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         *  Fetch map of Port properties exposed by the framework.
         *  @return the public properties pertaining to the Port instance 
         *    portname on the component referred to by cid. 
         *  @throws CCAException when any one of the following conditions occur:<ul>
         *    <li>portname is not a registered Port on the component indicated by cid,
         *    <li>cid refers to an invalid component. </ul>
         */
        ::gov::cca::TypeMap
        getPortProperties (
          /* in */ ::gov::cca::ComponentID cid,
          /* in */ const ::std::string& portName
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         *  Associates the properties given in map with the Port indicated by 
         *  portname. The component must have a Port known by portname.
         *  @throws CCAException if either cid or portname are
         * 	invalid, or if this a changed property is locked by 
         * 	 the underlying framework or component.
         */
        void
        setPortProperties (
          /* in */ ::gov::cca::ComponentID cid,
          /* in */ const ::std::string& portName,
          /* in */ ::gov::cca::TypeMap map
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         *   Creates a connection between ports on component user and 
         *   component provider. Destroying the ConnectionID does not
         *   cause a disconnection; for that, see disconnect().
         *   @throws CCAException when any one of the following conditions occur:<ul>
         *   <li>If either user or provider refer to an invalid component,
         *   <li>If either usingPortName or providingPortName refer to a 
         * 	 nonexistent Port on their respective component,
         *   <li>If other-- In reality there are a lot of things that can go wrong 
         * 	 with this operation, especially if the underlying connections 
         * 	 involve networking.</ul>
         */
        ::gov::cca::ConnectionID
        connect (
          /* in */ ::gov::cca::ComponentID user,
          /* in */ const ::std::string& usingPortName,
          /* in */ ::gov::cca::ComponentID provider,
          /* in */ const ::std::string& providingPortName
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Returns a list of connections as an array of 
         * 	handles. This will return all connections involving components 
         * 	in the given componentList of ComponentIDs. This
         * 	means that ConnectionID's will be returned even if only one 
         * 	of the participants in the connection appears in componentList.
         * 
         * 	@throws CCAException if any component in componentList is invalid.
         */
        ::sidl::array< ::gov::cca::ConnectionID>
        getConnectionIDs (
          /* in */ ::sidl::array< ::gov::cca::ComponentID> componentList
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         *   Fetch property map of a connection.
         *   @returns the properties for the given connection.
         *   @throws CCAException if connID is invalid.
         */
        ::gov::cca::TypeMap
        getConnectionProperties (
          /* in */ ::gov::cca::ConnectionID connID
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Associates the properties with the connection.
         *   @param map the source of the properties.
         *   @param connID connection to receive property values.
         *   @throws CCAException if connID is invalid, or if this changes 
         * 	 a property locked by the underlying framework.
         */
        void
        setConnectionProperties (
          /* in */ ::gov::cca::ConnectionID connID,
          /* in */ ::gov::cca::TypeMap map
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Disconnect the connection indicated by connID before the indicated
         *     timeout in secs. Upon successful completion, connID and the connection
         *     it represents become invalid. 
         *     @param timeout the time in seconds to wait for a connection to close; 0
         *     means to use the framework implementation default.
         *     @throws CCAException when any one of the following conditions occur: <ul>
         *     <li>id refers to an invalid ConnectionID,
         *     <li>timeout is exceeded, after which, if id was valid before 
         * disconnect() was invoked, it remains valid
         * </ul>
         * 
         */
        void
        disconnect (
          /* in */ ::gov::cca::ConnectionID connID,
          /* in */ float timeout
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Remove all connections between components id1 and id2 within 
         *   the period of timeout secs. If id2 is null, then all connections 
         *   to id1 are removed (within the period of timeout secs).
         *   @throws CCAException when any one of the following conditions occur:<ul>
         * 	  <li>id1 or id2 refer to an invalid ComponentID (other than id2 == null),
         * 	  <li>The timeout period is exceeded before the disconnections can be made. 
         * 	  </ul>
         */
        void
        disconnectAll (
          /* in */ ::gov::cca::ComponentID id1,
          /* in */ ::gov::cca::ComponentID id2,
          /* in */ float timeout
        )
        throw ( 
          ::gov::cca::CCAException
        );



        //////////////////////////////////////////////////
        // 
        // End User Defined Methods
        // (everything else in this file is specific to
        //  Babel's C++ bindings)
        // 

      public:
        typedef struct gov_cca_ports_BuilderService__object ior_t;
        typedef struct gov_cca_ports_BuilderService__external ext_t;
        typedef struct gov_cca_ports_BuilderService__sepv sepv_t;

        // default constructor
        BuilderService() : d_self(0), d_weak_reference(false) { }

        // default destructor
        virtual ~BuilderService ();

        // copy constructor
        BuilderService ( const BuilderService& original );

        // assignment operator
        BuilderService& operator= ( const BuilderService& rhs );

        // conversion from ior to C++ class
        BuilderService ( BuilderService::ior_t* ior );

        // Alternate constructor: does not call addRef()
        // (sets d_weak_reference=isWeak)
        // For internal use by Impls (fixes bug#275)
        BuilderService ( BuilderService::ior_t* ior, bool isWeak );

        // conversion from a StubBase
        BuilderService ( const ::sidl::StubBase& base );

        ior_t* _get_ior() { return d_self; }

        const ior_t* _get_ior() const { return d_self; }

        void _set_ior( ior_t* ptr ) { d_self = ptr; }

        bool _is_nil() const { return (d_self==0); }

        bool _not_nil() const { return (d_self!=0); }

        bool operator !() const { return (d_self==0); }

      protected:
        virtual void* _cast(const char* type) const;

      private:
        // Pointer to sidl's IOR type (one per instance)
        ior_t * d_self;

        // Weak references (used by Impl's only) don't add/deleteRef()
        bool d_weak_reference;

        // Pointer to external (DLL loadable) symbols (shared among instances)
        static const ext_t * s_ext;

      public:
        static const ext_t * _get_ext() throw ( ::sidl::NullIORException );

      }; // end class BuilderService
    } // end namespace ports
  } // end namespace cca
} // end namespace gov

namespace sidl {
  // traits specialization
  template<>
  struct array_traits< ::gov::cca::ports::BuilderService > {
    typedef array< ::gov::cca::ports::BuilderService > cxx_array_t;
    typedef ::gov::cca::ports::BuilderService cxx_item_t;
    typedef struct gov_cca_ports_BuilderService__array ior_array_t;
    typedef sidl_interface__array ior_array_internal_t;
    typedef struct gov_cca_ports_BuilderService__object ior_item_t;
    typedef  cxx_item_t value_type;
    typedef  value_type reference;
    typedef  value_type* pointer;
    typedef  const value_type const_reference;
    typedef  const value_type* const_pointer;
    typedef  array_iter< array_traits< ::gov::cca::ports::BuilderService > > 
      iterator;
    typedef  const_array_iter< array_traits< ::gov::cca::ports::BuilderService 
      > > const_iterator;
  };

  // array specialization
  template<>
  class array< ::gov::cca::ports::BuilderService >: public interface_array< 
    array_traits< ::gov::cca::ports::BuilderService > > {
  public:
    typedef interface_array< array_traits< ::gov::cca::ports::BuilderService > 
      > Base;
    typedef array_traits< ::gov::cca::ports::BuilderService >::cxx_array_t      
      cxx_array_t;
    typedef array_traits< ::gov::cca::ports::BuilderService >::cxx_item_t       
      cxx_item_t;
    typedef array_traits< ::gov::cca::ports::BuilderService >::ior_array_t      
      ior_array_t;
    typedef array_traits< ::gov::cca::ports::BuilderService 
      >::ior_array_internal_t ior_array_internal_t;
    typedef array_traits< ::gov::cca::ports::BuilderService >::ior_item_t       
      ior_item_t;

    /**
     * conversion from ior to C++ class
     * (constructor/casting operator)
     */
    array( struct gov_cca_ports_BuilderService__array* src = 0) : Base(src) {}

    /**
     * copy constructor
     */
    array( const array< ::gov::cca::ports::BuilderService >&src) : Base(src) {}

    /**
     * assignment
     */
    array< ::gov::cca::ports::BuilderService >&
    operator =( const array< ::gov::cca::ports::BuilderService >&rhs ) { 
      if (d_array != rhs._get_baseior()) {
        if (d_array) deleteRef();
        d_array = const_cast<sidl__array *>(rhs._get_baseior());
        if (d_array) addRef();
      }
      return *this;
    }

  };
}

#endif
