##
## File:        make.runF90
## Package:     Babel regression checks
## Revision:    $Revision: 4466 $
## Modified:    $Date: 2005-03-23 15:02:45 -0800 (Wed, 23 Mar 2005) $
## Description: automake makefile for run regression tests
##
## Copyright (c) 2000-2002, The Regents of the University of Calfornia.
## Produced at the Lawrence Livermore National Laboratory.
## Written by the Components Team <components@llnl.gov>
## UCRL-CODE-2002-054
## All rights reserved.
##
## This file is part of Babel. For more information, see
## http:##www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
## for Our Notice and the LICENSE file for the GNU Lesser General Public
## License.
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU Lesser General Public License (as published by
## the Free Software Foundation) version 2.1 dated February 1999.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
## conditions of the GNU Lesser General Public License for more details.
##
## You should have recieved a copy of the GNU Lesser General Public License
## along with this program; if not, write to the Free Software Foundation,
## Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

OUTPUTSIDL=$(srcdir)/../../output/output.sidl

if SUPPORT_FORTRAN90



check_PROGRAMS    = $(STATIC_PROGS) $(SHARED_PROGS)
check_SCRIPTS     = runAll.sh
check_LTLIBRARIES = libClient.la

BABELDIR    = $(top_builddir)/bin
INCLUDEDIR  = $(top_builddir)/runtime/sidl
INCLUDEDIR2 = $(top_builddir)/lib/sidlstubs/F90
LIBSIDLSTUB = $(top_builddir)/lib/sidlstubs/F90/libsidlstub_f90.la
LIBSIDL     = $(top_builddir)/runtime/sidl/libsidl.la
LIBSYNC     = ../../output/libC/libOutput.la
PUREBABELGEN = $(IORSRCS) $(ARRAYMODULESRCS) $(IORHDRS) \
	$(SKELSRCS) $(STUBHDRS) $(STUBMODULESRCS) $(STUBSRCS) \
	$(TYPEMODULESRCS)
CLEANFILES=$(PUREBABELGEN) babel-stamp babel-temp stamp-installcheck \
	core runAll

if SUPPORT_STATIC
if SUPPORT_FORTRAN77
  STATIC_TEMP_F77 = runF902F77
else
  STATIC_TEMP_F77 =
endif
STATIC_PROGS      = runF902C runF902Cxx runF902UCxx $(STATIC_TEMP_F77) runF902F90

runF902C_SOURCES        = $(TESTFILE)
runF902C_LDFLAGS        = -static
runF902C_LDADD          = libClient.la ../libC/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FCLIBS) 
runF902C_LINK		= $(LINK) $(FCMAIN)

runF902Cxx_SOURCES      = $(TESTFILE)
runF902Cxx_LDFLAGS      = -static
runF902Cxx_LDADD        = libClient.la ../libCxx/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FCLIBS) 
runF902Cxx_LINK        =  $(LIBTOOL) --tag=CXX --mode=link $(CXXLD) $(AM_CXXFLAGS) \
	$(CXXFLAGS) $(AM_LDFLAGS) -o $@ $(FCMAIN) 

runF902UCxx_SOURCES      = $(TESTFILE)
runF902UCxx_LDFLAGS      = -static
runF902UCxx_LDADD        = libClient.la ../libUCxx/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FCLIBS) 
runF902UCxx_LINK         = $(LIBTOOL) --tag=CXX --mode=link $(CXXLD) $(AM_CXXFLAGS) \
	$(CXXFLAGS) $(AM_LDFLAGS) -o $@ $(FCMAIN) 


if SUPPORT_FORTRAN77
runF902F77_SOURCES      = $(TESTFILE)
runF902F77_LDFLAGS      = -static
runF902F77_LDADD        = libClient.la ../libF77/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FLIBS) $(FCLIBS) 
runF902F77_LINK		= $(LINK) $(FCMAIN)
endif

runF902F90_SOURCES      = $(TESTFILE)
runF902F90_LDFLAGS      = -static
runF902F90_LDADD        = libClient.la ../libF90/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FCLIBS) 
runF902F90_LINK		= $(LINK) $(FCMAIN)
endif

if SUPPORT_SHARED
SHARED_PROGS            = runAll
runAll_SOURCES          = $(TESTFILE)
runAll_LDFLAGS		= -dynamic
runAll_LDADD            = libClient.la $(LIBSYNC) $(LIBSIDL) \
			  $(FCLIBS) 
runAll_LINK      	= $(LINK) $(FCMAIN) 

endif

nodist_libClient_la_SOURCES      = $(PUREBABELGEN)
libClient_la_LIBADD       = $(LIBSIDLSTUB) $(LIBSYNC) $(LIBSIDL) $(FCLIBS)
libClient_la_LDFLAGS      = -no-undefined -rpath `pwd`/.libs \
			    -release @VERSION@
libClient_la_LINK = $(LINK)

EXTRA_DIST = babel.make
AM_CPPFLAGS   = -I. -I$(INCLUDEDIR) -I$(INCLUDEDIR2)
AM_FCFLAGS    = $(CHASM_FORTRAN_MFLAG)$(INCLUDEDIR2)

STUBOBJS = $(STUBSRCS:.c=.lo)
STUBMODULEOBJS = $(STUBMODULESRCS:.F90=.lo)
ARRAYMODULEOBJS = $(ARRAYMODULESRCS:.F90=.lo)
TYPEMODULEOBJS = $(TYPEMODULESRCS:.F90=.lo)
libClient.la $(STUBOBJS) $(ARRAYMODULEOBJS) $(STUBMODULEOBJS) $(TYPEMODULEOBJS): babel-stamp

$(ARRAYMODULEOBJS) :  $(TYPEMODULEOBJS)
$(STUBMODULEOBJS): $(TYPEMODULEOBJS) $(ARRAYMODULEOBJS)

EXTRA_PROGRAMS  = force_cxx_linker
force_cxx_linker_SOURCES = force_cxx_linker.cc
endif

# Customize some F90 macros since automake (as of 1.9.3) 
# still doesn't include the --tag specifier for libtool
LTPPFCCOMPILE = $(LIBTOOL) --mode=compile --tag=FC $(FC) $(DEFS) \
	$(DEFAULT_INCLUDES) $(INCLUDES) $(AM_CPPFLAGS) $(CPPFLAGS) \
	$(AM_FCFLAGS) $(FCFLAGS)
FCLINK = $(LIBTOOL) --mode=link --tag=FC $(FCLD) $(AM_FFLAGS) $(FCFLAGS) \
	$(AM_LDFLAGS) $(LDFLAGS) -o $@

$(PUREBABELGEN) : babel-stamp
	@if test -f $@; then\
	  touch $@; \
	else \
	  rm -f babel-stamp; \
	  $(MAKE) $(AM_MAKEFLAGS) babel-stamp ; \
	fi

babel-stamp: $(SIDLFILE) $(OUTPUTSIDL)
	@rm -f babel-temp
	@touch babel-temp
	$(SHELL) $(BABELDIR)/babel --client=f90 \
		--suppress-timestamp --exclude-external $(SIDLFILE) \
	        $(OUTPUTSIDL)
	@mv -f babel-temp $@

update-babel-make:babel-stamp
	if test "X$(srcdir)" != "X."; then \
	   cp babel.make $(srcdir); \
	fi

clean-local:
	rm -f *.a *.so *.mod *.f90
	test "X$(srcdir)" = "X." || rm -f babel.make


# Override default F90 macros since automake (as of 1.9.3) doesn't 
# really allow us to override preprocessing step.
.F90.o:
	$(CPP) -traditional $(DEFS) $(DEFAULT_INCLUDES) $(INCLUDES)  $(AM_CPPFLAGS) $(CPPFLAGS) \
		-P -o $(@:.o=.f90) -x c `test -f '$<' || echo '$(srcdir)/'`$<
	$(PPFCCOMPILE) -c -o $@ $(@:.o=.f90)
	rm -f $(@:.o=.f90)

.F90.obj:
	$(CPP) -traditional $(DEFS) $(DEFAULT_INCLUDES) $(INCLUDES)  $(AM_CPPFLAGS) $(CPPFLAGS) \
		-P -o $(@:.obj=.f90) -x c `test -f '$<' || echo '$(srcdir)/'`$<
	$(PPFCCOMPILE) -c -o $@ $(@:.obj=.f90)
	rm -f $(@:.obj=.f90)

.F90.lo:
	$(CPP) -traditional $(DEFS) $(DEFAULT_INCLUDES) $(INCLUDES)  $(AM_CPPFLAGS) $(CPPFLAGS) \
		 -P -o $(@:.lo=.f90) -x c `test -f '$<' || echo '$(srcdir)/'`$<
	$(LTPPFCCOMPILE) -c -o $@  $(@:.lo=.f90)
	rm -f $(@:.lo=.f90)

check-local:
	@if test -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS) $(check_LTLIBRARIES) $(check_PROGRAMS) $(check_SCRIPTS) 

installcheck-local:
	@if test ! -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS)				\
	  BABELDIR=$(bindir)				\
	  INCLUDEDIR=$(includedir)			\
	  INCLUDEDIR2=$(includedir)/F90			\
	  LIBSIDLSTUB=$(libdir)/libsidlstub_f90.la	\
	  LIBSIDL=$(libdir)/libsidl.la  $(check_LTLIBRARIES) $(check_PROGRAMS) $(check_SCRIPTS)
	touch stamp-installcheck

# Make sure Makefile.in is newer than babel.make
dist-hook:
	touch -c $(distdir)/Makefile.in
