/*
 * File:          objarg_EmployeeArray_jniStub.c
 * Symbol:        objarg.EmployeeArray-v0.5
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Client-side JNI glue code for objarg.EmployeeArray
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "objarg_EmployeeArray_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct objarg_EmployeeArray__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct objarg_EmployeeArray__object*) ptr;
}

/*
 * External reference to IOR methods.
 */

static const struct objarg_EmployeeArray__external* s_external = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * Return the number of employees in the employee array.
 */

static jint
jni_getLength(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_EmployeeArray__object* _ior = NULL;
  int32_t _ior_res = 0;
  jint _res = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getLength))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jint) _ior_res;

  return _res;
}

/*
 * Return the employee in position <code>index</code> where
 * <code>index</code> ranges from 1 to the length of the array.
 * If <code>index</code> is outside the range of the array (i.e.
 * less than or equal to zero or greater than the current number
 * of elements in the array), this method returns a NULL
 * employee object.
 */

static jobject
jni_at(
  JNIEnv* env,
  jobject obj,
  jint _arg_index)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_EmployeeArray__object* _ior = NULL;
  int32_t _tmp_index = 0;
  struct objarg_Employee__object* _ior_res = (struct objarg_Employee__object*) 
    NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_index = (int32_t) _arg_index;

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_at))(
    _ior,
    _tmp_index);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_cls(env, _ior_res, "objarg.Employee");

  return _res;
}

/*
 * Add an employee onto the end of the array.  It is perfectly
 * legal to add the same employee multiple times.
 * <code>true</code> is returned when the append was successful;
 * otherwise, <code>false</code> is returned to indicate
 * failure.  This method will not add a NULL employee.
 */

static jboolean
jni_appendEmployee(
  JNIEnv* env,
  jobject obj,
  jobject _arg_e)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_EmployeeArray__object* _ior = NULL;
  struct objarg_Employee__object* _tmp_e = (struct objarg_Employee__object*) 
    NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_e = (struct objarg_Employee__object*) sidl_Java_J2I_cls(env, _arg_e);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_appendEmployee))(
    _ior,
    _tmp_e);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Find the first employee in the array that has a name matching
 * <code>name</code>.  If a match exists, the index is returned,
 * and the employee is returned in parameter <code>e</code>.
 * 
 * If no match exists, 0 is returned, and <code>e</code> is NULL.
 */

static jint
jni_findByName(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name,
  jobject _arg_e)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_EmployeeArray__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  struct objarg_Employee__object* _tmp_e = (struct objarg_Employee__object*) 
    NULL;
  int32_t _ior_res = 0;
  jint _res = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);
  if(_arg_e== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as OUT Argument");
    return 0;
    }

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_findByName))(
    _ior,
    _tmp_name,
    &_tmp_e);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  sidl_Java_I2J_cls_holder(env, _arg_e, _tmp_e, "objarg.Employee");
  _res = (jint) _ior_res;

  return _res;
}

/*
 * Determine the maximum salary in the array. If the maximum
 * salary in the array is greater than the current salary of
 * <code>e</code>, the salary of <code>e</code> will be 
 * increased to the maximum salary in the array.  If the
 * array is empty, no change will be made to <code>e</code>.
 * 
 * This method returns <code>true</code> iff the salary of
 * <code>e</code> is modified.
 */

static jboolean
jni_promoteToMaxSalary(
  JNIEnv* env,
  jobject obj,
  jobject _arg_e)
{
  /*
   * Declare return and temporary variables.
   */

  struct objarg_EmployeeArray__object* _ior = NULL;
  struct objarg_Employee__object* _tmp_e = (struct objarg_Employee__object*) 
    NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  if(_arg_e== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as INOUT Argument");
    return 0;
    }
  _tmp_e = (struct objarg_Employee__object*) sidl_Java_J2I_cls_holder(env,
    _arg_e, "objarg.Employee");

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_promoteToMaxSalary))(
    _ior,
    &_tmp_e);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_Java_I2J_cls_holder(env, _arg_e, _tmp_e, "objarg.Employee");
  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Register JNI methods with the Java JVM.
 */

void objarg_EmployeeArray__register(JNIEnv* env)
{
  JNINativeMethod methods[6];
  jclass cls;

#ifdef SIDL_STATIC_LIBRARY
  s_external = objarg_EmployeeArray__externals();
#else
  sidl_DLL dll = sidl_DLL__create();
  const struct objarg_EmployeeArray__external*(*dll_f)(void);
  /* check global namespace for symbol first */
  if (dll && sidl_DLL_loadLibrary(dll, "main:", TRUE, FALSE)) {
    dll_f =
      (const struct objarg_EmployeeArray__external*(*)(void)) 
        sidl_DLL_lookupSymbol(
        dll, "objarg_EmployeeArray__externals");
    s_external = (dll_f ? (*dll_f)() : NULL);
  }
  if (dll) sidl_DLL_deleteRef(dll);
  if (!s_external) {
    dll = sidl_Loader_findLibrary("objarg.EmployeeArray",
      "ior/impl", sidl_Scope_SCLSCOPE,
      sidl_Resolve_SCLRESOLVE);
    if (dll) {
      dll_f =
        (const struct objarg_EmployeeArray__external*(*)(void)) 
          sidl_DLL_lookupSymbol(
          dll, "objarg_EmployeeArray__externals");
      s_external = (dll_f ? (*dll_f)() : NULL);
      sidl_DLL_deleteRef(dll);
    }
  }
  if (!s_external) {
    jclass e = (*env)->FindClass(env, "java/lang/UnsatisfiedLinkError");
    if (e != NULL) {
      (*env)->ThrowNew(env, e, "Could not find implementation for sidl class objarg.EmployeeArray");
      (*env)->DeleteLocalRef(env, e);
    }
  }
#endif

  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "getLength";
  methods[1].signature = "()I";
  methods[1].fnPtr     = (void *)jni_getLength;
  methods[2].name      = "at";
  methods[2].signature = "(I)Lobjarg/Employee;";
  methods[2].fnPtr     = (void *)jni_at;
  methods[3].name      = "appendEmployee";
  methods[3].signature = "(Lobjarg/Employee;)Z";
  methods[3].fnPtr     = (void *)jni_appendEmployee;
  methods[4].name      = "findByName";
  methods[4].signature = "(Ljava/lang/String;Lobjarg/Employee$Holder;)I";
  methods[4].fnPtr     = (void *)jni_findByName;
  methods[5].name      = "promoteToMaxSalary";
  methods[5].signature = "(Lobjarg/Employee$Holder;)Z";
  methods[5].fnPtr     = (void *)jni_promoteToMaxSalary;


  cls = (*env)->FindClass(env, "objarg/EmployeeArray");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 6);
    (*env)->DeleteLocalRef(env, cls);
  }
}
