/*
 * File:          sidl_rmi_InstanceRegistry_jniStub.c
 * Symbol:        sidl.rmi.InstanceRegistry-v0.9.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.rmi.InstanceRegistry
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_rmi_InstanceRegistry_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * External reference to IOR methods.
 */

static const struct sidl_rmi_InstanceRegistry__external* s_external = NULL;

/*
 * External reference to static EPV.
 */

static const struct sidl_rmi_InstanceRegistry__sepv* s_sepv = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * register an instance of a class
 *  the registry will return a string guaranteed to be unique for
 *  the lifetime of the process
 */

static jstring
jni_registerInstance(
  JNIEnv* env,
  jclass  cls,
  jobject _arg_instance)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseClass__object* _tmp_instance = (struct 
    sidl_BaseClass__object*) NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_instance = (struct sidl_BaseClass__object*) sidl_Java_J2I_cls(env,
    _arg_instance);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_registerInstance))(
    _tmp_instance,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * returns a handle to the class based on the unique string
 */

static jobject
jni_getInstance(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_instanceID)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_instanceID = (char*) NULL;
  struct sidl_BaseClass__object* _ior_res = (struct sidl_BaseClass__object*) 
    NULL;
  jobject _res = (jobject) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_instanceID = sidl_Java_J2I_string(env, _arg_instanceID);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_getInstance))(
    _tmp_instanceID,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_instanceID);
  _res = sidl_Java_I2J_cls(env, _ior_res, "sidl.BaseClass");
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * returns a handle to the class based on the unique string
 * and removes the instance from the table.  
 */

static jobject
jni_removeInstance(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_instanceID)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_instanceID = (char*) NULL;
  struct sidl_BaseClass__object* _ior_res = (struct sidl_BaseClass__object*) 
    NULL;
  jobject _res = (jobject) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_instanceID = sidl_Java_J2I_string(env, _arg_instanceID);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_removeInstance))(
    _tmp_instanceID,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_instanceID);
  _res = sidl_Java_I2J_cls(env, _ior_res, "sidl.BaseClass");
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_rmi_InstanceRegistry__register(JNIEnv* env)
{
  JNINativeMethod methods[4];
  jclass cls;

  s_external = sidl_rmi_InstanceRegistry__externals();
  s_sepv = (*(s_external->getStaticEPV))();

  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "registerInstance";
  methods[1].signature = "(Lsidl/BaseClass;)Ljava/lang/String;";
  methods[1].fnPtr     = (void *)jni_registerInstance;
  methods[2].name      = "getInstance";
  methods[2].signature = "(Ljava/lang/String;)Lsidl/BaseClass;";
  methods[2].fnPtr     = (void *)jni_getInstance;
  methods[3].name      = "removeInstance";
  methods[3].signature = "(Ljava/lang/String;)Lsidl/BaseClass;";
  methods[3].fnPtr     = (void *)jni_removeInstance;


  cls = (*env)->FindClass(env, "sidl/rmi/InstanceRegistry");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 4);
    (*env)->DeleteLocalRef(env, cls);
  }
}
