// 
// File:          sort_MergeSort_Impl.cc
// Symbol:        sort.MergeSort-v0.1
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for sort.MergeSort
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "sort_MergeSort_Impl.hh"

// 
// Includes for all method dependencies.
// 
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif
#ifndef included_sort_Comparator_hh
#include "sort_Comparator.hh"
#endif
#ifndef included_sort_Container_hh
#include "sort_Container.hh"
#endif
#ifndef included_sort_Counter_hh
#include "sort_Counter.hh"
#endif
#line 32 "../../../../babel/regression/sort/libUCxx/sort_MergeSort_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.MergeSort._includes)
static void
mergeLists(ucxx::sort::Container  &elems,
           ucxx::sort::Comparator &comp,
           ucxx::sort::Counter    &cmp,
           ucxx::sort::Counter    &swp,
           int32_t          start,
           int32_t          mid,
           const int32_t    end)
{
  int32_t j;
  while ((start < mid) && (mid < end)) {
    cmp.inc();
    if (elems.compare(start, mid, comp) > 0) {
      /* move first element of upper list into place */
      for(j = mid;j > start; --j) {
	swp.inc();
	elems.swap(j, j - 1);
      }
      ++mid;
    }
    ++start;
  }
}

/**
 * end is one past the end
 */
static void
mergeSort(ucxx::sort::Container  &elems,
          ucxx::sort::Comparator &comp,
          ucxx::sort::Counter    &cmp,
          ucxx::sort::Counter    &swp,
          const int32_t   start,
          const int32_t   end)
{
  if ((end - start) > 1) {
    int32_t mid = (start + end) >> 1;
    mergeSort(elems, comp, cmp, swp, start, mid);
    mergeSort(elems, comp, cmp, swp, mid, end);
    mergeLists(elems, comp, cmp, swp, start, mid, end);
  }
}
// DO-NOT-DELETE splicer.end(sort.MergeSort._includes)
#line 77 "sort_MergeSort_Impl.cc"

// user defined constructor
void sort::MergeSort_impl::_ctor() {
#line 79 "../../../../babel/regression/sort/libUCxx/sort_MergeSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.MergeSort._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(sort.MergeSort._ctor)
#line 85 "sort_MergeSort_Impl.cc"
}

// user defined destructor
void sort::MergeSort_impl::_dtor() {
#line 86 "../../../../babel/regression/sort/libUCxx/sort_MergeSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.MergeSort._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(sort.MergeSort._dtor)
#line 94 "sort_MergeSort_Impl.cc"
}

// static class initializer
void sort::MergeSort_impl::_load() {
#line 93 "../../../../babel/regression/sort/libUCxx/sort_MergeSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.MergeSort._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(sort.MergeSort._load)
#line 103 "sort_MergeSort_Impl.cc"
}

// user defined static methods: (none)

// user defined non-static methods:
/**
 * Sort elements using Merge Sort.
 */
void
sort::MergeSort_impl::sort_impl (
  /* in */::ucxx::sort::Container elems,
  /* in */::ucxx::sort::Comparator comp ) 
throw () 
{
#line 110 "../../../../babel/regression/sort/libUCxx/sort_MergeSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.MergeSort.sort)
  const int32_t num = elems.getLength();
  ucxx::sort::Counter cmp = getCompareCounter();
  ucxx::sort::Counter swp = getSwapCounter();
  mergeSort(elems, comp, cmp, swp, 0, num);
  // DO-NOT-DELETE splicer.end(sort.MergeSort.sort)
#line 125 "sort_MergeSort_Impl.cc"
}

/**
 * Return merge sort.
 */
::std::string
sort::MergeSort_impl::getName_impl () 
throw () 

{
#line 126 "../../../../babel/regression/sort/libUCxx/sort_MergeSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.MergeSort.getName)
  return "Merge sort";
  // DO-NOT-DELETE splicer.end(sort.MergeSort.getName)
#line 140 "sort_MergeSort_Impl.cc"
}


#line 132 "../../../../babel/regression/sort/libUCxx/sort_MergeSort_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.MergeSort._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.MergeSort._misc)
#line 148 "sort_MergeSort_Impl.cc"

