
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.gui;

import java.awt.*;

/**
 * Used to position objects on the screen.
 */
public class Positioner {
    /**
     * Position a given frame in the centre of the screen.
     *
     * @param frame the frame to centre.
     */
    public static void centerOnScreen(Frame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height)
            frameSize.height = screenSize.height;
        if (frameSize.width > screenSize.width)
            frameSize.width = screenSize.width;
        frame.setLocation((screenSize.width - frameSize.width) / 2,
            (screenSize.height - frameSize.height) / 2);
    }

    /**
     * Position a given dialog in the centre of the screen.
     *
     * @param dialog the dialog to centre.
     */
    public static void centerOnScreen(Dialog dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = dialog.getSize();
        if (dlgSize.height > screenSize.height)
            dlgSize.height = screenSize.height;
        if (dlgSize.width > screenSize.width)
            dlgSize.width = screenSize.width;
        dialog.setLocation((screenSize.width - dlgSize.width) / 2,
            (screenSize.height - dlgSize.height) / 2);
    }

    /**
     * Position a given dialog over the centre of a frame.
     *
     * @param dialog the dialog to centre.
     * @param frame the frame about which to centre the dialog.
     */
    public static void centerInFrame(Dialog dialog, Frame frame) {
        Dimension dlgSize = dialog.getSize();
        Dimension frameSize = frame.getSize();
        Point loc = frame.getLocation();
        dialog.setLocation((frameSize.width - dlgSize.width) / 2 + loc.x,
            (frameSize.height - dlgSize.height) / 2 + loc.y);
    }
};

