/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.OutputDocumentHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Version;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FOTreeBuilder;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.render.Renderer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class PDFOutputHandler
extends FOTreeBuilder
implements OutputDocumentHandler {
    protected AreaTree areaTree;
    protected Renderer renderer;
    protected PrintWriter writer;
    private boolean keepOpen;

    public PDFOutputHandler() {
    }

    public PDFOutputHandler(OutputStream outputStream) {
        this();
        this.writer = new PrintWriter(outputStream);
    }

    public void addElementMapping(String string) {
        this.createElementMapping(string).addToBuilder(this);
    }

    public void addElementMapping(ElementMapping elementMapping) {
        elementMapping.addToBuilder(this);
    }

    protected ElementMapping createElementMapping(String string) {
        System.err.println("using element mapping " + string);
        try {
            return (ElementMapping)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            System.err.println(String.valueOf(string) + " is not an element mapping");
        }
        return null;
    }

    protected Renderer createRenderer(String string) {
        System.err.println("using renderer " + string);
        try {
            return (Renderer)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            System.err.println(String.valueOf(string) + " is not a renderer");
        }
        return null;
    }

    public void doFormat() throws FOPException {
        FontInfo fontInfo = new FontInfo();
        this.renderer.setupFontInfo(fontInfo);
        this.areaTree = new AreaTree();
        this.areaTree.setFontInfo(fontInfo);
        this.format(this.areaTree);
    }

    public void doRender() throws IOException {
        this.renderer.render(this.areaTree, this.writer);
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        try {
            this.doFormat();
            this.doRender();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FOPException fOPException) {
            throw new SAXException(fOPException);
        }
        this.writer.flush();
    }

    public DocumentHandler init(Destination destination, AttributeList attributeList) throws IOException {
        this.writer = new PrintWriter(destination.getOutputStream("application/pdf", null));
        this.keepOpen = destination.keepOpen();
        String string = Version.getVersion();
        this.setRenderer("org.apache.fop.render.pdf.PDFRenderer", string);
        this.addElementMapping("org.apache.fop.fo.StandardElementMapping");
        this.addElementMapping("org.apache.fop.svg.SVGElementMapping");
        return this;
    }

    public void setRenderer(String string, String string2) {
        this.renderer = this.createRenderer(string);
        this.renderer.setProducer(string2);
    }
}

