/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.sql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    public static final String ERROR_ELEMENT = "error-element";
    public static final String ERROR_MESSAGE_ATTRIBUTE = "error-message-attribute";
    public static final String ERROR_MESSAGE_ELEMENT = "error-message-element";
    public static final String ERROR_STACKTRACE_ATTRIBUTE = "error-stacktrace-attribute";
    public static final String ERROR_STACKTRACE_ELEMENT = "error-stacktrace-element";
    public static final String ERROR_MESSAGE_TEXT = "error-message-text";

    public static Element createElement(Document document, String namespace, String name) {
        if (namespace == null) {
            return document.createElement(name);
        }
        return document.createElement(String.valueOf(namespace) + ':' + name);
    }

    public static Element createErrorElement(Document document, String namespace, Properties props, Exception e) {
        Element element = document.createElement(props.getProperty(ERROR_ELEMENT));
        String message_attribute = props.getProperty(ERROR_MESSAGE_ATTRIBUTE);
        String message_element = props.getProperty(ERROR_MESSAGE_ELEMENT);
        String message_text = props.getProperty(ERROR_MESSAGE_TEXT);
        if (message_text == null) {
            message_text = e.getMessage();
        }
        if (!message_attribute.equals("")) {
            element.setAttribute(message_attribute, e.getMessage());
        }
        if (!message_element.equals("")) {
            Element child = document.createElement(message_element);
            child.appendChild(document.createTextNode(e.getMessage()));
            element.appendChild(child);
        }
        String stacktrace_attribute = props.getProperty(ERROR_STACKTRACE_ATTRIBUTE);
        String stacktrace_element = props.getProperty(ERROR_STACKTRACE_ELEMENT);
        String stacktrace = null;
        if (!stacktrace_attribute.equals("") || !stacktrace_element.equals("")) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            stacktrace = sw.toString();
        }
        if (!stacktrace_attribute.equals("")) {
            element.setAttribute(stacktrace_attribute, stacktrace);
        }
        if (!stacktrace_element.equals("")) {
            Element child = document.createElement(stacktrace_element);
            child.appendChild(document.createTextNode(stacktrace));
            element.appendChild(child);
        }
        return element;
    }

    public static Properties getAttributes(Element element, HttpServletRequest req, Properties master) {
        Properties props = master == null ? new Properties() : new Properties(master);
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            ((Hashtable)props).put(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
        if (req != null) {
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                ((Hashtable)props).put(name, req.getParameter(name));
            }
        }
        return props;
    }

    public static Hashtable getValues(HttpServletRequest req) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String[] values = req.getParameterValues(name);
            if (values.length == 1) {
                table.put(name, values[0]);
                continue;
            }
            table.put(name, values);
        }
        return table;
    }

    public static String join(Vector vector, char joiner) {
        Enumeration e = vector.elements();
        StringBuffer sb = new StringBuffer();
        if (e.hasMoreElements()) {
            sb.append(e.nextElement());
        }
        while (e.hasMoreElements()) {
            sb.append(joiner);
            sb.append(e.nextElement());
        }
        return sb.toString();
    }

    public static String replace(String source, char target, String replacement) {
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(source);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == target) {
                sb.append(replacement);
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        return sb.toString();
    }

    public static Vector split(String source, char seperator) {
        Vector<String> results = new Vector<String>();
        if (source == null) {
            return results;
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(source);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == seperator) {
                results.addElement(sb.toString());
                sb = new StringBuffer();
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        if (c != seperator) {
            results.addElement(sb.toString());
        }
        return results;
    }
}

