/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.language.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class XSPClassLoader
extends ClassLoader {
    protected File repository;

    public XSPClassLoader(File repository) {
        this.repository = repository;
    }

    protected String getClassFileName(String className) {
        try {
            return String.valueOf(this.repository.getCanonicalPath()) + File.separator + className.replace('.', File.separatorChar) + ".class";
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            block6: {
                try {
                    c = this.findSystemClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    byte[] bits = this.loadClassData(name);
                    if (bits == null) {
                        ClassLoader cl = this.getClass().getClassLoader();
                        if (cl != null) {
                            c = cl.loadClass(name);
                        }
                    }
                    c = this.defineClass(null, bits, 0, bits.length);
                    if (!resolve) break block6;
                    this.resolveClass(c);
                }
            }
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
        }
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] loadClassData(String className) {
        File file = new File(this.getClassFileName(className));
        byte[] buf = null;
        FileInputStream in = null;
        int n = 0;
        int pos = 0;
        if (!file.exists()) return buf;
        buf = new byte[(int)file.length()];
        try {
            try {
                in = new FileInputStream(file);
                while (pos < buf.length && (n = in.read(buf, pos, buf.length - pos)) != -1) {
                    pos += n;
                }
            }
            catch (IOException iOException) {
                buf = null;
            }
            Object var8_7 = null;
            if (in == null) return buf;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
            return buf;
        }
        catch (IOException iOException) {}
        return buf;
    }

    public XSPClassLoader reinstantiate() {
        return new XSPClassLoader(this.repository);
    }
}

