/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.library.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSPCalendar {
    public static SimpleDateFormat month_number_format = new SimpleDateFormat("M");
    public static SimpleDateFormat month_name_format = new SimpleDateFormat("MMMM");
    public static SimpleDateFormat month_format = new SimpleDateFormat("yyyy-MM");

    public static Element generateMonth(Document document, String date_format) {
        return XSPCalendar.generateMonth(document, date_format, new Date());
    }

    public static Element generateMonth(Document document, String date_format, String date) throws ParseException {
        return XSPCalendar.generateMonth(document, date_format, month_format.parse(date));
    }

    public static Element generateMonth(Document document, String date_format, Date date) {
        SimpleDateFormat format = null;
        if (date_format != null) {
            format = new SimpleDateFormat(date_format);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Element month_element = document.createElement("month");
        month_element.setAttribute("number", month_number_format.format(date));
        month_element.setAttribute("name", month_name_format.format(date));
        month_element.setAttribute("year", String.valueOf(calendar.get(1)));
        Element week_element = document.createElement("week");
        int week_number = 1;
        week_element.setAttribute("number", "1");
        int week_of_year_number = calendar.get(3);
        week_element.setAttribute("week_of_year", String.valueOf(week_of_year_number));
        month_element.appendChild(week_element);
        calendar.set(5, 1);
        Calendar temp = (Calendar)calendar.clone();
        while (temp.get(7) != 1) {
            temp.add(5, -1);
            week_element.appendChild(document.createElement("day"));
        }
        temp.setTime(calendar.getTime());
        while (temp.get(2) == calendar.get(2)) {
            if (temp.get(7) == 1 && temp.get(5) != 1) {
                week_element = document.createElement("week");
                week_element.setAttribute("number", String.valueOf(++week_number));
                week_element.setAttribute("week_of_year", String.valueOf(week_of_year_number + week_number));
                month_element.appendChild(week_element);
            }
            Element day_element = document.createElement("day");
            day_element.setAttribute("number", String.valueOf(temp.get(5)));
            day_element.setAttribute("day_of_year", String.valueOf(temp.get(6)));
            day_element.setAttribute("string", String.valueOf(format.format(temp.getTime())));
            week_element.appendChild(day_element);
            temp.add(5, 1);
        }
        while (temp.get(7) != 1) {
            week_element.appendChild(document.createElement("day"));
            temp.add(5, 1);
        }
        return month_element;
    }
}

