/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class Main {
    public static void writeImage(ImageTranscoder imageTranscoder, String string, String string2) {
        try {
            System.out.println("Converting " + string + " to " + string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            imageTranscoder.transcode(new TranscoderInput(string), new TranscoderOutput(bufferedOutputStream));
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            System.out.println("Error while writing " + string + " to " + string2);
        }
    }

    public static void error(String string) {
        System.err.println(string);
    }

    public static void usage(PrintStream printStream) {
        printStream.println("usage: rasterizer [options] [@files]");
        printStream.println("-d <directory>   Destination directory for output files");
        printStream.println("-m <mimetype>    Mime type for output files");
    }

    public static void main(String[] stringArray) {
        String string = "image/png";
        String string2 = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d")) {
                if (n + 1 < stringArray.length) {
                    int n2 = ++n;
                    ++n;
                    string2 = stringArray[n2];
                    continue;
                }
                Main.error("option -d requires an argument");
                Main.usage(System.err);
                System.exit(1);
                continue;
            }
            if (stringArray[n].equals("-m")) {
                if (n + 1 < stringArray.length) {
                    int n3 = ++n;
                    ++n;
                    string = stringArray[n3];
                    continue;
                }
                Main.error("option -m requires an argument");
                Main.usage(System.err);
                System.exit(1);
                continue;
            }
            if (stringArray[n].equals("-help")) {
                Main.usage(System.out);
                System.exit(0);
                continue;
            }
            linkedList.add(stringArray[n++]);
        }
        ImageTranscoder imageTranscoder = null;
        if (string.equals("image/jpg") || string.equals("image/jpeg") || string.equals("image/jpe")) {
            imageTranscoder = new JPEGTranscoder();
            imageTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, "org.apache.crimson.parser.XMLReaderImpl");
        } else if (string.equals("image/png")) {
            imageTranscoder = new PNGTranscoder();
            imageTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, "org.apache.crimson.parser.XMLReaderImpl");
        }
        if (imageTranscoder == null) {
            Main.error("No transcoder found for mime type : " + string);
            System.exit(1);
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            File file = new File(string3);
            String string4 = file.getName();
            if (string4.endsWith(".svg")) {
                string4 = string4.substring(0, string4.lastIndexOf(".svg"));
                int n4 = string.lastIndexOf(47);
                if (n4 > 0) {
                    String string5 = string.substring(n4 + 1);
                    if (string5.length() > 0) {
                        string4 = string4 + "." + string5;
                    }
                } else {
                    string4 = string4 + "." + string;
                }
            }
            if (string2 == null) {
                string2 = file.getParent();
            }
            File file2 = new File(string2, string4);
            try {
                Main.writeImage(imageTranscoder, file.toURL().toString(), file2.getAbsolutePath());
            }
            catch (MalformedURLException malformedURLException) {
                Main.error("Bad svg file : " + string3);
            }
        }
        System.exit(0);
    }
}

