/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

public class PropertyMap {
    protected static final float LOAD_FACTOR = 0.75f;
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;
    protected int threshold;

    public PropertyMap() {
        this.table = new Entry[11];
        this.threshold = 8;
    }

    public PropertyMap(PropertyMap propertyMap) {
        this.threshold = propertyMap.threshold;
        this.count = propertyMap.count;
        this.table = new Entry[propertyMap.table.length];
        int n = 0;
        while (n < this.table.length) {
            Entry entry = propertyMap.table[n];
            Entry entry2 = null;
            if (entry != null) {
                this.table[n] = entry2 = new Entry(entry.hash, entry.key, entry.value, null);
                entry = entry.next;
                while (entry != null) {
                    entry2 = entry2.next = new Entry(entry.hash, entry.key, entry.value, null);
                    entry = entry.next;
                }
            }
            ++n;
        }
    }

    public int size() {
        return this.count;
    }

    public Object get(Object object) {
        int n = object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key == object) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        Entry entry;
        int n = object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry2 = this.table[n2];
        while (entry2 != null) {
            if (entry2.hash == n && entry2.key == object) {
                Object object3 = entry2.value;
                entry2.value = object2;
                return object3;
            }
            entry2 = entry2.next;
        }
        if (this.count++ >= this.threshold) {
            this.rehash();
            n2 = n % this.table.length;
        }
        this.table[n2] = entry = new Entry(n, object, object2, this.table[n2]);
        return null;
    }

    public Object remove(Object object) {
        int n = object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = null;
        Entry entry2 = this.table[n2];
        while (entry2 != null) {
            if (entry2.hash == n && entry2.key == object) {
                Object object2 = entry2.value;
                if (entry == null) {
                    this.table[n2] = entry2.next;
                } else {
                    entry.next = entry2.next;
                }
                --this.count;
                return object2;
            }
            entry = entry2;
            entry2 = entry2.next;
        }
        return null;
    }

    public Object key(int n) {
        if (n < 0 || n >= this.count) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.table.length) {
            Entry entry = this.table[n3];
            if (entry != null) {
                do {
                    if (n2++ != n) continue;
                    return entry.key;
                } while ((entry = entry.next) != null);
            }
            ++n3;
        }
        return null;
    }

    public Object item(int n) {
        if (n < 0 || n >= this.count) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.table.length) {
            Entry entry = this.table[n3];
            if (entry != null) {
                do {
                    if (n2++ != n) continue;
                    return entry.value;
                } while ((entry = entry.next) != null);
            }
            ++n3;
        }
        return null;
    }

    public void clear() {
        this.table = new Entry[11];
        this.threshold = 8;
        this.count = 0;
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        this.threshold = (int)((float)this.table.length * 0.75f);
        int n = entryArray.length - 1;
        while (n >= 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
            --n;
        }
    }

    protected static class Entry {
        public int hash;
        public Object key;
        public Object value;
        public Entry next;

        public Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }
    }
}

