/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.URL;
import org.apache.batik.css.CSSDocumentHandler;
import org.apache.batik.css.CSSOMStyleDeclaration;
import org.apache.batik.css.CSSOMStyleSheet;
import org.apache.batik.css.DOMMediaList;
import org.apache.batik.css.svg.SVGValueFactoryMap;
import org.apache.batik.css.value.ValueFactoryMap;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMEvent;
import org.apache.batik.dom.util.CSSStyleDeclarationFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DOMImplementationCSS;
import org.w3c.dom.events.Event;
import org.w3c.dom.stylesheets.StyleSheet;

public class SVGDOMImplementation
extends AbstractDOMImplementation
implements DOMImplementationCSS,
CSSStyleDeclarationFactory,
StyleSheetFactory {
    public static final String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    protected static final DOMImplementation DOM_IMPLEMENTATION = new SVGDOMImplementation();
    protected ValueFactoryMap valueFactoryMap;

    public SVGDOMImplementation() {
        this.features.put("CSS", "2.0");
        this.features.put("StyleSheets", "2.0");
        this.features.put("SVG", "1.0");
        this.features.put("SVGEvents", "1.0");
        this.valueFactoryMap = new SVGValueFactoryMap(CSSDocumentHandler.createParser());
    }

    public static DOMImplementation getDOMImplementation() {
        return DOM_IMPLEMENTATION;
    }

    public DocumentType createDocumentType(String string, String string2, String string3) {
        throw new DOMException(9, "Doctype not supported");
    }

    public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        SVGOMDocument sVGOMDocument = new SVGOMDocument(documentType, this);
        sVGOMDocument.appendChild(sVGOMDocument.createElementNS(string, string2));
        return sVGOMDocument;
    }

    public CSSStyleSheet getUserAgentStyleSheet() {
        CSSStyleSheet cSSStyleSheet = null;
        URL uRL = this.getClass().getResource("resources/UserAgentStyleSheet.css");
        if (uRL != null) {
            String string = uRL.toString();
            cSSStyleSheet = this.createCSSStyleSheet("User Agent Style Sheet", "all");
            try {
                CSSDocumentHandler.parseStyleSheet((CSSOMStyleSheet)cSSStyleSheet, string);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        return cSSStyleSheet;
    }

    public CSSStyleDeclaration createCSSStyleDeclaration() {
        try {
            CSSOMStyleDeclaration cSSOMStyleDeclaration = new CSSOMStyleDeclaration();
            cSSOMStyleDeclaration.setValueFactoryMap(this.valueFactoryMap);
            return cSSOMStyleDeclaration;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public CSSStyleSheet createCSSStyleSheet(String string, String string2) {
        try {
            return new CSSOMStyleSheet(null, null, null, string, new DOMMediaList(string2), null, this.valueFactoryMap, CSSDocumentHandler.createParser());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public StyleSheet createStyleSheet(Node node, String string) {
        HashTable hashTable = new HashTable();
        hashTable.put("alternate", "no");
        hashTable.put("media", "all");
        DOMUtilities.parseStyleSheetPIData(string, hashTable);
        String string2 = (String)hashTable.get("type");
        if ("text/css".equals(string2)) {
            try {
                String string3 = (String)hashTable.get("title");
                String string4 = (String)hashTable.get("media");
                String string5 = (String)hashTable.get("href");
                SVGOMDocument sVGOMDocument = (SVGOMDocument)node.getOwnerDocument();
                URL uRL = new URL(sVGOMDocument.getURLObject(), string5);
                CSSOMStyleSheet cSSOMStyleSheet = new CSSOMStyleSheet(node, null, uRL.toString(), string3, new DOMMediaList(string4), null, this.valueFactoryMap, CSSDocumentHandler.createParser());
                CSSDocumentHandler.parseStyleSheet(cSSOMStyleSheet, uRL.toString());
                return cSSOMStyleSheet;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        return null;
    }

    static {
        EventSupport.registerEventFactory("SVGEvents", new EventSupport.EventFactory(){

            public Event createEvent() {
                return new SVGOMEvent();
            }
        });
    }
}

