/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.css.ElementWithID;
import org.apache.batik.css.ElementWithPseudoClass;
import org.apache.batik.css.HiddenChildElement;
import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGFitToViewBox;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class SVGOMElement
extends AbstractElement
implements SVGElement,
ElementWithID,
ElementWithPseudoClass,
HiddenChildElement,
SVGConstants {
    protected static final String ID_NAME = "id";
    protected boolean readonly;
    protected String prefix = "";
    protected Map liveAttributeValues;
    protected Element parentElement;

    protected SVGOMElement() {
    }

    protected SVGOMElement(String string, AbstractDocument abstractDocument) {
        this.ownerDocument = abstractDocument;
        this.setPrefix(string);
        this.initializeAttributes();
    }

    public NodeEventTarget getParentNodeEventTarget() {
        return (NodeEventTarget)((Object)HiddenChildElementSupport.getParentElement(this));
    }

    public Element getParentElement() {
        return this.parentElement;
    }

    public void setParentElement(Element element) {
        this.parentElement = element;
    }

    public String getId() {
        return this.getID();
    }

    public void setId(String string) {
        this.setAttribute(ID_NAME, string);
    }

    public SVGSVGElement getOwnerSVGElement() {
        Element element = HiddenChildElementSupport.getParentElement(this);
        while (element != null) {
            if (element instanceof SVGSVGElement) {
                return (SVGSVGElement)element;
            }
            element = HiddenChildElementSupport.getParentElement(element);
        }
        return null;
    }

    public SVGElement getViewportElement() {
        Node node = this.getParentNode();
        while (node != null) {
            if (node instanceof SVGFitToViewBox) {
                return (SVGElement)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public String getNodeName() {
        return this.prefix == null || this.prefix.equals("") ? this.getLocalName() : this.prefix + ":" + this.getLocalName();
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public void setPrefix(String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (string != null && !string.equals("") && !DOMUtilities.isValidName(string)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), string});
        }
        this.prefix = string;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public void setIDName(String string, String string2) {
        if (string != null || string2 == null || !string2.equals(ID_NAME)) {
            throw this.createDOMException((short)7, "id.name", new Object[]{string2});
        }
    }

    public String getID() {
        return this.getAttribute(ID_NAME);
    }

    public boolean matchPseudoClass(String string) {
        if (string.equals("first-child")) {
            Node node = this.getPreviousSibling();
            while (node != null && node.getNodeType() != 1) {
                node = node.getPreviousSibling();
            }
            return node == null;
        }
        return false;
    }

    protected NamedNodeMap createAttributes() {
        return new SVGNamedNodeHashMap();
    }

    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        return node;
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        return node;
    }

    protected boolean resetAttribute(String string, String string2) {
        Map map = this.getDefaultAttributeValues();
        if (map == null) {
            return false;
        }
        if ((map = (Map)map.get(string)) == null) {
            return false;
        }
        Object v = map.get(string2);
        if (v == null) {
            return false;
        }
        this.setDefaultAttributeValue(string, string2, v);
        return true;
    }

    protected Map getDefaultAttributeValues() {
        return null;
    }

    protected void initializeAttributes() {
        Map map = this.getDefaultAttributeValues();
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Map map2 = (Map)map.get(k);
            Iterator iterator2 = map2.keySet().iterator();
            while (iterator2.hasNext()) {
                Object k2 = iterator2.next();
                this.setDefaultAttributeValue(k, k2, map2.get(k2));
            }
        }
    }

    protected void setDefaultAttributeValue(Object object, Object object2, Object object3) {
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        ((SVGNamedNodeHashMap)this.attributes).setAttribute((String)object, (String)object2, (String)object3);
    }

    protected void putLiveAttributeValue(String string, String string2, LiveAttributeValue liveAttributeValue) {
        HashMap<String, WeakReference<LiveAttributeValue>> hashMap;
        if (this.liveAttributeValues == null) {
            this.liveAttributeValues = new HashMap(11);
        }
        if ((hashMap = (HashMap<String, WeakReference<LiveAttributeValue>>)this.liveAttributeValues.get(string)) == null) {
            hashMap = new HashMap<String, WeakReference<LiveAttributeValue>>(11);
            this.liveAttributeValues.put(string, hashMap);
        }
        hashMap.put(string2, new WeakReference<LiveAttributeValue>(liveAttributeValue));
    }

    protected class SVGNamedNodeHashMap
    extends AbstractElement.NamedNodeHashMap {
        public SVGNamedNodeHashMap() {
            super(SVGOMElement.this);
        }

        public Node setNamedItem(String string, String string2, Node node) throws DOMException {
            LiveAttributeValue liveAttributeValue;
            WeakReference weakReference;
            HashMap hashMap;
            Attr attr = (Attr)super.setNamedItem(string, string2, node);
            if (SVGOMElement.this.liveAttributeValues != null && (hashMap = (HashMap)SVGOMElement.this.liveAttributeValues.get(string)) != null && (weakReference = (WeakReference)hashMap.get(string2)) != null && (liveAttributeValue = (LiveAttributeValue)weakReference.get()) != null) {
                liveAttributeValue.valueChanged(attr, (Attr)node);
            }
            return attr;
        }

        public void setAttribute(String string, String string2, String string3) {
            Attr attr = SVGOMElement.this.getOwnerDocument().createAttributeNS(string, string2);
            attr.setValue(string3);
            ((AbstractAttr)attr).setSpecified(false);
            this.setNamedItemNS(attr);
        }

        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            if (SVGOMElement.this.isReadonly()) {
                throw SVGOMElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (string2 == null) {
                throw SVGOMElement.this.createDOMException((short)8, "attribute.missing", new Object[]{""});
            }
            AbstractAttr abstractAttr = (AbstractAttr)this.remove(string, string2);
            if (abstractAttr == null) {
                throw SVGOMElement.this.createDOMException((short)8, "attribute.missing", new Object[]{string2});
            }
            abstractAttr.setOwnerElement(null);
            if (!SVGOMElement.this.resetAttribute(string, string2)) {
                SVGOMElement.this.fireDOMAttrModifiedEvent(abstractAttr.getNodeName(), abstractAttr.getNodeValue(), "");
            }
            return abstractAttr;
        }
    }
}

