/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class MorphologyOp
implements BufferedImageOp,
RasterOp {
    private int radiusX;
    private int radiusY;
    private boolean doDilation;
    private final int rangeX;
    private final int rangeY;
    private final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private final ColorSpace lRGB = ColorSpace.getInstance(1004);

    public MorphologyOp(int n, int n2, boolean bl) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException(new String("The radius of X-axis or Y-axis should not be Zero or Negatives."));
        }
        this.radiusX = n;
        this.radiusY = n2;
        this.doDilation = bl;
        this.rangeX = 2 * n + 1;
        this.rangeY = 2 * n2 + 1;
    }

    public Rectangle2D getBounds2D(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
    }

    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    private void checkCompatible(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (!colorSpace.equals(this.sRGB) && !colorSpace.equals(this.lRGB)) {
            throw new IllegalArgumentException("Expected CS_sRGB or CS_LINEAR_RGB color model");
        }
        if (!(colorModel instanceof DirectColorModel)) {
            throw new IllegalArgumentException("colorModel should be an instance of DirectColorModel");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("colorModel's transferType should be DataBuffer.TYPE_INT");
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000) {
            throw new IllegalArgumentException("red mask in source should be 0x00ff0000");
        }
        if (directColorModel.getGreenMask() != 65280) {
            throw new IllegalArgumentException("green mask in source should be 0x0000ff00");
        }
        if (directColorModel.getBlueMask() != 255) {
            throw new IllegalArgumentException("blue mask in source should be 0x000000ff");
        }
        if (directColorModel.getAlphaMask() != -16777216) {
            throw new IllegalArgumentException("alpha mask in source should be 0xff000000");
        }
    }

    private boolean isCompatible(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace != ColorSpace.getInstance(1000) && colorSpace != ColorSpace.getInstance(1004)) {
            return false;
        }
        if (!(colorModel instanceof DirectColorModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000) {
            return false;
        }
        if (directColorModel.getGreenMask() != 65280) {
            return false;
        }
        if (directColorModel.getBlueMask() != 255) {
            return false;
        }
        return directColorModel.getAlphaMask() == -16777216;
    }

    private void checkCompatible(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalArgumentException("MorphologyOp only works with Rasters using SinglePixelPackedSampleModels");
        }
        int n = sampleModel.getNumBands();
        if (n != 4) {
            throw new IllegalArgumentException("MorphologyOp only words with Rasters having 4 bands");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("MorphologyOp only works with Rasters using DataBufferInt");
        }
        int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] % 8 != 0) {
                throw new IllegalArgumentException("MorphologyOp only works with Rasters using 8 bits per band : " + n2 + " : " + nArray[n2]);
            }
            ++n2;
        }
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return raster.createCompatibleWritableRaster();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        BufferedImage bufferedImage2 = null;
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.checkCompatible(colorModel, writableRaster.getSampleModel());
        bufferedImage2 = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        return bufferedImage2;
    }

    static final boolean isBetter(int n, int n2, boolean bl) {
        return bl ? n >= n2 : n <= n2;
    }

    private void specialProcessRow(Raster raster, WritableRaster writableRaster) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n4 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n5 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n6 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        if (n <= this.radiusX) {
            int n7 = 0;
            while (n7 < n2) {
                int n8 = n3 + n7 * n5;
                int n9 = n4 + n7 * n6;
                int n10 = nArray[n8++];
                int n11 = n10 >>> 24;
                int n12 = n10 & 0xFF0000;
                int n13 = n10 & 0xFF00;
                int n14 = n10 & 0xFF;
                int n15 = 1;
                while (n15 < n) {
                    int n16 = nArray[n8++];
                    int n17 = n16 >>> 24;
                    int n18 = n16 & 0xFF0000;
                    int n19 = n16 & 0xFF00;
                    int n20 = n16 & 0xFF;
                    if (MorphologyOp.isBetter(n17, n11, this.doDilation)) {
                        n11 = n17;
                    }
                    if (MorphologyOp.isBetter(n18, n12, this.doDilation)) {
                        n12 = n18;
                    }
                    if (MorphologyOp.isBetter(n19, n13, this.doDilation)) {
                        n13 = n19;
                    }
                    if (MorphologyOp.isBetter(n20, n14, this.doDilation)) {
                        n14 = n20;
                    }
                    ++n15;
                }
                int n21 = 0;
                while (n21 < n) {
                    nArray2[n9++] = n11 << 24 | n12 & 0xFF0000 | n13 & 0xFF00 | n14 & 0xFF;
                    ++n21;
                }
                ++n7;
            }
        } else {
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            int[] nArray5 = new int[n];
            int[] nArray6 = new int[n];
            int n22 = 0;
            while (n22 < n2) {
                int n23;
                int n24;
                int n25;
                int n26;
                int n27 = n3 + n22 * n5;
                int n28 = n4 + n22 * n6;
                int n29 = 0;
                int n30 = 0;
                int n31 = 0;
                int n32 = 0;
                int n33 = 0;
                int n34 = nArray[n27++];
                int n35 = n34 >>> 24;
                int n36 = n34 & 0xFF0000;
                int n37 = n34 & 0xFF00;
                int n38 = n34 & 0xFF;
                nArray3[0] = n35;
                nArray4[0] = n36;
                nArray5[0] = n37;
                nArray6[0] = n38;
                int n39 = 1;
                while (n39 <= this.radiusX) {
                    int n40 = nArray[n27++];
                    n26 = n40 >>> 24;
                    n25 = n40 & 0xFF0000;
                    n24 = n40 & 0xFF00;
                    n23 = n40 & 0xFF;
                    nArray3[n39] = n26;
                    nArray4[n39] = n25;
                    nArray5[n39] = n24;
                    nArray6[n39] = n23;
                    if (MorphologyOp.isBetter(n26, n35, this.doDilation)) {
                        n35 = n26;
                        n30 = n39;
                    }
                    if (MorphologyOp.isBetter(n25, n36, this.doDilation)) {
                        n36 = n25;
                        n31 = n39;
                    }
                    if (MorphologyOp.isBetter(n24, n37, this.doDilation)) {
                        n37 = n24;
                        n32 = n39;
                    }
                    if (MorphologyOp.isBetter(n23, n38, this.doDilation)) {
                        n38 = n23;
                        n33 = n39;
                    }
                    ++n39;
                }
                nArray2[n28++] = n35 << 24 | n36 & 0xFF0000 | n37 & 0xFF00 | n38 & 0xFF;
                int n41 = 1;
                while (n41 <= n - this.radiusX - 1) {
                    int n42 = nArray[n27++];
                    n35 = nArray3[n30];
                    nArray3[n41 + this.radiusX] = n26 = n42 >>> 24;
                    if (MorphologyOp.isBetter(n26, n35, this.doDilation)) {
                        n35 = n26;
                        n30 = n41 + this.radiusX;
                    }
                    n36 = nArray4[n31];
                    nArray4[n41 + this.radiusX] = n25 = n42 & 0xFF0000;
                    if (MorphologyOp.isBetter(n25, n36, this.doDilation)) {
                        n36 = n25;
                        n31 = n41 + this.radiusX;
                    }
                    n37 = nArray5[n32];
                    nArray5[n41 + this.radiusX] = n24 = n42 & 0xFF00;
                    if (MorphologyOp.isBetter(n24, n37, this.doDilation)) {
                        n37 = n24;
                        n32 = n41 + this.radiusX;
                    }
                    n38 = nArray6[n33];
                    nArray6[n41 + this.radiusX] = n23 = n42 & 0xFF;
                    if (MorphologyOp.isBetter(n23, n38, this.doDilation)) {
                        n38 = n23;
                        n33 = n41 + this.radiusX;
                    }
                    nArray2[n28++] = n35 << 24 | n36 & 0xFF0000 | n37 & 0xFF00 | n38 & 0xFF;
                    ++n41;
                }
                int n43 = n - this.radiusX;
                while (n43 <= this.radiusX) {
                    nArray2[n28] = nArray2[n28 - 1];
                    ++n28;
                    ++n43;
                }
                int n44 = this.radiusX + 1;
                while (n44 < n) {
                    int n45;
                    if (n30 == n29) {
                        n35 = nArray3[n29 + 1];
                        n30 = n29 + 1;
                        n45 = n29 + 2;
                        while (n45 < n) {
                            n26 = nArray3[n45];
                            if (MorphologyOp.isBetter(n26, n35, this.doDilation)) {
                                n35 = n26;
                                n30 = n45;
                            }
                            ++n45;
                        }
                    } else {
                        n35 = nArray3[n30];
                    }
                    if (n31 == n29) {
                        n36 = nArray4[n29 + 1];
                        n31 = n29 + 1;
                        n45 = n29 + 2;
                        while (n45 < n) {
                            n25 = nArray4[n45];
                            if (MorphologyOp.isBetter(n25, n36, this.doDilation)) {
                                n36 = n25;
                                n31 = n45;
                            }
                            ++n45;
                        }
                    } else {
                        n36 = nArray4[n31];
                    }
                    if (n32 == n29) {
                        n37 = nArray5[n29 + 1];
                        n32 = n29 + 1;
                        n45 = n29 + 2;
                        while (n45 < n) {
                            n24 = nArray5[n45];
                            if (MorphologyOp.isBetter(n24, n37, this.doDilation)) {
                                n37 = n24;
                                n32 = n45;
                            }
                            ++n45;
                        }
                    } else {
                        n37 = nArray5[n32];
                    }
                    if (n33 == n29) {
                        n38 = nArray6[n29 + 1];
                        n33 = n29 + 1;
                        n45 = n29 + 2;
                        while (n45 < n) {
                            n23 = nArray6[n45];
                            if (MorphologyOp.isBetter(n23, n38, this.doDilation)) {
                                n38 = n23;
                                n33 = n45;
                            }
                            ++n45;
                        }
                    } else {
                        n38 = nArray6[n33];
                    }
                    ++n29;
                    nArray2[n28++] = n35 << 24 | n36 & 0xFF0000 | n37 & 0xFF00 | n38 & 0xFF;
                    ++n44;
                }
                ++n22;
            }
        }
    }

    private void specialProcessColumn(Raster raster, WritableRaster writableRaster) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset();
        int n4 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int[] nArray = dataBufferInt.getBankData()[0];
        if (n2 <= this.radiusY) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = n3 + n5;
                int n7 = n3 + n5;
                int n8 = nArray[n7];
                n7 += n4;
                int n9 = n8 >>> 24;
                int n10 = n8 & 0xFF0000;
                int n11 = n8 & 0xFF00;
                int n12 = n8 & 0xFF;
                int n13 = 1;
                while (n13 < n2) {
                    int n14 = nArray[n7];
                    n7 += n4;
                    int n15 = n14 >>> 24;
                    int n16 = n14 & 0xFF0000;
                    int n17 = n14 & 0xFF00;
                    int n18 = n14 & 0xFF;
                    if (MorphologyOp.isBetter(n15, n9, this.doDilation)) {
                        n9 = n15;
                    }
                    if (MorphologyOp.isBetter(n16, n10, this.doDilation)) {
                        n10 = n16;
                    }
                    if (MorphologyOp.isBetter(n17, n11, this.doDilation)) {
                        n11 = n17;
                    }
                    if (MorphologyOp.isBetter(n18, n12, this.doDilation)) {
                        n12 = n18;
                    }
                    ++n13;
                }
                int n19 = 0;
                while (n19 < n2) {
                    nArray[n6] = n9 << 24 | n10 & 0xFF0000 | n11 & 0xFF00 | n12 & 0xFF;
                    n6 += n4;
                    ++n19;
                }
                ++n5;
            }
        } else {
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            int[] nArray5 = new int[n2];
            int n20 = 0;
            while (n20 < n) {
                int n21;
                int n22;
                int n23;
                int n24;
                int n25 = n3 + n20;
                int n26 = n3 + n20;
                int n27 = 0;
                int n28 = 0;
                int n29 = 0;
                int n30 = 0;
                int n31 = 0;
                int n32 = nArray[n26];
                n26 += n4;
                int n33 = n32 >>> 24;
                int n34 = n32 & 0xFF0000;
                int n35 = n32 & 0xFF00;
                int n36 = n32 & 0xFF;
                nArray2[0] = n33;
                nArray3[0] = n34;
                nArray4[0] = n35;
                nArray5[0] = n36;
                int n37 = 1;
                while (n37 <= this.radiusY) {
                    int n38 = nArray[n26];
                    n26 += n4;
                    n24 = n38 >>> 24;
                    n23 = n38 & 0xFF0000;
                    n22 = n38 & 0xFF00;
                    n21 = n38 & 0xFF;
                    nArray2[n37] = n24;
                    nArray3[n37] = n23;
                    nArray4[n37] = n22;
                    nArray5[n37] = n21;
                    if (MorphologyOp.isBetter(n24, n33, this.doDilation)) {
                        n33 = n24;
                        n28 = n37;
                    }
                    if (MorphologyOp.isBetter(n23, n34, this.doDilation)) {
                        n34 = n23;
                        n29 = n37;
                    }
                    if (MorphologyOp.isBetter(n22, n35, this.doDilation)) {
                        n35 = n22;
                        n30 = n37;
                    }
                    if (MorphologyOp.isBetter(n21, n36, this.doDilation)) {
                        n36 = n21;
                        n31 = n37;
                    }
                    ++n37;
                }
                nArray[n25] = n33 << 24 | n34 & 0xFF0000 | n35 & 0xFF00 | n36 & 0xFF;
                n25 += n4;
                int n39 = 1;
                while (n39 <= n2 - this.radiusY - 1) {
                    int n40 = nArray[n26];
                    n26 += n4;
                    n33 = nArray2[n28];
                    nArray2[n39 + this.radiusY] = n24 = n40 >>> 24;
                    if (MorphologyOp.isBetter(n24, n33, this.doDilation)) {
                        n33 = n24;
                        n28 = n39 + this.radiusY;
                    }
                    n34 = nArray3[n29];
                    nArray3[n39 + this.radiusY] = n23 = n40 & 0xFF0000;
                    if (MorphologyOp.isBetter(n23, n34, this.doDilation)) {
                        n34 = n23;
                        n29 = n39 + this.radiusY;
                    }
                    n35 = nArray4[n30];
                    nArray4[n39 + this.radiusY] = n22 = n40 & 0xFF00;
                    if (MorphologyOp.isBetter(n22, n35, this.doDilation)) {
                        n35 = n22;
                        n30 = n39 + this.radiusY;
                    }
                    n36 = nArray5[n31];
                    nArray5[n39 + this.radiusY] = n21 = n40 & 0xFF;
                    if (MorphologyOp.isBetter(n21, n36, this.doDilation)) {
                        n36 = n21;
                        n31 = n39 + this.radiusY;
                    }
                    nArray[n25] = n33 << 24 | n34 & 0xFF0000 | n35 & 0xFF00 | n36 & 0xFF;
                    n25 += n4;
                    ++n39;
                }
                int n41 = n2 - this.radiusY;
                while (n41 <= this.radiusY) {
                    nArray[n25] = nArray[n25 - n4];
                    n25 += n4;
                    ++n41;
                }
                int n42 = this.radiusY + 1;
                while (n42 < n2) {
                    int n43;
                    if (n28 == n27) {
                        n33 = nArray2[n27 + 1];
                        n28 = n27 + 1;
                        n43 = n27 + 2;
                        while (n43 < n2) {
                            n24 = nArray2[n43];
                            if (MorphologyOp.isBetter(n24, n33, this.doDilation)) {
                                n33 = n24;
                                n28 = n43;
                            }
                            ++n43;
                        }
                    } else {
                        n33 = nArray2[n28];
                    }
                    if (n29 == n27) {
                        n34 = nArray3[n27 + 1];
                        n29 = n27 + 1;
                        n43 = n27 + 2;
                        while (n43 < n2) {
                            n23 = nArray3[n43];
                            if (MorphologyOp.isBetter(n23, n34, this.doDilation)) {
                                n34 = n23;
                                n29 = n43;
                            }
                            ++n43;
                        }
                    } else {
                        n34 = nArray3[n29];
                    }
                    if (n30 == n27) {
                        n35 = nArray4[n27 + 1];
                        n30 = n27 + 1;
                        n43 = n27 + 2;
                        while (n43 < n2) {
                            n22 = nArray4[n43];
                            if (MorphologyOp.isBetter(n22, n35, this.doDilation)) {
                                n35 = n22;
                                n30 = n43;
                            }
                            ++n43;
                        }
                    } else {
                        n35 = nArray4[n30];
                    }
                    if (n31 == n27) {
                        n36 = nArray5[n27 + 1];
                        n31 = n27 + 1;
                        n43 = n27 + 2;
                        while (n43 < n2) {
                            n21 = nArray5[n43];
                            if (MorphologyOp.isBetter(n21, n36, this.doDilation)) {
                                n36 = n21;
                                n31 = n43;
                            }
                            ++n43;
                        }
                    } else {
                        n36 = nArray5[n31];
                    }
                    ++n27;
                    nArray[n25] = n33 << 24 | n34 & 0xFF0000 | n35 & 0xFF00 | n36 & 0xFF;
                    n25 += n4;
                    ++n42;
                }
                ++n20;
            }
        }
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        if (writableRaster != null) {
            this.checkCompatible(writableRaster.getSampleModel());
        } else {
            if (raster == null) {
                throw new IllegalArgumentException("src should not be null when dest is null");
            }
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        int n28 = raster.getWidth();
        int n29 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n30 = dataBufferInt.getOffset();
        int n31 = dataBufferInt2.getOffset();
        int n32 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n33 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        if (n28 <= 2 * this.radiusX) {
            this.specialProcessRow(raster, writableRaster);
        } else {
            nArray4 = new int[this.rangeX];
            nArray3 = new int[this.rangeX];
            nArray2 = new int[this.rangeX];
            nArray = new int[this.rangeX];
            n27 = 0;
            while (n27 < n29) {
                int n34 = n30 + n27 * n32;
                n26 = n31 + n27 * n33;
                n25 = 0;
                n24 = 0;
                n23 = 0;
                n22 = 0;
                n21 = 0;
                n20 = nArray5[n34++];
                n19 = n20 >>> 24;
                n18 = n20 & 0xFF0000;
                n17 = n20 & 0xFF00;
                n16 = n20 & 0xFF;
                nArray4[0] = n19;
                nArray3[0] = n18;
                nArray2[0] = n17;
                nArray[0] = n16;
                n15 = 1;
                while (n15 <= this.radiusX) {
                    n14 = nArray5[n34++];
                    n13 = n14 >>> 24;
                    n12 = n14 & 0xFF0000;
                    n11 = n14 & 0xFF00;
                    n10 = n14 & 0xFF;
                    nArray4[n15] = n13;
                    nArray3[n15] = n12;
                    nArray2[n15] = n11;
                    nArray[n15] = n10;
                    if (MorphologyOp.isBetter(n13, n19, this.doDilation)) {
                        n19 = n13;
                        n24 = n15;
                    }
                    if (MorphologyOp.isBetter(n12, n18, this.doDilation)) {
                        n18 = n12;
                        n23 = n15;
                    }
                    if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                        n17 = n11;
                        n22 = n15;
                    }
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n15;
                    }
                    ++n15;
                }
                nArray6[n26++] = n19 << 24 | n18 & 0xFF0000 | n17 & 0xFF00 | n16 & 0xFF;
                n9 = 1;
                while (n9 <= this.radiusX) {
                    n8 = nArray5[n34++];
                    n19 = nArray4[n24];
                    nArray4[n9 + this.radiusX] = n13 = n8 >>> 24;
                    if (MorphologyOp.isBetter(n13, n19, this.doDilation)) {
                        n19 = n13;
                        n24 = n9 + this.radiusX;
                    }
                    n18 = nArray3[n23];
                    nArray3[n9 + this.radiusX] = n12 = n8 & 0xFF0000;
                    if (MorphologyOp.isBetter(n12, n18, this.doDilation)) {
                        n18 = n12;
                        n23 = n9 + this.radiusX;
                    }
                    n17 = nArray2[n22];
                    nArray2[n9 + this.radiusX] = n11 = n8 & 0xFF00;
                    if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                        n17 = n11;
                        n22 = n9 + this.radiusX;
                    }
                    n16 = nArray[n21];
                    nArray[n9 + this.radiusX] = n10 = n8 & 0xFF;
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n9 + this.radiusX;
                    }
                    nArray6[n26++] = n19 << 24 | n18 & 0xFF0000 | n17 & 0xFF00 | n16 & 0xFF;
                    ++n9;
                }
                n7 = this.radiusX + 1;
                while (n7 <= n28 - 1 - this.radiusX) {
                    n8 = nArray5[n34++];
                    n13 = n8 >>> 24;
                    n12 = n8 & 0xFF0000;
                    n11 = n8 & 0xFF00;
                    n10 = n8 & 0xFF;
                    nArray4[n25] = n13;
                    nArray3[n25] = n12;
                    nArray2[n25] = n11;
                    nArray[n25] = n10;
                    if (n24 == n25) {
                        n19 = nArray4[0];
                        n24 = 0;
                        n6 = 1;
                        while (n6 < this.rangeX) {
                            n13 = nArray4[n6];
                            if (MorphologyOp.isBetter(n13, n19, this.doDilation)) {
                                n19 = n13;
                                n24 = n6;
                            }
                            ++n6;
                        }
                    } else {
                        n19 = nArray4[n24];
                        if (MorphologyOp.isBetter(n13, n19, this.doDilation)) {
                            n19 = n13;
                            n24 = n25;
                        }
                    }
                    if (n23 == n25) {
                        n18 = nArray3[0];
                        n23 = 0;
                        n6 = 1;
                        while (n6 < this.rangeX) {
                            n12 = nArray3[n6];
                            if (MorphologyOp.isBetter(n12, n18, this.doDilation)) {
                                n18 = n12;
                                n23 = n6;
                            }
                            ++n6;
                        }
                    } else {
                        n18 = nArray3[n23];
                        if (MorphologyOp.isBetter(n12, n18, this.doDilation)) {
                            n18 = n12;
                            n23 = n25;
                        }
                    }
                    if (n22 == n25) {
                        n17 = nArray2[0];
                        n22 = 0;
                        n6 = 1;
                        while (n6 < this.rangeX) {
                            n11 = nArray2[n6];
                            if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                                n17 = n11;
                                n22 = n6;
                            }
                            ++n6;
                        }
                    } else {
                        n17 = nArray2[n22];
                        if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                            n17 = n11;
                            n22 = n25;
                        }
                    }
                    if (n21 == n25) {
                        n16 = nArray[0];
                        n21 = 0;
                        n6 = 1;
                        while (n6 < this.rangeX) {
                            n10 = nArray[n6];
                            if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                                n16 = n10;
                                n21 = n6;
                            }
                            ++n6;
                        }
                    } else {
                        n16 = nArray[n21];
                        if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                            n16 = n10;
                            n21 = n25;
                        }
                    }
                    nArray6[n26++] = n19 << 24 | n18 & 0xFF0000 | n17 & 0xFF00 | n16 & 0xFF;
                    n25 = (n25 + 1) % this.rangeX;
                    ++n7;
                }
                n5 = n25 == 0 ? this.rangeX - 1 : n25 - 1;
                n4 = this.rangeX - 1;
                n3 = n28 - this.radiusX;
                while (n3 < n28) {
                    n6 = (n25 + 1) % this.rangeX;
                    if (n24 == n25) {
                        n19 = nArray4[n5];
                        n2 = n6;
                        n = 1;
                        while (n < n4) {
                            n13 = nArray4[n2];
                            if (MorphologyOp.isBetter(n13, n19, this.doDilation)) {
                                n19 = n13;
                                n24 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeX;
                            ++n;
                        }
                    }
                    if (n23 == n25) {
                        n18 = nArray3[n5];
                        n2 = n6;
                        n = 1;
                        while (n < n4) {
                            n12 = nArray3[n2];
                            if (MorphologyOp.isBetter(n12, n18, this.doDilation)) {
                                n18 = n12;
                                n23 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeX;
                            ++n;
                        }
                    }
                    if (n22 == n25) {
                        n17 = nArray2[n5];
                        n2 = n6;
                        n = 1;
                        while (n < n4) {
                            n11 = nArray2[n2];
                            if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                                n17 = n11;
                                n22 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeX;
                            ++n;
                        }
                    }
                    if (n21 == n25) {
                        n16 = nArray[n5];
                        n2 = n6;
                        n = 1;
                        while (n < n4) {
                            n10 = nArray[n2];
                            if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                                n16 = n10;
                                n21 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeX;
                            ++n;
                        }
                    }
                    nArray6[n26++] = n19 << 24 | n18 & 0xFF0000 | n17 & 0xFF00 | n16 & 0xFF;
                    n25 = (n25 + 1) % this.rangeX;
                    --n4;
                    ++n3;
                }
                ++n27;
            }
        }
        if (n29 <= 2 * this.radiusY) {
            this.specialProcessColumn(raster, writableRaster);
        } else {
            nArray4 = new int[this.rangeY];
            nArray3 = new int[this.rangeY];
            nArray2 = new int[this.rangeY];
            nArray = new int[this.rangeY];
            n27 = 0;
            while (n27 < n28) {
                n26 = n31 + n27;
                int n35 = n31 + n27;
                n25 = 0;
                n24 = 0;
                n23 = 0;
                n22 = 0;
                n21 = 0;
                n20 = nArray6[n35];
                n35 += n33;
                n19 = n20 >>> 24;
                n18 = n20 & 0xFF0000;
                n17 = n20 & 0xFF00;
                n16 = n20 & 0xFF;
                nArray4[0] = n19;
                nArray3[0] = n18;
                nArray2[0] = n17;
                nArray[0] = n16;
                n15 = 1;
                while (n15 <= this.radiusY) {
                    n14 = nArray6[n35];
                    n35 += n33;
                    n13 = n14 >>> 24;
                    n12 = n14 & 0xFF0000;
                    n11 = n14 & 0xFF00;
                    n10 = n14 & 0xFF;
                    nArray4[n15] = n13;
                    nArray3[n15] = n12;
                    nArray2[n15] = n11;
                    nArray[n15] = n10;
                    if (MorphologyOp.isBetter(n13, n19, this.doDilation)) {
                        n19 = n13;
                        n24 = n15;
                    }
                    if (MorphologyOp.isBetter(n12, n18, this.doDilation)) {
                        n18 = n12;
                        n23 = n15;
                    }
                    if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                        n17 = n11;
                        n22 = n15;
                    }
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n15;
                    }
                    ++n15;
                }
                nArray6[n26] = n19 << 24 | n18 & 0xFF0000 | n17 & 0xFF00 | n16 & 0xFF;
                n26 += n33;
                n9 = 1;
                while (n9 <= this.radiusY) {
                    n7 = n9 + this.radiusY;
                    n8 = nArray6[n35];
                    n35 += n33;
                    n19 = nArray4[n24];
                    nArray4[n7] = n13 = n8 >>> 24;
                    if (MorphologyOp.isBetter(n13, n19, this.doDilation)) {
                        n19 = n13;
                        n24 = n7;
                    }
                    n18 = nArray3[n23];
                    nArray3[n7] = n12 = n8 & 0xFF0000;
                    if (MorphologyOp.isBetter(n12, n18, this.doDilation)) {
                        n18 = n12;
                        n23 = n7;
                    }
                    n17 = nArray2[n22];
                    nArray2[n7] = n11 = n8 & 0xFF00;
                    if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                        n17 = n11;
                        n22 = n7;
                    }
                    n16 = nArray[n21];
                    nArray[n7] = n10 = n8 & 0xFF;
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n7;
                    }
                    nArray6[n26] = n19 << 24 | n18 & 0xFF0000 | n17 & 0xFF00 | n16 & 0xFF;
                    n26 += n33;
                    ++n9;
                }
                n7 = this.radiusY + 1;
                while (n7 <= n29 - 1 - this.radiusY) {
                    n8 = nArray6[n35];
                    n35 += n33;
                    n13 = n8 >>> 24;
                    n12 = n8 & 0xFF0000;
                    n11 = n8 & 0xFF00;
                    n10 = n8 & 0xFF;
                    nArray4[n25] = n13;
                    nArray3[n25] = n12;
                    nArray2[n25] = n11;
                    nArray[n25] = n10;
                    if (n24 == n25) {
                        n19 = nArray4[0];
                        n24 = 0;
                        n6 = 1;
                        while (n6 <= 2 * this.radiusY) {
                            n13 = nArray4[n6];
                            if (MorphologyOp.isBetter(n13, n19, this.doDilation)) {
                                n19 = n13;
                                n24 = n6;
                            }
                            ++n6;
                        }
                    } else {
                        n19 = nArray4[n24];
                        if (MorphologyOp.isBetter(n13, n19, this.doDilation)) {
                            n19 = n13;
                            n24 = n25;
                        }
                    }
                    if (n23 == n25) {
                        n18 = nArray3[0];
                        n23 = 0;
                        n6 = 1;
                        while (n6 <= 2 * this.radiusY) {
                            n12 = nArray3[n6];
                            if (MorphologyOp.isBetter(n12, n18, this.doDilation)) {
                                n18 = n12;
                                n23 = n6;
                            }
                            ++n6;
                        }
                    } else {
                        n18 = nArray3[n23];
                        if (MorphologyOp.isBetter(n12, n18, this.doDilation)) {
                            n18 = n12;
                            n23 = n25;
                        }
                    }
                    if (n22 == n25) {
                        n17 = nArray2[0];
                        n22 = 0;
                        n6 = 1;
                        while (n6 <= 2 * this.radiusY) {
                            n11 = nArray2[n6];
                            if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                                n17 = n11;
                                n22 = n6;
                            }
                            ++n6;
                        }
                    } else {
                        n17 = nArray2[n22];
                        if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                            n17 = n11;
                            n22 = n25;
                        }
                    }
                    if (n21 == n25) {
                        n16 = nArray[0];
                        n21 = 0;
                        n6 = 1;
                        while (n6 <= 2 * this.radiusY) {
                            n10 = nArray[n6];
                            if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                                n16 = n10;
                                n21 = n6;
                            }
                            ++n6;
                        }
                    } else {
                        n16 = nArray[n21];
                        if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                            n16 = n10;
                            n21 = n25;
                        }
                    }
                    nArray6[n26] = n19 << 24 | n18 & 0xFF0000 | n17 & 0xFF00 | n16 & 0xFF;
                    n26 += n33;
                    n25 = (n25 + 1) % this.rangeY;
                    ++n7;
                }
                n5 = n25 == 0 ? 2 * this.radiusY : n25 - 1;
                n4 = this.rangeY - 1;
                n3 = n29 - this.radiusY;
                while (n3 < n29 - 1) {
                    n6 = (n25 + 1) % this.rangeY;
                    if (n24 == n25) {
                        n19 = nArray4[n5];
                        n2 = n6;
                        n = 1;
                        while (n < n4) {
                            n13 = nArray4[n2];
                            if (MorphologyOp.isBetter(n13, n19, this.doDilation)) {
                                n19 = n13;
                                n24 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeY;
                            ++n;
                        }
                    }
                    if (n23 == n25) {
                        n18 = nArray3[n5];
                        n2 = n6;
                        n = 1;
                        while (n < n4) {
                            n12 = nArray3[n2];
                            if (MorphologyOp.isBetter(n12, n18, this.doDilation)) {
                                n18 = n12;
                                n23 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeY;
                            ++n;
                        }
                    }
                    if (n22 == n25) {
                        n17 = nArray2[n5];
                        n2 = n6;
                        n = 1;
                        while (n < n4) {
                            n11 = nArray2[n2];
                            if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                                n17 = n11;
                                n22 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeY;
                            ++n;
                        }
                    }
                    if (n21 == n25) {
                        n16 = nArray[n5];
                        n2 = n6;
                        n = 1;
                        while (n < n4) {
                            n10 = nArray[n2];
                            if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                                n16 = n10;
                                n21 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeY;
                            ++n;
                        }
                    }
                    nArray6[n26] = n19 << 24 | n18 & 0xFF0000 | n17 & 0xFF00 | n16 & 0xFF;
                    n26 += n33;
                    n25 = (n25 + 1) % this.rangeY;
                    --n4;
                    ++n3;
                }
                ++n27;
            }
        }
        return writableRaster;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ColorModel colorModel;
        ColorModel colorModel2;
        if (bufferedImage == null) {
            throw new NullPointerException("Source image should not be null");
        }
        BufferedImage bufferedImage3 = bufferedImage;
        BufferedImage bufferedImage4 = bufferedImage2;
        if (!this.isCompatible(bufferedImage.getColorModel(), bufferedImage.getSampleModel())) {
            bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
            GraphicsUtil.copyData(bufferedImage3, bufferedImage);
        } else if (!bufferedImage.isAlphaPremultiplied()) {
            colorModel2 = bufferedImage.getColorModel();
            colorModel = GraphicsUtil.coerceColorModel(colorModel2, true);
            bufferedImage = new BufferedImage(colorModel, bufferedImage.getRaster(), true, null);
            GraphicsUtil.copyData(bufferedImage3, bufferedImage);
        }
        if (bufferedImage2 == null) {
            bufferedImage4 = bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else if (!this.isCompatible(bufferedImage2.getColorModel(), bufferedImage2.getSampleModel())) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else if (!bufferedImage2.isAlphaPremultiplied()) {
            colorModel2 = bufferedImage2.getColorModel();
            colorModel = GraphicsUtil.coerceColorModel(colorModel2, true);
            bufferedImage2 = new BufferedImage(colorModel, bufferedImage4.getRaster(), true, null);
        }
        this.filter(bufferedImage.getRaster(), bufferedImage2.getRaster());
        if (bufferedImage.getRaster() == bufferedImage3.getRaster() && bufferedImage.isAlphaPremultiplied() != bufferedImage3.isAlphaPremultiplied()) {
            GraphicsUtil.copyData(bufferedImage, bufferedImage3);
        }
        if (bufferedImage2.getRaster() != bufferedImage4.getRaster() || bufferedImage2.isAlphaPremultiplied() != bufferedImage4.isAlphaPremultiplied()) {
            GraphicsUtil.copyData(bufferedImage2, bufferedImage4);
        }
        return bufferedImage4;
    }
}

