/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.PaintContext;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.TileRable8Bit;

public class PatternPaintContext
implements PaintContext {
    private ColorModel rasterCM;
    private WritableRaster raster;
    private RenderedImage tiled;

    public PatternPaintContext(ColorModel colorModel, AffineTransform affineTransform, RenderingHints renderingHints, Filter filter, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        if (affineTransform == null) {
            throw new IllegalArgumentException();
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        TileRable8Bit tileRable8Bit = new TileRable8Bit(filter, rectangle2D2, rectangle2D, bl);
        RenderContext renderContext = new RenderContext(affineTransform, rectangle2D2, renderingHints);
        this.tiled = tileRable8Bit.createRendering(renderContext);
        if (this.tiled != null) {
            this.rasterCM = this.tiled.getColorModel();
            ColorSpace colorSpace = colorModel.getColorSpace();
            if (colorSpace != this.rasterCM.getColorSpace()) {
                if (colorSpace == ColorSpace.getInstance(1000)) {
                    this.tiled = GraphicsUtil.convertTosRGB(GraphicsUtil.wrap(this.tiled));
                } else if (colorSpace == ColorSpace.getInstance(1004)) {
                    this.tiled = GraphicsUtil.convertToLsRGB(GraphicsUtil.wrap(this.tiled));
                }
            }
            this.rasterCM = this.tiled.getColorModel();
            if (this.rasterCM.hasAlpha()) {
                if (colorModel.hasAlpha()) {
                    if (this.rasterCM.isAlphaPremultiplied() != colorModel.isAlphaPremultiplied()) {
                        this.rasterCM = GraphicsUtil.coerceColorModel(this.rasterCM, colorModel.isAlphaPremultiplied());
                    }
                } else {
                    this.rasterCM = GraphicsUtil.coerceColorModel(this.rasterCM, false);
                }
            }
        } else {
            this.rasterCM = ColorModel.getRGBdefault();
            WritableRaster writableRaster = this.rasterCM.createCompatibleWritableRaster(32, 32);
            this.tiled = new BufferedImage(this.rasterCM, writableRaster, false, null);
        }
    }

    public void dispose() {
        this.raster = null;
    }

    public ColorModel getColorModel() {
        return this.rasterCM;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.raster == null || this.raster.getWidth() < n3 || this.raster.getHeight() < n4) {
            this.raster = this.rasterCM.createCompatibleWritableRaster(n3, n4);
        }
        WritableRaster writableRaster = this.raster.createWritableChild(0, 0, n3, n4, n, n2, null);
        this.tiled.copyData(writableRaster);
        GraphicsUtil.coerceData(writableRaster, this.tiled.getColorModel(), this.rasterCM.isAlphaPremultiplied());
        return writableRaster;
    }
}

