/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;

public class RasterImageNode
extends AbstractGraphicsNode {
    protected Filter image;
    protected Rectangle2D imageBounds;

    public void setImage(Filter filter) {
        this.invalidateGeometryCache();
        this.image = filter;
    }

    public Filter getImage() {
        return this.image;
    }

    public void setImageBounds(Rectangle2D rectangle2D) {
        this.invalidateGeometryCache();
        this.imageBounds = rectangle2D;
    }

    public Rectangle2D getImageBounds() {
        return (Rectangle2D)this.imageBounds.clone();
    }

    public void primitivePaint(Graphics2D graphics2D, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        if (this.image == null || this.imageBounds.getWidth() == 0.0 || this.imageBounds.getHeight() == 0.0) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
        float f = this.image.getMinX();
        float f2 = this.image.getMinY();
        float f3 = (float)(this.imageBounds.getWidth() / (double)this.image.getWidth());
        float f4 = (float)(this.imageBounds.getHeight() / (double)this.image.getHeight());
        float f5 = (float)this.imageBounds.getX();
        float f6 = (float)this.imageBounds.getY();
        affineTransform2.concatenate(AffineTransform.getTranslateInstance(f5, f6));
        affineTransform2.concatenate(AffineTransform.getScaleInstance(f3, f4));
        affineTransform2.concatenate(AffineTransform.getTranslateInstance(-f, -f2));
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.concatenate(AffineTransform.getTranslateInstance(f, f2));
        affineTransform3.concatenate(AffineTransform.getScaleInstance(1.0f / f3, 1.0f / f4));
        affineTransform3.concatenate(AffineTransform.getTranslateInstance(-f5, -f6));
        Shape shape = graphics2D.getClip();
        if (shape == null) {
            shape = this.getImageBounds();
        }
        Shape shape2 = affineTransform3.createTransformedShape(shape);
        graphicsNodeRenderContext.setTransform(affineTransform2);
        graphicsNodeRenderContext.setAreaOfInterest(shape2);
        RenderedImage renderedImage = this.image.createRendering(graphicsNodeRenderContext);
        if (renderedImage != null) {
            graphics2D.setTransform(GraphicsNode.IDENTITY);
            graphics2D.drawRenderedImage(renderedImage, GraphicsNode.IDENTITY);
        }
        graphics2D.setTransform(affineTransform);
        graphicsNodeRenderContext.setTransform(affineTransform);
        graphicsNodeRenderContext.setAreaOfInterest(graphics2D.getClip());
    }

    public Rectangle2D getPrimitiveBounds(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        return (Rectangle2D)this.imageBounds.clone();
    }

    public Rectangle2D getGeometryBounds(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        return (Rectangle2D)this.imageBounds.clone();
    }

    public Shape getOutline(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        return (Rectangle2D)this.imageBounds.clone();
    }
}

