/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextSpanLayout;

public class GlyphLayout
implements TextSpanLayout {
    private GlyphVector gv;
    private Font font;
    private LineMetrics metrics;
    private AttributedCharacterIterator aci;
    private CharacterIterator ci;
    private FontRenderContext frc;
    private AffineTransform transform;
    private Point2D advance;
    private Point2D offset;
    private Point2D prevCharPosition;
    protected Shape[] glyphLogicalBounds;
    protected Point2D[] glyphPositions;

    public GlyphLayout(AttributedCharacterIterator attributedCharacterIterator, Point2D point2D, FontRenderContext fontRenderContext) {
        this.aci = (AttributedCharacterIterator)attributedCharacterIterator.clone();
        this.frc = fontRenderContext;
        this.font = this.getFont(attributedCharacterIterator);
        this.metrics = this.font.getLineMetrics(this.aci, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), fontRenderContext);
        this.ci = new ReorderedCharacterIterator(this.aci);
        this.gv = this.font.createGlyphVector(fontRenderContext, this.ci);
        this.gv.performDefaultLayout();
        this.glyphPositions = new Point2D.Float[this.gv.getNumGlyphs()];
        this.offset = point2D;
        this.transform = null;
        this.doExplicitGlyphLayout(false);
        this.adjustTextSpacing();
        this.computeGlyphLogicalBounds();
    }

    public void draw(Graphics2D graphics2D) {
        if (this.transform != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(this.transform);
            graphics2D.drawGlyphVector(this.gv, 0.0f, 0.0f);
            graphics2D.setTransform(affineTransform);
        } else {
            graphics2D.drawGlyphVector(this.gv, 0.0f, 0.0f);
        }
    }

    public Shape getOutline() {
        Shape shape = this.gv.getOutline(0.0f, 0.0f);
        if (this.transform != null) {
            shape = this.transform.createTransformedShape(shape);
        }
        return shape;
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setOffset(Point2D point2D) {
        this.offset = point2D;
        this.gv.performDefaultLayout();
        this.doExplicitGlyphLayout(true);
        this.adjustTextSpacing();
        this.computeGlyphLogicalBounds();
    }

    public Shape getDecorationOutline(int n) {
        Shape shape = new GeneralPath();
        if ((n & 1) != 0) {
            shape.append(this.getUnderlineShape(), false);
        }
        if ((n & 2) != 0) {
            shape.append(this.getStrikethroughShape(), false);
        }
        if ((n & 4) != 0) {
            shape.append(this.getOverlineShape(), false);
        }
        if (this.transform != null) {
            shape = this.transform.createTransformedShape(shape);
        }
        return shape;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = this.gv.getVisualBounds();
        if (this.transform != null) {
            rectangle2D = this.transform.createTransformedShape(rectangle2D).getBounds2D();
        }
        return rectangle2D;
    }

    public Rectangle2D getDecoratedBounds() {
        return this.getBounds().createUnion(this.getDecorationOutline(7).getBounds2D());
    }

    public float getAdvance() {
        return (float)this.advance.getX();
    }

    public Point2D getAdvance2D() {
        return this.advance;
    }

    public Shape getLogicalHighlightShape(int n, int n2) {
        Shape shape = null;
        n = Math.max(0, n);
        n2 = Math.min(n2, this.gv.getNumGlyphs());
        if (n == 0 && n2 == this.gv.getNumGlyphs()) {
            shape = new GeneralPath(this.getBounds());
        } else {
            int n3 = n;
            while (n3 < n2) {
                Shape shape2 = this.getGlyphLogicalBounds(n3);
                Rectangle2D rectangle2D = shape2.getBounds2D();
                if (shape == null) {
                    shape = new GeneralPath(rectangle2D);
                } else {
                    ((Path2D)shape).append(rectangle2D, false);
                }
                ++n3;
            }
            if (this.transform != null) {
                shape = this.transform.createTransformedShape(shape);
            }
        }
        return shape;
    }

    public TextHit hitTestChar(float f, float f2) {
        int n = 0;
        int n2 = this.gv.getNumGlyphs();
        float f3 = (float)this.gv.getVisualBounds().getX();
        if (this.transform != null) {
            try {
                Point2D.Float float_ = new Point2D.Float(f, f2);
                this.transform.inverseTransform(float_, float_);
                f = (float)((Point2D)float_).getX();
                f2 = (float)((Point2D)float_).getY();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        int n3 = n;
        while (n3 < n2) {
            Shape shape = this.getGlyphLogicalBounds(n3);
            Rectangle2D rectangle2D = shape.getBounds2D();
            if (rectangle2D.getX() + rectangle2D.getWidth() > (double)f3) {
                f3 = (float)(rectangle2D.getX() + rectangle2D.getWidth());
            }
            if (shape.contains(f, f2)) {
                boolean bl = (double)f > rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                boolean bl2 = !bl;
                TextHit textHit = new TextHit(n3, bl2);
                return textHit;
            }
            ++n3;
        }
        TextHit textHit = new TextHit(-1, false);
        return textHit;
    }

    public boolean isVertical() {
        return false;
    }

    public int getCharacterCount() {
        return this.gv.getNumGlyphs();
    }

    protected Shape getGlyphLogicalBounds(int n) {
        return this.glyphLogicalBounds[n];
    }

    private void computeGlyphLogicalBounds() {
        int n = this.gv.getNumGlyphs();
        this.glyphLogicalBounds = new Rectangle2D.Double[n];
        Rectangle2D.Double double_ = null;
        int n2 = 0;
        while (n2 < n) {
            GlyphMetrics glyphMetrics = this.gv.getGlyphMetrics(n2);
            Rectangle2D rectangle2D = glyphMetrics.getBounds2D();
            Point2D point2D = this.glyphPositions[n2];
            double_ = new Rectangle2D.Double(point2D.getX() + rectangle2D.getX(), point2D.getY() + rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            this.glyphLogicalBounds[n2] = double_;
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = n4 = n3;
            Point2D point2D = this.glyphPositions[n4];
            float f = (float)point2D.getY();
            float f2 = (float)point2D.getX();
            double_ = (Rectangle2D.Double)this.glyphLogicalBounds[n4];
            float f3 = (float)double_.getY();
            float f4 = (float)(double_.getY() + double_.getHeight());
            float f5 = (float)double_.getHeight() / 8.0f;
            float f6 = f;
            float f7 = f2;
            while (n5 < n) {
                double_ = (Rectangle2D.Double)this.glyphLogicalBounds[n5];
                f6 = (float)this.glyphPositions[n5].getY();
                f7 = (float)this.glyphPositions[n5].getX();
                if (f7 < f2 || Math.abs(f6 - f) > f5) break;
                f3 = Math.min((float)double_.getY(), f3);
                float f8 = (float)(double_.getY() + double_.getHeight());
                f4 = Math.max(f8, f4);
                ++n5;
            }
            n3 = n5 > n4 ? n5 - 1 : n5;
            Rectangle2D.Double double_2 = null;
            float f9 = 0.0f;
            int n6 = n4;
            while (n6 < n5) {
                double_ = (Rectangle2D.Double)this.glyphLogicalBounds[n6];
                f2 = (float)double_.getX();
                if (double_2 != null) {
                    f2 = (float)((double)f2 + ((double)f9 + double_2.getWidth())) / 2.0f;
                    this.glyphLogicalBounds[n6 - 1] = new Rectangle2D.Double(f9, double_2.getY(), f2 - f9, double_2.getHeight());
                }
                double_2 = double_ = new Rectangle2D.Double(f2, f3, Math.max(0.0, double_.getWidth() + (double_.getX() - (double)f2)), f4 - f3);
                f9 = f2;
                this.glyphLogicalBounds[n6] = double_;
                ++n6;
            }
            ++n3;
        }
    }

    protected Shape getOverlineShape() {
        double d = this.metrics.getBaselineOffsets()[0] - this.metrics.getAscent();
        BasicStroke basicStroke = new BasicStroke(this.metrics.getUnderlineThickness());
        return basicStroke.createStrokedShape(new Line2D.Double(0.0, d, this.getAdvance(), d));
    }

    protected Shape getUnderlineShape() {
        double d = this.metrics.getUnderlineOffset();
        BasicStroke basicStroke = new BasicStroke(this.metrics.getUnderlineThickness());
        return basicStroke.createStrokedShape(new Line2D.Double(0.0, d, this.getAdvance(), d));
    }

    protected Shape getStrikethroughShape() {
        double d = this.metrics.getStrikethroughOffset();
        BasicStroke basicStroke = new BasicStroke(this.metrics.getStrikethroughThickness());
        return basicStroke.createStrokedShape(new Line2D.Double(0.0, d, this.getAdvance(), d));
    }

    protected Font getFont(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        return new Font(attributedCharacterIterator.getAttributes());
    }

    protected void adjustTextSpacing() {
        this.aci.first();
        Boolean bl = (Boolean)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING);
        Float f = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH);
        Integer n = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST);
        if (bl != null && bl.booleanValue()) {
            this.applySpacingParams(f, n, (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.KERNING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING));
        }
        if (n == GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL) {
            this.transform = this.computeStretchTransform(f);
        }
    }

    protected AffineTransform computeStretchTransform(Float f) {
        AffineTransform affineTransform = null;
        if (f != null && !f.isNaN()) {
            double d = 1.0;
            double d2 = 1.0;
            if (this.isVertical()) {
                d2 = (double)f.floatValue() / this.gv.getVisualBounds().getHeight();
            } else {
                d = (double)f.floatValue() / this.gv.getVisualBounds().getWidth();
            }
            try {
                Point2D point2D = this.gv.getGlyphPosition(0);
                AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
                AffineTransform affineTransform3 = affineTransform2.createInverse();
                affineTransform = affineTransform2;
                affineTransform.concatenate(AffineTransform.getScaleInstance(d, d2));
                affineTransform.concatenate(affineTransform3);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return affineTransform;
    }

    protected void applySpacingParams(Float f, Integer n, Float f2, Float f3, Float f4) {
        this.advance = this.doSpacing(f2, f3, f4);
        if (n == GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING && f != null && !f.isNaN()) {
            float f5 = 1.0f;
            float f6 = 1.0f;
            if (!this.isVertical()) {
                f5 = f.floatValue() / (float)this.gv.getVisualBounds().getWidth();
            } else {
                f6 = f.floatValue() / (float)this.gv.getVisualBounds().getHeight();
            }
            this.rescaleSpacing(f5, f6);
        }
    }

    protected Point2D doSpacing(Float f, Float f2, Float f3) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f instanceof Float && !f.isNaN()) {
            f4 = f.floatValue();
            bl = false;
        }
        if (f2 instanceof Float && !f2.isNaN()) {
            f5 = f2.floatValue();
            bl3 = true;
        }
        if (f3 instanceof Float && !f3.isNaN()) {
            f6 = f3.floatValue();
            bl2 = true;
        }
        int n = this.gv.getNumGlyphs();
        float f7 = 0.0f;
        float f8 = 0.0f;
        Point2D[] point2DArray = new Point2D[n];
        Point2D point2D = this.glyphPositions[0];
        float f9 = (float)point2D.getX();
        float f10 = (float)point2D.getY();
        try {
            if (n > 1 && (bl2 || bl3 || !bl)) {
                int n2 = 1;
                while (n2 < n) {
                    Point2D point2D2 = this.glyphPositions[n2];
                    f7 = (float)point2D2.getX() - (float)point2D.getX();
                    f8 = (float)point2D2.getY() - (float)point2D.getY();
                    boolean bl4 = false;
                    int n3 = n2;
                    int n4 = n2;
                    GlyphMetrics glyphMetrics = this.gv.getGlyphMetrics(n2);
                    while (glyphMetrics.getBounds2D().getWidth() < 0.01 || glyphMetrics.isWhitespace()) {
                        ++n2;
                        ++n4;
                        if (!bl4) {
                            bl4 = true;
                        }
                        if (n2 >= n) {
                            bl4 = false;
                            break;
                        }
                        point2D2 = this.glyphPositions[n2];
                        glyphMetrics = this.gv.getGlyphMetrics(n2);
                    }
                    if (bl4) {
                        if (bl2) {
                            int n5 = n4 - n3;
                            float f11 = (float)point2D.getX();
                            float f12 = (float)point2D.getY();
                            f7 = (float)(point2D2.getX() - (double)f11) / (float)(n5 + 1);
                            f8 = (float)(point2D2.getY() - (double)f12) / (float)(n5 + 1);
                            if (this.isVertical()) {
                                f8 += f3.floatValue() / (float)(n5 + 1);
                            } else {
                                f7 += f3.floatValue() / (float)(n5 + 1);
                            }
                            int n6 = n3;
                            while (n6 <= n4) {
                                point2DArray[n6] = new Point2D.Float(f9 += f7, f10 += f8);
                                ++n6;
                            }
                        }
                    } else {
                        f7 = (float)(point2D2.getX() - point2D.getX());
                        f8 = (float)(point2D2.getY() - point2D.getY());
                        if (bl) {
                            if (this.isVertical()) {
                                f8 += f5;
                            } else {
                                f7 += f5;
                            }
                        } else if (this.isVertical()) {
                            f8 = (float)this.gv.getGlyphMetrics(n2 - 1).getBounds2D().getWidth() + f4 + f5;
                        } else {
                            f7 = (float)this.gv.getGlyphMetrics(n2 - 1).getBounds2D().getWidth() + f4 + f5;
                        }
                        point2DArray[n2] = new Point2D.Float(f9 += f7, f10 += f8);
                    }
                    point2D = point2D2;
                    ++n2;
                }
                int n7 = 1;
                while (n7 < n) {
                    this.glyphPositions[n7] = point2DArray[n7];
                    this.gv.setGlyphPosition(n7, this.glyphPositions[n7]);
                    ++n7;
                }
            }
            if (this.isVertical()) {
                f7 = 0.0f;
                f8 = (float)this.gv.getGlyphMetrics(n - 1).getBounds2D().getHeight() + f4 + f5;
            } else {
                f7 = (float)this.gv.getGlyphMetrics(n - 1).getBounds2D().getWidth() + f4 + f5;
                f8 = 0.0f;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Point2D point2D3 = this.advance;
        this.gv.setGlyphPosition(n, point2D3);
        return point2D3;
    }

    protected void rescaleSpacing(float f, float f2) {
        Rectangle2D rectangle2D = this.gv.getVisualBounds();
        float f3 = (float)rectangle2D.getX();
        float f4 = (float)rectangle2D.getY();
        int n = this.gv.getNumGlyphs();
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            Point2D point2D = this.glyphPositions[n2];
            f5 = (float)point2D.getX() - f3;
            f6 = (float)point2D.getY() - f4;
            this.glyphPositions[n2] = new Point2D.Float(f3 + f5 * f, f4 + f6 * f2);
            this.gv.setGlyphPosition(n2, this.glyphPositions[n2]);
            ++n2;
        }
        this.gv.setGlyphPosition(n, new Point2D.Float(f3 + f5 * f, f4 + f6 * f2));
        this.advance = new Point2D.Float((float)((double)(f3 + f5 * f) - this.offset.getX()), (float)((double)(f4 + f6 * f2) - this.offset.getY()));
    }

    protected void doExplicitGlyphLayout(boolean bl) {
        char c = this.aci.first();
        int n = 0;
        float f = this.isVertical() ? (float)this.gv.getLogicalBounds().getWidth() : (float)this.gv.getLogicalBounds().getHeight();
        float[] fArray = new float[(this.gv.getNumGlyphs() + 1) * 2];
        fArray = (float[])this.gv.getGlyphPositions(0, this.gv.getNumGlyphs(), fArray).clone();
        float f2 = (float)this.offset.getX();
        float f3 = (float)this.offset.getY();
        float f4 = fArray[0] + f2;
        float f5 = fArray[1] + f3;
        while (c != '\uffff' && n < fArray.length / 2) {
            Float f6 = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.X);
            Float f7 = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.DX);
            Float f8 = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.Y);
            Float f9 = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.DY);
            Float f10 = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION);
            if (f6 != null && !f6.isNaN()) {
                if (n == 0) {
                    if (bl) {
                        f4 = (float)this.offset.getX();
                    } else {
                        f2 = f4 = f6.floatValue();
                    }
                } else {
                    f4 = f6.floatValue();
                }
            } else if (f7 != null && !f7.isNaN()) {
                f4 += f7.floatValue();
            }
            if (f8 != null && !f8.isNaN()) {
                if (n == 0) {
                    if (bl) {
                        f5 = (float)this.offset.getY();
                    } else {
                        f3 = f5 = f8.floatValue();
                    }
                } else {
                    f5 = f8.floatValue();
                }
            } else if (f9 != null && !f9.isNaN()) {
                f5 += f9.floatValue();
            } else if (n > 0) {
                f5 += fArray[n * 2 + 1] - fArray[n * 2 - 1];
            }
            float f11 = 0.0f;
            float f12 = 0.0f;
            float f13 = 0.0f;
            Object object = this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT);
            if (object != null) {
                if (object instanceof Integer) {
                    if (object == TextAttribute.SUPERSCRIPT_SUPER) {
                        f13 = f * 0.5f;
                    } else if (object == TextAttribute.SUPERSCRIPT_SUB) {
                        f13 = -f * 0.5f;
                    }
                } else if (object instanceof Float) {
                    f13 = ((Float)object).floatValue();
                }
                if (this.isVertical()) {
                    f11 = f13;
                } else {
                    f12 = -f13;
                }
            }
            this.glyphPositions[n] = new Point2D.Float(f4 + f11, f5 + f12);
            this.gv.setGlyphPosition(n, this.glyphPositions[n]);
            if (f10 != null && !f10.isNaN()) {
                this.gv.setGlyphTransform(n, AffineTransform.getRotateInstance(f10.floatValue()));
            }
            f4 += this.gv.getGlyphMetrics(n).getAdvance();
            c = this.aci.next();
            ++n;
        }
        this.gv.setGlyphPosition(n, new Point2D.Float(f4, f5));
        this.advance = new Point2D.Float((float)((double)f4 - this.offset.getX()), (float)((double)f5 - this.offset.getY()));
        this.offset = new Point2D.Float(f2, f3);
    }

    protected class ReorderedCharacterIterator
    implements CharacterIterator {
        private int ndx;
        private int begin;
        private int end;
        private char[] c;

        ReorderedCharacterIterator(AttributedCharacterIterator attributedCharacterIterator) {
            int n = attributedCharacterIterator.getBeginIndex();
            this.begin = 0;
            this.end = attributedCharacterIterator.getEndIndex() - n;
            this.ndx = this.begin;
            this.c = new char[this.end - this.begin];
            int n2 = attributedCharacterIterator.getAttribute(TextAttribute.RUN_DIRECTION) == TextAttribute.RUN_DIRECTION_RTL ? -1 : 1;
            this.ndx = n2 > 0 ? this.begin : this.end - 1;
            char c = attributedCharacterIterator.first();
            while (c != '\uffff') {
                Integer n3 = (Integer)attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING);
                int n4 = attributedCharacterIterator.getRunLimit(TextAttribute.BIDI_EMBEDDING);
                boolean bl = false;
                int n5 = this.ndx;
                if (n3 != null) {
                    boolean bl2 = bl = !(Math.abs(Math.IEEEremainder(n3.intValue(), 2.0)) < 0.1);
                    if (bl) {
                        n5 = this.ndx + n2 * (n4 - n);
                        n2 = -n2;
                        this.ndx = n5 + n2;
                    }
                }
                while (n < n4) {
                    this.c[this.ndx] = c;
                    this.ndx += n2;
                    c = attributedCharacterIterator.next();
                    ++n;
                }
                if (!bl) continue;
                this.ndx = n5;
                n2 = -n2;
            }
            attributedCharacterIterator.first();
            this.ndx = this.begin;
        }

        public Object clone() {
            return new ReorderedCharacterIterator((AttributedCharacterIterator)GlyphLayout.this.aci.clone());
        }

        public char current() {
            return this.c[this.ndx];
        }

        public char first() {
            this.ndx = this.begin;
            return this.c[this.ndx];
        }

        public int getBeginIndex() {
            return this.begin;
        }

        public int getEndIndex() {
            return this.end;
        }

        public int getIndex() {
            return this.ndx;
        }

        public char last() {
            this.ndx = this.end - 1;
            return this.c[this.end - 1];
        }

        public char next() {
            ++this.ndx;
            if (this.ndx >= this.end) {
                this.ndx = this.end;
                return '\uffff';
            }
            return this.c[this.ndx];
        }

        public char previous() {
            --this.ndx;
            if (this.ndx < this.begin) {
                this.ndx = this.begin;
                return this.c[this.ndx];
            }
            return this.c[this.ndx];
        }

        public char setIndex(int n) {
            if (n < this.begin || n > this.end) {
                throw new IllegalArgumentException();
            }
            this.ndx = n;
            return this.c[this.ndx];
        }
    }
}

