/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Set;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.ImageHandlerBase64Encoder;
import org.apache.batik.svggen.SVGCSSStyler;
import org.apache.batik.svggen.SVGShape;
import org.apache.batik.svggen.SVGSyntax;
import org.apache.batik.svggen.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class SVGGraphics2D
extends Graphics2D
implements Cloneable,
SVGSyntax {
    public static final String ERROR_DOM_FACTORY_NULL = "domFactory should not be null";
    public static final String ERROR_IMAGE_HANDLER_NULL = "imageHandler should not be null";
    public static final String ERROR_EXTENSION_HANDLER_NULL = "extensionHandler should not be null";
    public static final String ERROR_CANVAS_SIZE_NULL = "canvas size should not be null";
    public static final String DEFAULT_XML_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_MAX_GC_OVERRIDES = 3;
    private Document domFactory;
    private ImageHandler imageHandler;
    private GraphicContext gc;
    private DOMTreeManager domTreeManager;
    private DOMGroupManager domGroupManager;
    private SVGShape shapeConverter;
    private Dimension svgCanvasSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private boolean textAsShapes = false;
    private Graphics2D fmg;

    public Dimension getSVGCanvasSize() {
        return this.svgCanvasSize;
    }

    public void setSVGCanvasSize(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException(ERROR_CANVAS_SIZE_NULL);
        }
        this.svgCanvasSize = new Dimension(dimension);
    }

    public DOMTreeManager getDOMTreeManager() {
        return this.domTreeManager;
    }

    public Document getDOMFactory() {
        return this.domFactory;
    }

    public ImageHandler getImageHandler() {
        return this.imageHandler;
    }

    public ExtensionHandler getExtensionHandler() {
        return this.domTreeManager.extensionHandler;
    }

    public void setExtensionHandler(ExtensionHandler extensionHandler) {
        if (extensionHandler == null) {
            throw new IllegalArgumentException(ERROR_EXTENSION_HANDLER_NULL);
        }
        this.domTreeManager.setExtensionHandler(extensionHandler);
    }

    public SVGGraphics2D(Document document) {
        this(document, new ImageHandlerBase64Encoder(), new DefaultExtensionHandler(), false);
    }

    public SVGGraphics2D(Document document, ImageHandler imageHandler, ExtensionHandler extensionHandler, boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        if (document == null) {
            throw new IllegalArgumentException(ERROR_DOM_FACTORY_NULL);
        }
        if (imageHandler == null) {
            throw new IllegalArgumentException(ERROR_IMAGE_HANDLER_NULL);
        }
        if (extensionHandler == null) {
            throw new IllegalArgumentException(ERROR_EXTENSION_HANDLER_NULL);
        }
        this.domFactory = document;
        this.imageHandler = imageHandler;
        this.gc = new GraphicContext(new AffineTransform());
        this.shapeConverter = new SVGShape(document);
        this.domTreeManager = new DOMTreeManager(this.gc, document, extensionHandler, imageHandler, 3);
        this.domGroupManager = new DOMGroupManager(this.gc, this.domTreeManager);
        this.domTreeManager.addGroupManager(this.domGroupManager);
        this.textAsShapes = bl;
    }

    public SVGGraphics2D(SVGGraphics2D sVGGraphics2D) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.domFactory = sVGGraphics2D.domFactory;
        this.imageHandler = sVGGraphics2D.imageHandler;
        this.gc = (GraphicContext)sVGGraphics2D.gc.clone();
        this.gc.validateTransformStack();
        this.shapeConverter = sVGGraphics2D.shapeConverter;
        this.domTreeManager = sVGGraphics2D.domTreeManager;
        this.domGroupManager = new DOMGroupManager(this.gc, this.domTreeManager);
        this.domTreeManager.addGroupManager(this.domGroupManager);
        this.textAsShapes = sVGGraphics2D.textAsShapes;
    }

    public void stream(String string) throws IOException {
        this.stream(string, false);
    }

    public void stream(String string, boolean bl) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), DEFAULT_XML_ENCODING);
        this.stream(outputStreamWriter, bl);
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }

    public void stream(Writer writer) throws IOException {
        this.stream(writer, false);
    }

    public void stream(Writer writer, boolean bl) throws IOException {
        Element element = this.getRoot();
        this.stream(element, writer, bl);
    }

    public void stream(Element element, Writer writer) throws IOException {
        this.stream(element, writer, false);
    }

    public void stream(Element element, Writer writer, boolean bl) throws IOException {
        PrintWriter printWriter = new PrintWriter(writer);
        DocumentFragment documentFragment = element.getOwnerDocument().createDocumentFragment();
        documentFragment.appendChild(element);
        if (bl) {
            SVGCSSStyler.style(documentFragment);
        }
        XmlWriter.writeXml(documentFragment, writer);
        writer.flush();
    }

    public Set getDefinitionSet() {
        return this.domTreeManager.getDefinitionSet();
    }

    public Element getTopLevelGroup() {
        return this.getTopLevelGroup(true);
    }

    public Element getTopLevelGroup(boolean bl) {
        return this.domTreeManager.getTopLevelGroup(bl);
    }

    public void setTopLevelGroup(Element element) {
        this.domTreeManager.setTopLevelGroup(element);
    }

    public Element getRoot() {
        Element element = this.domTreeManager.getRoot();
        if (this.svgCanvasSize != null) {
            element.setAttributeNS(null, "width", "" + this.svgCanvasSize.width);
            element.setAttributeNS(null, "height", "" + this.svgCanvasSize.height);
        }
        return element;
    }

    public Graphics create() {
        return new SVGGraphics2D(this);
    }

    public void translate(int n, int n2) {
        this.gc.translate(n, n2);
    }

    public Color getColor() {
        return this.gc.getColor();
    }

    public void setColor(Color color) {
        this.gc.setColor(color);
    }

    public void setPaintMode() {
        this.gc.setComposite(AlphaComposite.SrcOver);
    }

    public void setXORMode(Color color) {
        throw new Error("XOR Mode is not supported by Graphics2D SVG Generator");
    }

    public Font getFont() {
        return this.gc.getFont();
    }

    public void setFont(Font font) {
        this.gc.setFont(font);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.fmg.getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        return this.gc.getClipBounds();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.gc.clipRect(n, n2, n3, n4);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.gc.setClip(n, n2, n3, n4);
    }

    public Shape getClip() {
        return this.gc.getClip();
    }

    public void setClip(Shape shape) {
        this.gc.setClip(shape);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        Line2D.Float float_ = new Line2D.Float(n, n2, n3, n4);
        this.draw(float_);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.fill(rectangle);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.draw(rectangle);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        Paint paint = this.gc.getPaint();
        this.gc.setColor(this.gc.getBackground());
        this.fillRect(n, n2, n3, n4);
        this.gc.setPaint(paint);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6);
        this.draw(float_);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6);
        this.fill(float_);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.draw(float_);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.fill(float_);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Float float_ = new Arc2D.Float(n, n2, n3, n4, n5, n6, 0);
        this.draw(float_);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Float float_ = new Arc2D.Float(n, n2, n3, n4, n5, n6, 2);
        this.fill(float_);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(nArray[0], nArray2[0]);
            int n2 = 1;
            while (n2 < n) {
                generalPath.lineTo(nArray[n2], nArray2[n2]);
                ++n2;
            }
            this.draw(generalPath);
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.draw(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.fill(polygon);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "image");
        element.setAttributeNS(null, "x", Integer.toString(n));
        element.setAttributeNS(null, "y", Integer.toString(n2));
        element.setAttributeNS(null, "width", Integer.toString(image.getWidth(null)));
        element.setAttributeNS(null, "height", Integer.toString(image.getHeight(null)));
        this.imageHandler.handleImage(image, element);
        this.domGroupManager.addElement(element);
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "image");
        this.imageHandler.handleImage(image, element);
        element.setAttributeNS(null, "x", Integer.toString(n));
        element.setAttributeNS(null, "y", Integer.toString(n2));
        element.setAttributeNS(null, "width", Integer.toString(n3));
        element.setAttributeNS(null, "height", Integer.toString(n4));
        this.domGroupManager.addElement(element);
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(null), image.getHeight(null), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        Paint paint = this.gc.getPaint();
        this.gc.setPaint(color);
        this.fillRect(n, n2, n3, n4);
        this.gc.setPaint(paint);
        this.drawImage(image, n, n2, imageObserver);
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        bufferedImage = bufferedImage.getSubimage(n5, n6, n7 - n5, n8 - n6);
        return this.drawImage(bufferedImage, n, n2, n3 - n, n4 - n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        Paint paint = this.gc.getPaint();
        this.gc.setPaint(color);
        this.fillRect(n, n2, n3 - n, n4 - n2);
        this.gc.setPaint(paint);
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public void dispose() {
        this.domTreeManager.removeGroupManager(this.domGroupManager);
    }

    public void draw(Shape shape) {
        Stroke stroke = this.gc.getStroke();
        if (stroke instanceof BasicStroke) {
            Element element = this.shapeConverter.toSVG(shape);
            if (element != null) {
                element.setAttributeNS(null, "fill", "none");
                this.domGroupManager.addElement(element);
            }
        } else {
            Shape shape2 = stroke.createStrokedShape(shape);
            this.fill(shape2);
        }
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl = true;
        if (affineTransform.getDeterminant() != 0.0) {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error();
            }
            this.gc.transform(affineTransform);
            bl = this.drawImage(image, 0, 0, null);
            this.gc.transform(affineTransform2);
        } else {
            AffineTransform affineTransform3 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform);
            bl = this.drawImage(image, 0, 0, null);
            this.gc.setTransform(affineTransform3);
        }
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage((Image)bufferedImage, n, n2, null);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "image");
        this.imageHandler.handleImage(renderedImage, element);
        element.setAttributeNS(null, "x", Integer.toString(renderedImage.getMinX()));
        element.setAttributeNS(null, "y", Integer.toString(renderedImage.getMinY()));
        element.setAttributeNS(null, "width", Integer.toString(renderedImage.getWidth()));
        element.setAttributeNS(null, "height", Integer.toString(renderedImage.getHeight()));
        Object var4_4 = null;
        if (affineTransform.getDeterminant() != 0.0) {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error();
            }
            this.gc.transform(affineTransform);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform2);
        } else {
            AffineTransform affineTransform3 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform);
            this.domGroupManager.addElement(element);
            this.gc.setTransform(affineTransform3);
        }
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "image");
        this.imageHandler.handleImage(renderableImage, element);
        element.setAttributeNS(null, "x", AbstractSVGConverter.doubleString(renderableImage.getMinX()));
        element.setAttributeNS(null, "y", AbstractSVGConverter.doubleString(renderableImage.getMinY()));
        element.setAttributeNS(null, "width", AbstractSVGConverter.doubleString(renderableImage.getWidth()));
        element.setAttributeNS(null, "height", AbstractSVGConverter.doubleString(renderableImage.getHeight()));
        if (affineTransform.getDeterminant() != 0.0) {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error();
            }
            this.gc.transform(affineTransform);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform2);
        } else {
            AffineTransform affineTransform3 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform);
            this.domGroupManager.addElement(element);
            this.gc.setTransform(affineTransform3);
        }
    }

    public void drawString(String string, float f, float f2) {
        if (!this.textAsShapes) {
            Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "text");
            element.setAttributeNS(null, "x", AbstractSVGConverter.doubleString(f));
            element.setAttributeNS(null, "y", AbstractSVGConverter.doubleString(f2));
            element.setAttributeNS(null, "stroke", "none");
            element.appendChild(this.domFactory.createTextNode(string));
            this.domGroupManager.addElement(element);
        } else {
            GlyphVector glyphVector = this.getFont().createGlyphVector(this.getFontRenderContext(), string);
            this.drawGlyphVector(glyphVector, f, f2);
        }
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        throw new Error("AttributedCharacterIterator not supported yet");
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Shape shape = glyphVector.getOutline(f, f2);
        this.fill(shape);
    }

    public void fill(Shape shape) {
        Element element = this.shapeConverter.toSVG(shape);
        if (element != null) {
            element.setAttributeNS(null, "stroke", "none");
            this.domGroupManager.addElement(element);
        }
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            shape = this.gc.getStroke().createStrokedShape(shape);
        }
        shape = this.gc.getTransform().createTransformedShape(shape);
        return shape.intersects(rectangle);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public void setComposite(Composite composite) {
        this.gc.setComposite(composite);
    }

    public void setPaint(Paint paint) {
        this.gc.setPaint(paint);
    }

    public void setStroke(Stroke stroke) {
        this.gc.setStroke(stroke);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.gc.setRenderingHint(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.gc.getRenderingHint(key);
    }

    public void setRenderingHints(Map map) {
        this.gc.setRenderingHints(map);
    }

    public void addRenderingHints(Map map) {
        this.gc.addRenderingHints(map);
    }

    public RenderingHints getRenderingHints() {
        return this.gc.getRenderingHints();
    }

    public void translate(double d, double d2) {
        this.gc.translate(d, d2);
    }

    public void rotate(double d) {
        this.gc.rotate(d);
    }

    public void rotate(double d, double d2, double d3) {
        this.gc.rotate(d, d2, d3);
    }

    public void scale(double d, double d2) {
        this.gc.scale(d, d2);
    }

    public void shear(double d, double d2) {
        this.gc.shear(d, d2);
    }

    public void transform(AffineTransform affineTransform) {
        this.gc.transform(affineTransform);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.gc.setTransform(affineTransform);
    }

    public AffineTransform getTransform() {
        return this.gc.getTransform();
    }

    public Paint getPaint() {
        return this.gc.getPaint();
    }

    public Composite getComposite() {
        return this.gc.getComposite();
    }

    public void setBackground(Color color) {
        this.gc.setBackground(color);
    }

    public Color getBackground() {
        return this.gc.getBackground();
    }

    public Stroke getStroke() {
        return this.gc.getStroke();
    }

    public void clip(Shape shape) {
        this.gc.clip(shape);
    }

    public FontRenderContext getFontRenderContext() {
        return this.gc.getFontRenderContext();
    }
}

