/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.util.HashSet;
import java.util.Set;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGConverter;
import org.apache.batik.svggen.SVGCustomPaint;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGLinearGradient;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.apache.batik.svggen.SVGTexturePaint;
import org.w3c.dom.Document;

public class SVGPaint
implements SVGConverter {
    private SVGLinearGradient svgLinearGradient;
    private SVGTexturePaint svgTexturePaint;
    private SVGColor svgColor;
    private SVGCustomPaint svgCustomPaint;
    private Document domFactory;

    public SVGPaint(Document document, ImageHandler imageHandler, ExtensionHandler extensionHandler) {
        this.svgLinearGradient = new SVGLinearGradient(document);
        this.svgTexturePaint = new SVGTexturePaint(document, imageHandler);
        this.svgCustomPaint = new SVGCustomPaint(document, extensionHandler);
        this.svgColor = new SVGColor();
        this.domFactory = document;
    }

    void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.svgCustomPaint = new SVGCustomPaint(this.domFactory, extensionHandler);
    }

    public Set getDefinitionSet() {
        HashSet hashSet = new HashSet(this.svgLinearGradient.getDefinitionSet());
        hashSet.addAll(this.svgTexturePaint.getDefinitionSet());
        hashSet.addAll(this.svgCustomPaint.getDefinitionSet());
        hashSet.addAll(this.svgColor.getDefinitionSet());
        return hashSet;
    }

    public SVGTexturePaint getTexturePaintConverter() {
        return this.svgTexturePaint;
    }

    public SVGLinearGradient getGradientPaintConverter() {
        return this.svgLinearGradient;
    }

    public SVGCustomPaint getCustomPaintConverter() {
        return this.svgCustomPaint;
    }

    public SVGColor getColorConverter() {
        return this.svgColor;
    }

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return this.toSVG(graphicContext.getPaint());
    }

    public SVGPaintDescriptor toSVG(Paint paint) {
        SVGPaintDescriptor sVGPaintDescriptor = null;
        sVGPaintDescriptor = paint instanceof Color ? SVGColor.toSVG((Color)paint) : (paint instanceof GradientPaint ? this.svgLinearGradient.toSVG((GradientPaint)paint) : (paint instanceof TexturePaint ? this.svgTexturePaint.toSVG((TexturePaint)paint) : this.svgCustomPaint.toSVG(paint)));
        return sVGPaintDescriptor;
    }
}

