/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.WeblogicDeploymentTool;

public class WeblogicTOPLinkDeploymentTool
extends WeblogicDeploymentTool {
    private static final String TL_DTD_LOC = "http://www.objectpeople.com/tlwl/dtd/toplink-cmp_2_5_1.dtd";
    private String toplinkDescriptor;
    private String toplinkDTD;

    public void setToplinkdescriptor(String string) {
        this.toplinkDescriptor = string;
    }

    public void setToplinkdtd(String string) {
        this.toplinkDTD = string;
    }

    protected DescriptorHandler getDescriptorHandler(File file) {
        DescriptorHandler descriptorHandler = super.getDescriptorHandler(file);
        if (this.toplinkDTD != null) {
            descriptorHandler.registerDTD("-//The Object People, Inc.//DTD TOPLink for WebLogic CMP 2.5.1//EN", this.toplinkDTD);
        } else {
            descriptorHandler.registerDTD("-//The Object People, Inc.//DTD TOPLink for WebLogic CMP 2.5.1//EN", TL_DTD_LOC);
        }
        return descriptorHandler;
    }

    protected void addVendorFiles(Hashtable hashtable, String string) {
        super.addVendorFiles(hashtable, string);
        File file = null;
        if (this.usingBaseJarName()) {
            file = new File(this.getConfig().descriptorDir, this.toplinkDescriptor);
        } else {
            String string2 = string + this.getConfig().baseNameTerminator;
            File file2 = new File(this.getConfig().descriptorDir, string2).getParentFile();
            file = new File(file2, this.toplinkDescriptor);
        }
        if (file.exists()) {
            hashtable.put("META-INF/" + this.toplinkDescriptor, file);
        } else {
            this.log("Unable to locate toplink deployment descriptor. It was expected to be in " + file.getPath(), 1);
        }
    }

    public void validateConfigured() throws BuildException {
        super.validateConfigured();
        if (this.toplinkDescriptor == null) {
            throw new BuildException("The toplinkdescriptor attribute must be specified");
        }
    }
}

