/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.regexp.GlobData;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

class ReplaceData
extends GlobData {
    static SubString dollarStr = new SubString("$");
    Function lambda;
    char[] repstr;
    int dollar = -1;
    char[] charArray;
    int length;
    int index;
    int leftIndex;

    ReplaceData() {
    }

    void doGlobal(Function function, int n) throws JavaScriptException {
        char[] cArray;
        ReplaceData replaceData = this;
        Context context = Context.getCurrentContext();
        RegExpImpl regExpImpl = RegExpImpl.getRegExpImpl(context);
        SubString subString = regExpImpl.leftContext;
        char[] cArray2 = subString.charArray;
        int n2 = replaceData.leftIndex;
        int n3 = regExpImpl.lastMatch.index - n2;
        replaceData.leftIndex = regExpImpl.lastMatch.index + regExpImpl.lastMatch.length;
        int n4 = this.findReplen(regExpImpl);
        int n5 = n3 + n4;
        if (replaceData.charArray != null) {
            cArray = new char[replaceData.length + n5];
            System.arraycopy(replaceData.charArray, 0, cArray, 0, replaceData.length);
        } else {
            cArray = new char[n5];
        }
        replaceData.charArray = cArray;
        replaceData.length += n5;
        int n6 = replaceData.index;
        replaceData.index += n5;
        System.arraycopy(cArray2, n2, cArray, n6, n3);
        this.doReplace(regExpImpl, cArray, n6 += n3);
    }

    /*
     * Unable to fully structure code
     */
    void doReplace(RegExpImpl var1_1, char[] var2_2, int var3_3) {
        block6: {
            var4_4 = 0;
            var5_5 = this.repstr;
            var6_6 = this.dollar;
            var7_7 = var4_4;
            if (var6_6 == -1) break block6;
            block0: while (true) {
                var8_8 = var6_6 - var4_4;
                System.arraycopy(this.repstr, var4_4, var2_2, var3_3, var8_8);
                var3_3 += var8_8;
                var4_4 = var6_6;
                var9_9 = new int[1];
                var10_10 = ReplaceData.interpretDollar(var1_1, var5_5, var6_6, var7_7, var9_9);
                if (var10_10 != null) {
                    var8_8 = var10_10.length;
                    if (var8_8 > 0) {
                        System.arraycopy(var10_10.charArray, var10_10.index, var2_2, var3_3, var8_8);
                    }
                    var3_3 += var8_8;
                    var4_4 += var9_9[0];
                    var6_6 += var9_9[0];
                } else {
                    ++var6_6;
                }
                if (var6_6 < this.repstr.length) ** GOTO lbl-1000
                break;
                while (++var6_6 < this.repstr.length) lbl-1000:
                // 2 sources

                {
                    if (this.repstr[var6_6] != '$') continue;
                    continue block0;
                }
                break;
            }
        }
        if (this.repstr.length > var4_4) {
            System.arraycopy(this.repstr, var4_4, var2_2, var3_3, this.repstr.length - var4_4);
        }
    }

    int findReplen(RegExpImpl regExpImpl) throws JavaScriptException {
        if (this.lambda != null) {
            Object object;
            Context context = Context.getCurrentContext();
            Vector vector = regExpImpl.parens;
            int n = vector.size();
            Object[] objectArray = new Object[n + 3];
            objectArray[0] = regExpImpl.lastMatch.toString();
            int n2 = 0;
            while (n2 < n) {
                object = (SubString)vector.elementAt(n2);
                objectArray[n2 + 1] = ((SubString)object).toString();
                ++n2;
            }
            objectArray[n + 1] = new Integer(regExpImpl.leftContext.length);
            objectArray[n + 2] = this.str;
            object = this.lambda.getParentScope();
            Object object2 = this.lambda.call(context, (Scriptable)object, (Scriptable)object, objectArray);
            this.repstr = ScriptRuntime.toString(object2).toCharArray();
            return this.repstr.length;
        }
        int n = this.repstr.length;
        if (this.dollar == -1) {
            return n;
        }
        int n3 = 0;
        int n4 = this.dollar;
        while (n4 < this.repstr.length) {
            char c = this.repstr[n4];
            if (c != '$') {
                ++n4;
                continue;
            }
            int[] nArray = new int[1];
            SubString subString = ReplaceData.interpretDollar(regExpImpl, this.repstr, n4, n3, nArray);
            if (subString != null) {
                n += subString.length - nArray[0];
                n4 += nArray[0];
                continue;
            }
            ++n4;
        }
        return n;
    }

    static SubString interpretDollar(RegExpImpl regExpImpl, char[] cArray, int n, int n2, int[] nArray) {
        Context context = Context.getCurrentContext();
        if (cArray[n] != '$') {
            throw new RuntimeException();
        }
        if (context.getLanguageVersion() != 0 && context.getLanguageVersion() <= 140 && n > n2 && cArray[n - 1] == '\\') {
            return null;
        }
        char c = cArray[n + 1];
        if (NativeRegExp.isDigit(c)) {
            int n3;
            int n4;
            if (context.getLanguageVersion() != 0 && context.getLanguageVersion() <= 140) {
                if (c == '0') {
                    return null;
                }
                n4 = 0;
                char[] cArray2 = cArray;
                n3 = n;
                while (++n3 < cArray2.length && NativeRegExp.isDigit(c = cArray2[n3])) {
                    int n5 = 10 * n4 + NativeRegExp.unDigit(c);
                    if (n5 >= n4) {
                        n4 = n5;
                        continue;
                    }
                    break;
                }
            } else {
                n4 = NativeRegExp.unDigit(c);
                n3 = n + 2;
                if (n + 2 < cArray.length && NativeRegExp.isDigit(c = cArray[n + 2])) {
                    n4 = 10 * n4 + NativeRegExp.unDigit(c);
                    ++n3;
                }
                if (n4 == 0) {
                    return null;
                }
            }
            nArray[0] = n3 - n;
            return regExpImpl.getParenSubString(--n4);
        }
        nArray[0] = 2;
        switch (c) {
            case '$': {
                return dollarStr;
            }
            case '&': {
                return regExpImpl.lastMatch;
            }
            case '+': {
                return regExpImpl.lastParen;
            }
            case '`': {
                if (context.getLanguageVersion() == 120) {
                    regExpImpl.leftContext.index = 0;
                    regExpImpl.leftContext.length = regExpImpl.lastMatch.index;
                }
                return regExpImpl.leftContext;
            }
            case '\'': {
                return regExpImpl.rightContext;
            }
        }
        return null;
    }
}

