/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;

public class ExecTask
extends Task {
    private String os;
    private File out;
    private File dir;
    protected boolean failOnError = false;
    protected boolean newEnvironment = false;
    private Integer timeout = null;
    private Environment env = new Environment();
    protected Commandline cmdl = new Commandline();
    private FileOutputStream fos = null;

    public void setTimeout(Integer n) {
        this.timeout = n;
    }

    public void setExecutable(String string) {
        this.cmdl.setExecutable(string);
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setOs(String string) {
        this.os = string;
    }

    public void setCommand(Commandline commandline) {
        this.log("The command attribute is deprecated. Please use the executable attribute and nested arg elements.", 1);
        this.cmdl = commandline;
    }

    public void setOutput(File file) {
        this.out = file;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setNewenvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public void addEnv(Environment.Variable variable) {
        this.env.addVariable(variable);
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public void execute() throws BuildException {
        this.checkConfiguration();
        if (this.isValidOs()) {
            this.runExec(this.prepareExec());
        }
    }

    protected void checkConfiguration() throws BuildException {
        if (this.cmdl.getExecutable() == null) {
            throw new BuildException("no executable specified", this.location);
        }
        if (this.dir != null && !this.dir.exists()) {
            throw new BuildException("The directory you specified does not exist");
        }
        if (this.dir != null && !this.dir.isDirectory()) {
            throw new BuildException("The directory you specified is not a directory");
        }
    }

    protected boolean isValidOs() {
        String string = System.getProperty("os.name");
        this.log("Myos = " + string, 3);
        if (this.os != null && this.os.indexOf(string) < 0) {
            this.log("Not found in " + this.os, 3);
            return false;
        }
        return true;
    }

    protected Execute prepareExec() throws BuildException {
        if (this.dir == null) {
            this.dir = this.project.getBaseDir();
        }
        this.log(this.cmdl.toString(), 3);
        Execute execute = new Execute(this.createHandler(), this.createWatchdog());
        execute.setAntRun(this.project);
        execute.setWorkingDirectory(this.dir);
        String[] stringArray = this.env.getVariables();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.log("Setting environment variable: " + stringArray[n], 3);
                ++n;
            }
        }
        execute.setNewenvironment(this.newEnvironment);
        execute.setEnvironment(stringArray);
        return execute;
    }

    protected void runExec(Execute execute) throws BuildException {
        int n = -1;
        try {
            block5: {
                try {
                    execute.setCommandline(this.cmdl.getCommandline());
                    n = execute.execute();
                    if (n == 0) break block5;
                    if (this.failOnError) {
                        throw new BuildException("Exec returned: " + n, this.location);
                    }
                    this.log("Result: " + n, 0);
                }
                catch (IOException iOException) {
                    throw new BuildException("Execute failed: " + iOException, iOException, this.location);
                }
            }
            Object var5_3 = null;
            this.logFlush();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.logFlush();
            throw throwable;
        }
    }

    protected ExecuteStreamHandler createHandler() throws BuildException {
        if (this.out != null) {
            try {
                this.fos = new FileOutputStream(this.out);
                this.log("Output redirected to " + this.out, 3);
                return new PumpStreamHandler(this.fos);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new BuildException("Cannot write to " + this.out, fileNotFoundException, this.location);
            }
            catch (IOException iOException) {
                throw new BuildException("Cannot write to " + this.out, iOException, this.location);
            }
        }
        return new LogStreamHandler(this, 2, 1);
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout);
    }

    protected void logFlush() {
        try {
            if (this.fos != null) {
                this.fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

