/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;

public class FileSet
extends DataType {
    private PatternSet defaultPatterns = new PatternSet();
    private Vector additionalPatterns = new Vector();
    private File dir;
    private boolean useDefaultExcludes = true;

    public FileSet() {
    }

    protected FileSet(FileSet fileSet) {
        this.dir = fileSet.dir;
        this.defaultPatterns = fileSet.defaultPatterns;
        this.additionalPatterns = fileSet.additionalPatterns;
        this.useDefaultExcludes = fileSet.useDefaultExcludes;
    }

    public void setRefid(Reference reference) throws BuildException {
        if (this.dir != null || this.defaultPatterns.hasPatterns()) {
            throw this.tooManyAttributes();
        }
        if (!this.additionalPatterns.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(reference);
    }

    public void setDir(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (!file.exists()) {
            throw new BuildException(file.getAbsolutePath() + " not found.");
        }
        if (!file.isDirectory()) {
            throw new BuildException(file.getAbsolutePath() + " is not a directory.");
        }
        this.dir = file;
    }

    public File getDir(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getDir(project);
        }
        return this.dir;
    }

    public PatternSet createPatternSet() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PatternSet patternSet = new PatternSet();
        this.additionalPatterns.addElement(patternSet);
        return patternSet;
    }

    public PatternSet.NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createInclude();
    }

    public PatternSet.NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createExclude();
    }

    public void setIncludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludes(string);
    }

    public void setExcludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludes(string);
    }

    public void setIncludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludesfile(file);
    }

    public void setExcludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludesfile(file);
    }

    public void setDefaultexcludes(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.useDefaultExcludes = bl;
    }

    public DirectoryScanner getDirectoryScanner(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getDirectoryScanner(project);
        }
        if (this.dir == null) {
            throw new BuildException("No directory specified for fileset.");
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        this.setupDirectoryScanner(directoryScanner, project);
        directoryScanner.scan();
        return directoryScanner;
    }

    public void setupDirectoryScanner(FileScanner fileScanner, Project project) {
        if (fileScanner == null) {
            throw new IllegalArgumentException("ds cannot be null");
        }
        fileScanner.setBasedir(this.dir);
        int n = 0;
        while (n < this.additionalPatterns.size()) {
            Object e = this.additionalPatterns.elementAt(n);
            this.defaultPatterns.append((PatternSet)e, project);
            ++n;
        }
        fileScanner.setIncludes(this.defaultPatterns.getIncludePatterns(project));
        fileScanner.setExcludes(this.defaultPatterns.getExcludePatterns(project));
        if (this.useDefaultExcludes) {
            fileScanner.addDefaultExcludes();
        }
    }

    protected FileSet getRef(Project project) {
        Object object;
        if (!this.checked) {
            object = new Stack<FileSet>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, project);
        }
        if (!((object = this.ref.getReferencedObject(project)) instanceof FileSet)) {
            String string = this.ref.getRefId() + " doesn't denote a fileset";
            throw new BuildException(string);
        }
        return (FileSet)object;
    }
}

