/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.net.URL;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImageConsumer;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.pdf.PDFColor;

public class GifJpegImage
extends AbstractFopImage {
    public GifJpegImage(URL uRL) throws FopImageException {
        super(uRL);
    }

    public GifJpegImage(URL uRL, ImageReader imageReader) throws FopImageException {
        super(uRL, imageReader);
    }

    protected void loadImage() throws FopImageException {
        int n;
        int[] nArray;
        block13: {
            nArray = null;
            try {
                ImageProducer imageProducer = (ImageProducer)this.m_href.getContent();
                FopImageConsumer fopImageConsumer = new FopImageConsumer(imageProducer);
                imageProducer.startProduction(fopImageConsumer);
                while (!fopImageConsumer.isImageReady()) {
                    Thread.sleep(500L);
                }
                this.m_height = fopImageConsumer.getHeight();
                this.m_width = fopImageConsumer.getWidth();
                try {
                    nArray = fopImageConsumer.getImage();
                }
                catch (Exception exception) {
                    throw new FopImageException("Image grabbing interrupted : " + exception.getMessage());
                }
                ColorModel colorModel = fopImageConsumer.getColorModel();
                this.m_bitsPerPixel = 8;
                this.m_colorSpace = new ColorSpace(ColorSpace.DEVICE_RGB);
                if (colorModel.hasAlpha()) {
                    n = colorModel.getTransparency();
                    if (n == 1) {
                        this.m_isTransparent = false;
                        break block13;
                    }
                    if (n == 2) {
                        if (colorModel instanceof IndexColorModel) {
                            this.m_isTransparent = false;
                            byte[] byArray = new byte[((IndexColorModel)colorModel).getMapSize()];
                            byte[] byArray2 = new byte[((IndexColorModel)colorModel).getMapSize()];
                            byte[] byArray3 = new byte[((IndexColorModel)colorModel).getMapSize()];
                            byte[] byArray4 = new byte[((IndexColorModel)colorModel).getMapSize()];
                            ((IndexColorModel)colorModel).getAlphas(byArray);
                            ((IndexColorModel)colorModel).getReds(byArray2);
                            ((IndexColorModel)colorModel).getGreens(byArray3);
                            ((IndexColorModel)colorModel).getBlues(byArray4);
                            int n2 = 0;
                            while (n2 < ((IndexColorModel)colorModel).getMapSize()) {
                                if ((byArray[n2] & 0xFF) == 0) {
                                    this.m_isTransparent = true;
                                    this.m_transparentColor = new PDFColor(byArray2[n2] & 0xFF, byArray3[n2] & 0xFF, byArray4[n2] & 0xFF);
                                    break block13;
                                }
                                ++n2;
                            }
                            break block13;
                        }
                        this.m_isTransparent = false;
                        break block13;
                    }
                    this.m_isTransparent = false;
                    break block13;
                }
                this.m_isTransparent = false;
            }
            catch (Exception exception) {
                throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + exception.getClass() + " - " + exception.getMessage());
            }
        }
        this.m_bitmapsSize = this.m_width * this.m_height * 3;
        this.m_bitmaps = new byte[this.m_bitmapsSize];
        int n3 = 0;
        while (n3 < this.m_height) {
            int n4 = 0;
            while (n4 < this.m_width) {
                int n5 = nArray[n3 * this.m_width + n4];
                n = n5 >> 16 & 0xFF;
                int n6 = n5 >> 8 & 0xFF;
                int n7 = n5 & 0xFF;
                this.m_bitmaps[3 * (n3 * this.m_width + n4)] = (byte)(n & 0xFF);
                this.m_bitmaps[3 * (n3 * this.m_width + n4) + 1] = (byte)(n6 & 0xFF);
                this.m_bitmaps[3 * (n3 * this.m_width + n4) + 2] = (byte)(n7 & 0xFF);
                ++n4;
            }
            ++n3;
        }
    }
}

