/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFWArray;

public class PDFCIDFont
extends PDFObject {
    public static final byte CID_TYPE0 = 0;
    public static final byte CID_TYPE2 = 1;
    protected static final String[] TYPE_NAMES = new String[]{"CIDFontType0", "CIDFontType2"};
    protected String basefont;
    protected String cidtype;
    protected Integer dw;
    protected PDFWArray w;
    protected int[] dw2;
    protected PDFWArray w2;
    protected PDFCIDSystemInfo systemInfo;
    protected PDFCIDFontDescriptor descriptor;
    protected PDFStream cidMap;

    public PDFCIDFont(int n, String string, String string2, int n2, PDFWArray pDFWArray, PDFCIDSystemInfo pDFCIDSystemInfo, PDFCIDFontDescriptor pDFCIDFontDescriptor) {
        super(n);
        this.basefont = string;
        this.cidtype = string2;
        this.dw = new Integer(n2);
        this.w = pDFWArray;
        this.dw2 = null;
        this.w2 = null;
        this.systemInfo = pDFCIDSystemInfo;
        this.descriptor = pDFCIDFontDescriptor;
        this.cidMap = null;
    }

    public PDFCIDFont(int n, String string, String string2, int n2, int[] nArray, String string3, String string4, int n3, PDFCIDFontDescriptor pDFCIDFontDescriptor) {
        super(n);
        this.basefont = string;
        this.cidtype = string2;
        this.dw = new Integer(n2);
        this.w = new PDFWArray();
        this.w.addEntry(0, nArray);
        this.dw2 = null;
        this.w2 = null;
        this.systemInfo = new PDFCIDSystemInfo(string3, string4, n3);
        this.descriptor = pDFCIDFontDescriptor;
        this.cidMap = null;
    }

    public void setCIDMap(PDFStream pDFStream) {
        this.cidMap = pDFStream;
    }

    public void setCIDMapIdentity() {
        this.cidMap = null;
    }

    public void setDW(int n) {
        this.dw = new Integer(n);
    }

    public void setDW2(int n, int n2) {
        this.dw2 = new int[]{n, n2};
    }

    public void setDW2(int[] nArray) {
        this.dw2 = nArray;
    }

    public void setW(PDFWArray pDFWArray) {
        this.w = pDFWArray;
    }

    public void setW2(PDFWArray pDFWArray) {
        this.w2 = pDFWArray;
    }

    public byte[] toPDF() {
        return this.toPDFString().getBytes();
    }

    public String toPDFString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.number);
        stringBuffer.append(" ");
        stringBuffer.append(this.generation);
        stringBuffer.append(" obj\n<< /Type /Font");
        stringBuffer.append("\n/BaseFont /");
        stringBuffer.append(this.basefont);
        if (this.cidMap != null) {
            stringBuffer.append(" \n/CIDToGIDMap ");
            stringBuffer.append(this.cidMap.referencePDF());
        }
        stringBuffer.append(" \n/Subtype /");
        stringBuffer.append(this.cidtype);
        stringBuffer.append("\n");
        stringBuffer.append(this.systemInfo.toPDF());
        stringBuffer.append("\n/FontDescriptor ");
        stringBuffer.append(this.descriptor.referencePDF());
        if (this.dw != null) {
            stringBuffer.append("\n/DW ");
            stringBuffer.append(this.dw);
        }
        if (this.w != null) {
            stringBuffer.append("\n/W ");
            stringBuffer.append(this.w.toPDF());
            stringBuffer.append(" \n>>\nendobj\n");
        }
        if (this.dw2 != null) {
            stringBuffer.append("\n/DW2 [");
            stringBuffer.append(this.dw2[0]);
            stringBuffer.append(this.dw2[1]);
            stringBuffer.append("] \n>>\nendobj\n");
        }
        if (this.w2 != null) {
            stringBuffer.append("\n/W2 ");
            stringBuffer.append(this.w2.toPDF());
            stringBuffer.append(" \n>>\nendobj\n");
        }
        return stringBuffer.toString();
    }
}

