/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;

class Library {
    static final String[] sNumeric = new String[]{"ABS", "java.lang.Math.abs", "ACOS", "java.lang.Math.acos", "ASIN", "java.lang.Math.asin", "ATAN", "java.lang.Math.atan", "ATAN2", "java.lang.Math.atan2", "CEILING", "java.lang.Math.ceil", "COS", "java.lang.Math.cos", "COT", "org.hsqldb.Library.cot", "DEGREES", "java.lang.Math.toDegrees", "EXP", "java.lang.Math.exp", "FLOOR", "java.lang.Math.floor", "LOG", "java.lang.Math.log", "LOG10", "org.hsqldb.Library.log10", "MOD", "org.hsqldb.Library.mod", "PI", "org.hsqldb.Library.pi", "POWER", "java.lang.Math.pow", "RADIANS", "java.lang.Math.toRadians", "RAND", "java.lang.Math.random", "ROUND", "org.hsqldb.Library.round", "SIGN", "org.hsqldb.Library.sign", "SIN", "java.lang.Math.sin", "SQRT", "java.lang.Math.sqrt", "TAN", "java.lang.Math.tan", "TRUNCATE", "org.hsqldb.Library.truncate", "BITAND", "org.hsqldb.Library.bitand", "BITOR", "org.hsqldb.Library.bitor", "ROUNDMAGIC", "org.hsqldb.Library.roundMagic"};
    static final String[] sString = new String[]{"ASCII", "org.hsqldb.Library.ascii", "CHAR", "org.hsqldb.Library.character", "CONCAT", "org.hsqldb.Library.concat", "DIFFERENCE", "org.hsqldb.Library.difference", "INSERT", "org.hsqldb.Library.insert", "LCASE", "org.hsqldb.Library.lcase", "LEFT", "org.hsqldb.Library.left", "LENGTH", "org.hsqldb.Library.length", "LOCATE", "org.hsqldb.Library.locate", "LTRIM", "org.hsqldb.Library.ltrim", "REPEAT", "org.hsqldb.Library.repeat", "REPLACE", "org.hsqldb.Library.replace", "RIGHT", "org.hsqldb.Library.right", "RTRIM", "org.hsqldb.Library.rtrim", "SOUNDEX", "org.hsqldb.Library.soundex", "SPACE", "org.hsqldb.Library.space", "SUBSTRING", "org.hsqldb.Library.substring", "UCASE", "org.hsqldb.Library.ucase", "LOWER", "org.hsqldb.Library.lcase", "UPPER", "org.hsqldb.Library.ucase"};
    static final String[] sTimeDate = new String[]{"CURDATE", "org.hsqldb.Library.curdate", "CURTIME", "org.hsqldb.Library.curtime", "DAYNAME", "org.hsqldb.Library.dayname", "DAYOFMONTH", "org.hsqldb.Library.dayofmonth", "DAYOFWEEK", "org.hsqldb.Library.dayofweek", "DAYOFYEAR", "org.hsqldb.Library.dayofyear", "HOUR", "org.hsqldb.Library.hour", "MINUTE", "org.hsqldb.Library.minute", "MONTH", "org.hsqldb.Library.month", "MONTHNAME", "org.hsqldb.Library.monthname", "NOW", "org.hsqldb.Library.now", "QUARTER", "org.hsqldb.Library.quarter", "SECOND", "org.hsqldb.Library.second", "WEEK", "org.hsqldb.Library.week", "YEAR", "org.hsqldb.Library.year"};
    static final String[] sSystem = new String[]{"DATABASE", "org.hsqldb.Library.database", "USER", "org.hsqldb.Library.user", "IDENTITY", "org.hsqldb.Library.identity"};
    static Random rRandom = new Random();
    static double LOG10_FACTOR = 0.4342944819032518;

    Library() {
    }

    public static Integer ascii(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(string.charAt(0));
    }

    public static int bitand(int n, int n2) {
        return n & n2;
    }

    public static int bitor(int n, int n2) {
        return n | n2;
    }

    public static String character(int n) {
        return String.valueOf((char)n);
    }

    public static String concat(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return null;
            }
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return String.valueOf(string) + string2;
    }

    public static double cot(double d) {
        return 1.0 / Math.tan(d);
    }

    public static java.sql.Date curdate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static Time curtime() {
        return new Time(System.currentTimeMillis());
    }

    public static String database(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        String string = "SELECT Value FROM SYSTEM_CONNECTIONINFO WHERE KEY='DATABASE'";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        return resultSet.getString(1);
    }

    public static String dayname(java.sql.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE");
        return simpleDateFormat.format(date).toString();
    }

    public static int dayofmonth(java.sql.Date date) {
        return Library.getDateTimePart(date, 5);
    }

    public static int dayofweek(java.sql.Date date) {
        return Library.getDateTimePart(date, 7);
    }

    public static int dayofyear(java.sql.Date date) {
        return Library.getDateTimePart(date, 6);
    }

    public static int difference(String string, String string2) {
        if (string == null || string2 == null) {
            return 0;
        }
        string = Library.soundex(string);
        string2 = Library.soundex(string2);
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < 4) {
            if (n4 >= n || n4 >= n2 || string.charAt(n4) != string2.charAt(n4)) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    private static int getDateTimePart(Date date, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(n);
    }

    private static int getTimePart(Time time, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(time);
        return gregorianCalendar.get(n);
    }

    public static int hour(Time time) {
        return Library.getDateTimePart(time, 10);
    }

    public static int identity(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        String string = "SELECT VALUE FROM SYSTEM_CONNECTIONINFO WHERE KEY='IDENTITY'";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        return resultSet.getInt(1);
    }

    public static String insert(String string, int n, int n2, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (--n < 0 || n2 <= 0 || n4 == 0 || n > n3) {
            return string;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return String.valueOf(string.substring(0, n)) + string2 + string.substring(n + n2);
    }

    public static String lcase(String string) {
        return string == null ? null : string.toLowerCase();
    }

    public static String left(String string, int n) {
        return string == null ? null : string.substring(0, n < 0 ? 0 : (n < string.length() ? n : string.length()));
    }

    public static int length(String string) {
        return string == null || string.length() < 1 ? 0 : string.length();
    }

    public static int locate(String string, String string2, Integer n) {
        if (string2 == null || string == null) {
            return 0;
        }
        int n2 = n == null ? 0 : n - 1;
        return string2.indexOf(string, n2 < 0 ? 0 : n2) + 1;
    }

    public static double log10(double d) {
        return Library.roundMagic(Math.log(d) * LOG10_FACTOR);
    }

    public static String ltrim(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n && string.charAt(n2) <= ' ') {
            ++n2;
        }
        return n2 == 0 ? string : string.substring(n2);
    }

    public static int minute(Time time) {
        return Library.getDateTimePart(time, 12);
    }

    public static int mod(int n, int n2) {
        return n % n2;
    }

    public static int month(java.sql.Date date) {
        return Library.getDateTimePart(date, 2);
    }

    public static String monthname(java.sql.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM");
        return simpleDateFormat.format(date).toString();
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static double pi() {
        return Math.PI;
    }

    public static int quarter(java.sql.Date date) {
        return Library.getDateTimePart(date, 2) / 3 + 1;
    }

    public static double rand(Integer n) {
        if (n != null) {
            rRandom.setSeed(n.intValue());
        }
        return rRandom.nextDouble();
    }

    static void register(Hashtable hashtable) {
        Library.register(hashtable, sNumeric);
        Library.register(hashtable, sString);
        Library.register(hashtable, sTimeDate);
        Library.register(hashtable, sSystem);
    }

    private static void register(Hashtable hashtable, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], stringArray[n + 1]);
            n += 2;
        }
    }

    public static String repeat(String string, int n) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string2.length();
        while (true) {
            int n3;
            if ((n3 = string.indexOf(string2, n)) == -1) break;
            stringBuffer.append(string.substring(n, n3 - n));
            stringBuffer.append(string3);
            n = n3 + n2;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String right(String string, int n) {
        if (string == null) {
            return null;
        }
        n = string.length() - n;
        return string.substring(n < 0 ? 0 : (n < string.length() ? n : string.length()));
    }

    public static double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(d);
        int n = stringBuffer.length();
        if (n < 16) {
            return d;
        }
        char c = stringBuffer.charAt(n - 1);
        char c2 = stringBuffer.charAt(n - 2);
        char c3 = stringBuffer.charAt(n - 3);
        char c4 = stringBuffer.charAt(n - 4);
        if (c2 == '0' && c3 == '0' && c4 == '0' && c != '.') {
            stringBuffer.setCharAt(n - 1, '0');
        } else if (c2 == '9' && c3 == '9' && c4 == '9' && c != '.') {
            stringBuffer.setCharAt(n - 1, '9');
            stringBuffer.append('9');
            stringBuffer.append('9');
        }
        return new Double(stringBuffer.toString());
    }

    public static String rtrim(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length() - 1;
        while (n >= 0 && string.charAt(n) <= ' ') {
            --n;
        }
        return n == string.length() ? string : string.substring(0, n + 1);
    }

    public static int second(java.sql.Date date) {
        return Library.getDateTimePart(date, 13);
    }

    public static int sign(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static String soundex(String string) {
        if (string == null) {
            return string;
        }
        string = string.toUpperCase();
        int n = string.length();
        char[] cArray = new char[4];
        cArray[0] = string.charAt(0);
        int n2 = 1;
        int n3 = 1;
        while (n3 < n && n2 < 4) {
            char c = string.charAt(n3);
            if ("BFPV".indexOf(c) != -1) {
                cArray[n2++] = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                cArray[n2++] = 50;
            } else if (c == 'D' || c == 'T') {
                cArray[n2++] = 51;
            } else if (c == 'L') {
                cArray[n2++] = 52;
            } else if (c == 'M' || c == 'N') {
                cArray[n2++] = 53;
            } else if (c == 'R') {
                cArray[n2++] = 54;
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    public static String space(int n) {
        if (n < 0) {
            return null;
        }
        char[] cArray = new char[n];
        while (n > 0) {
            cArray[--n] = 32;
        }
        return new String(cArray);
    }

    public static String substring(String string, int n, Integer n2) {
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        int n4 = n = --n > n3 ? n3 : n;
        if (n2 == null) {
            return string.substring(n);
        }
        int n5 = n2;
        return string.substring(n, n + n5 > n3 ? n3 : n5);
    }

    public static double truncate(double d, int n) {
        double d2 = Math.pow(10.0, n);
        double d3 = d * d2;
        return (d < 0.0 ? Math.ceil(d3) : Math.floor(d3)) / d2;
    }

    public static String ucase(String string) {
        return string == null ? null : string.toUpperCase();
    }

    public static String user(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        String string = "SELECT Value FROM SYSTEM_CONNECTIONINFO WHERE KEY='USER'";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        return resultSet.getString(1);
    }

    public static int week(java.sql.Date date) {
        return Library.getDateTimePart(date, 3);
    }

    public static int year(java.sql.Date date) {
        return Library.getDateTimePart(date, 1);
    }
}

