/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.util.Vector;

public class Grid
extends Panel {
    private Dimension dMinimum;
    private Font fFont = new Font("Dialog", 0, 12);
    private FontMetrics fMetrics;
    private Graphics gImage;
    private Image iImage;
    private int iWidth;
    private int iHeight;
    private int iRowHeight;
    private int iFirstRow;
    private int iGridWidth;
    private int iGridHeight;
    private int iX;
    private int iY;
    private String[] sColHead;
    private Vector vData;
    private int[] iColWidth;
    private int iColCount;
    private int iRowCount;
    private Scrollbar sbHoriz;
    private Scrollbar sbVert;
    private int iSbWidth;
    private int iSbHeight;
    private boolean bDrag;
    private int iXDrag;
    private int iColDrag;

    public Grid() {
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
    }

    public void addRow(String[] stringArray) {
        if (stringArray.length != this.iColCount) {
            return;
        }
        String[] stringArray2 = new String[this.iColCount];
        int n = 0;
        while (n < this.iColCount) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        this.vData.addElement(stringArray2);
        ++this.iRowCount;
    }

    void adjustScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.iColCount) {
            n += this.iColWidth[n2];
            ++n2;
        }
        this.iGridWidth = n;
        this.iGridHeight = this.iRowHeight * (this.iRowCount + 1);
        this.sbHoriz.setValues(this.iX, this.iWidth, 0, this.iGridWidth);
        int n3 = this.iY / this.iRowHeight;
        int n4 = this.iHeight / this.iRowHeight;
        this.sbVert.setValues(n3, n4, 0, this.iRowCount + 1);
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
    }

    private void calcAutoWidth(int n) {
        int n2 = 10;
        n2 = Math.max(n2, this.fMetrics.stringWidth(this.sColHead[n]));
        int n3 = 0;
        while (n3 < this.iRowCount) {
            String[] stringArray = (String[])this.vData.elementAt(n3);
            n2 = Math.max(n2, this.fMetrics.stringWidth(stringArray[n]));
            ++n3;
        }
        this.iColWidth[n] = n2 + 6;
    }

    private String get(int n, int n2) {
        return ((String[])this.vData.elementAt(n2))[n];
    }

    Vector getData() {
        return this.vData;
    }

    private String getDisplay(int n, int n2) {
        return ((String[])this.vData.elementAt(n2))[n];
    }

    String[] getHead() {
        return this.sColHead;
    }

    private static int getMaxHeight(FontMetrics fontMetrics) {
        return fontMetrics.getHeight() + 4;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.minimumSize();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.iX = this.sbHoriz.getValue();
                this.iY = this.iRowHeight * this.sbVert.getValue();
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public Dimension minimumSize() {
        return this.dMinimum;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.bDrag && n < this.iWidth) {
            int n3 = n - this.iXDrag;
            if (n3 < 0) {
                n3 = 0;
            }
            this.iColWidth[this.iColDrag] = n3;
            this.adjustScroll();
            this.repaint();
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.bDrag) {
            this.setCursor(new Cursor(0));
            this.bDrag = false;
        }
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (n2 <= this.iRowHeight) {
            int n3 = n;
            n += this.iX - this.iGridWidth;
            int n4 = this.iColCount - 1;
            while (n4 >= 0) {
                if (n > -7 && n < 7) break;
                n += this.iColWidth[n4];
                --n4;
            }
            if (n4 >= 0) {
                if (!this.bDrag) {
                    this.setCursor(new Cursor(11));
                    this.bDrag = true;
                    this.iXDrag = n3 - this.iColWidth[n4];
                    this.iColDrag = n4;
                }
                return true;
            }
        }
        return this.mouseExit(event, n, n2);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (graphics == null) {
            return;
        }
        if (this.iWidth <= 0 || this.iHeight <= 0) {
            return;
        }
        graphics.setColor(SystemColor.control);
        graphics.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            this.gImage.setFont(this.fFont);
            if (this.fMetrics == null) {
                this.fMetrics = this.gImage.getFontMetrics();
            }
        }
        if (this.iRowHeight == 0) {
            this.iRowHeight = Grid.getMaxHeight(this.fMetrics);
            n2 = 0;
            while (n2 < this.iColCount) {
                this.calcAutoWidth(n2);
                ++n2;
            }
            this.adjustScroll();
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, this.iRowHeight, this.iWidth, this.iRowHeight);
        n2 = -this.iX;
        int n3 = 0;
        while (n3 < this.iColCount) {
            n = this.iColWidth[n3];
            this.gImage.setColor(SystemColor.control);
            this.gImage.fillRect(n2 + 1, 0, n - 2, this.iRowHeight);
            this.gImage.setColor(Color.black);
            this.gImage.drawString(this.sColHead[n3], n2 + 2, this.iRowHeight - 5);
            this.gImage.setColor(Color.darkGray);
            this.gImage.drawLine(n2 + n - 1, 0, n2 + n - 1, this.iRowHeight - 1);
            this.gImage.setColor(Color.white);
            this.gImage.drawLine(n2 + n, 0, n2 + n, this.iRowHeight - 1);
            n2 += n;
            ++n3;
        }
        this.gImage.setColor(SystemColor.control);
        this.gImage.fillRect(0, 0, 1, this.iRowHeight);
        this.gImage.fillRect(n2 + 1, 0, this.iWidth - n2, this.iRowHeight);
        this.gImage.drawLine(0, 0, 0, this.iRowHeight - 1);
        n = this.iRowHeight + 1 - this.iY;
        int n4 = 0;
        while (n < this.iRowHeight + 1) {
            ++n4;
            n += this.iRowHeight;
        }
        this.iFirstRow = n4;
        n = this.iRowHeight + 1;
        while (n < this.iHeight && n4 < this.iRowCount) {
            n2 = -this.iX;
            int n5 = 0;
            while (n5 < this.iColCount) {
                int n6 = this.iColWidth[n5];
                Color color = Color.white;
                Color color2 = Color.black;
                this.gImage.setColor(color);
                this.gImage.fillRect(n2, n, n6 - 1, this.iRowHeight - 1);
                this.gImage.setColor(color2);
                this.gImage.drawString(this.getDisplay(n5, n4), n2 + 2, n + this.iRowHeight - 5);
                this.gImage.setColor(Color.lightGray);
                this.gImage.drawLine(n2 + n6 - 1, n, n2 + n6 - 1, n + this.iRowHeight - 1);
                this.gImage.drawLine(n2, n + this.iRowHeight - 1, n2 + n6 - 1, n + this.iRowHeight - 1);
                n2 += n6;
                ++n5;
            }
            this.gImage.setColor(Color.white);
            this.gImage.fillRect(n2, n, this.iWidth - n2, this.iRowHeight - 1);
            ++n4;
            n += this.iRowHeight;
        }
        graphics.drawImage(this.iImage, 0, 0, this);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        this.iHeight = n4 - this.iSbHeight;
        this.iWidth = n3 - this.iSbWidth;
        this.sbHoriz.reshape(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.reshape(this.iWidth, 0, this.iSbWidth, this.iHeight);
        this.adjustScroll();
        this.iImage = null;
        this.repaint();
    }

    public void setHead(String[] stringArray) {
        this.vData = new Vector();
        this.iColCount = stringArray.length;
        this.sColHead = new String[this.iColCount];
        this.iColWidth = new int[this.iColCount];
        int n = 0;
        while (n < this.iColCount) {
            this.sColHead[n] = stringArray[n];
            this.iColWidth[n] = 100;
            ++n;
        }
        this.iRowCount = 0;
        this.iRowHeight = 0;
    }

    public void setMinimumSize(Dimension dimension) {
        this.dMinimum = dimension;
    }

    public void update() {
        this.adjustScroll();
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

