/*
 * ScrollText.java
 *
 * Created on 29 de diciembre de 2004, 02:05 AM
 */

package common;

import java.awt.Dimension;
//UNUSED import java.io.File;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.WindowConstants;
/**
 *
 * @author  Mauricio Gracia Guti�rrez
 */
public class ScrollText extends JFrame { 
    String initial ;
    private int width = 500 ;
    private int height = 500 ;
    private Dimension screenSize ;
    private JPanel JPlogo ;
    private JLabel logo;
    
    /** Creates new form ScrollText */
    public ScrollText() {
        super() ;
        initComponents();
    }
    public ScrollText(String init) {
        super() ;
        initComponents();
        this.initial = init ;
        this.STP.setText(this.initial) ;
    }
    public void setDisabledColor() {
        this.STP.setDisabledColor() ;
    }
    public void setSTPColor(java.awt.Color c) {
        this.STP.setBackground(c) ;
    }
    
    public void addLogo(String imageName) {
        JPlogo = new JPanel() ;
        logo = new javax.swing.JLabel();
        logo.setIcon(new javax.swing.ImageIcon(imageName));
        JPlogo.add(logo) ;
        getContentPane().add(JPlogo, java.awt.BorderLayout.NORTH);
        this.validate() ;
    }
    public void removeLogo() {
        getContentPane().remove(JPlogo) ;
        this.validate() ;
    }
    public void setEditable(boolean b) {
        this.STP.setEditable(b) ;
    }
    
    public void setText(String str) 
    {
        this.STP.setText(str) ;
    }
    public void append(String str)
    {
        this.STP.append(str) ;
    }
    public void displayFile(String file)
    {
        this.STP.displayFile(file) ;
    }   
    public void setWidth(int w) {
        if(w > 0) {
            this.width = w ;
            this.setBounds((screenSize.width-width)/2, (screenSize.height-height)/2, width, height);
        }
    }
    public void setHeight(int h) {
        if(h > 0) {
            this.height = h ;
            this.setBounds((screenSize.width-width)/2, (screenSize.height-height)/2, width, height);
        }
    }
    public void setClosable(boolean isClosable, boolean doExit) {
        if(isClosable) {
            if(doExit) {
                setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE) ;
            } else {
                setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE) ;
            }
        }
        else {
            setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE) ;
        }
    }
    public ScrollTextPanel getScrollTextPanel() {
        return this.STP ;
    }
    public void addClearLog() {
        javax.swing.JPanel jPanel2 ;
        javax.swing.JButton clear ;


        jPanel2 = new javax.swing.JPanel();
        clear = new javax.swing.JButton();
        
        clear.setText("Clear Log");
        clear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearActionPerformed(evt);
            }
        });
        jPanel2.add(clear);
        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);
    }
    private void clearActionPerformed(java.awt.event.ActionEvent e) {
        this.STP.setText(this.initial) ;
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        STP = new common.ScrollTextPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("DGUITAR LOG");
        setFont(new java.awt.Font("Arial", 0, 12));
        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        getContentPane().add(jLabel1, java.awt.BorderLayout.NORTH);

        STP.setBackground(new java.awt.Color(255, 255, 255));
        STP.setEditable(true);
        getContentPane().add(STP, java.awt.BorderLayout.CENTER);

        screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-625)/2, (screenSize.height-327)/2, 625, 327);
    }//GEN-END:initComponents
    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private common.ScrollTextPanel STP;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables
    
}
