/*
 * MidiForm.java
 *
 * Created on 3 de febrero de 2005, 05:23 PM
 */

package dguitar.gui.midi;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import common.ImageToolBar;
import common.Midi;
import common.SwingWorker;
import dguitar.gui.DGuitar;

/*
 * @author Mauricio Gracia Gutirrez
 *
 *
 */
//OLD public class MidiTest extends javax.swing.JFrame implements ListSelectionListener {
public class MidiTest extends JDialog 
implements ListSelectionListener, ActionListener,WindowListener{
    public int defaultInst;
    
    static int duration;
    
    private ImageToolBar NoteToolBar;
    
    private Image playImg ;
    
	private boolean playing;

	private SwingWorker workerPlay;

    
    private Midi midi ;
    /** Creates new form MidiForm */
    public MidiTest(JFrame parent, boolean modal, Midi m, Image []notes, Image play) {
    	super(parent,modal) ;
    	
    	this.playing = false ;
    	this.workerPlay = null ;
    	this.playImg = play ;
    	this.setResizable(false) ;
    	midi = m ;
        initComponents();
        
        if (midi != null) {
        	
        	
            
            //WORKS addToolBar(DGuitar.Notes);
        	addToolBar(notes) ;
            this.pack() ;
            
            String insts[] = midi.getInstrumentStrings();
            if (insts != null) {
                this.instruments.setListData(insts);
                this.instruments
                        .setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
                this.instruments.addListSelectionListener(this) ;
                defaultInst = 0;
                if (insts.length >= 24) {
                    defaultInst = 24;
                }
                this.instruments.setSelectedIndex(defaultInst);
                this.instruments.ensureIndexIsVisible(defaultInst);
                midi.prepareToPlay() ;
                duration = 4 ;//16th NOTE
                createScale() ;
                //new
                this.addWindowListener(this) ;
            } else {
                    common.Util.showDialogOk(this, "Midi support for this computer failed","midi.getInstrumentStrings() returned null");
            }
        } else {
            common.Util.showDialogOk(this,"Midi support for this computer failed","MidiObject could not be created");
            this.dispose() ;
        }
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        instruments = new javax.swing.JList();

        // start add the PLAY button
		TB = new JToolBar();

		playBtn = new JToggleButton(new ImageIcon(this.playImg));
		playBtn.addActionListener(this);
		TB.setFloatable(false);
		TB.add(playBtn);

		//finish add play button
        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(DGuitar.getLang().getString("Midi_Test")) ;
        jLabel1.setText(DGuitar.getLang().getString("Instruments") );
        getContentPane().add(jLabel1, java.awt.BorderLayout.NORTH);

        jScrollPane1.setViewportView(instruments);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        getContentPane().add(TB, java.awt.BorderLayout.EAST);

    }//GEN-END:initComponents
        
/*	private void playActionPerformed(java.awt.event.ActionEvent evt) {
            this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
            playScale(duration);
            this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	}
	*/
        public void valueChanged(ListSelectionEvent e) {
        	createScale() ;
        }
        private void setCurrentInstrument() {
                int inst;
                    
                inst = this.instruments.getSelectedIndex();
                midi.setInstrument(inst);
        }

        private void addToolBar(Image imgs[]) {
            
            this.NoteToolBar = new ImageToolBar();
            this.NoteToolBar.setFloatable(false);
            this.NoteToolBar.setNumButtons(8);
            this.NoteToolBar.setImages(imgs);
            this.NoteToolBar.addActionListener(new NoteToolBarListener());
            this.getContentPane().add(this.NoteToolBar, java.awt.BorderLayout.SOUTH);
            java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds((screenSize.width-300)/2, (screenSize.height-300)/2, 400, 300);        

            this.validate();
        }
        private void createScale() {
            int note ;
            
            midi.setSequencePPQ(16) ; 
            //128 is 2 to the 7...which is fastest duration...then...
        	midi.DELTA = 128 / common.Util.pow2(duration);
        	setCurrentInstrument() ;
            
            for (note = 60; note <= 66; note++) {
            	midi.addNote(note);
            }


        /*TODO Show which button is currently selected..this does not work
        JButton JB = (JButton) NoteToolBar.getComponentAtIndex(duration) ; 
        JB.setSelected(true) ;
        NoteToolBar.validate() ;
        */
        }

        class NoteToolBarListener implements ActionListener {
            
            public void actionPerformed(ActionEvent e) {
                Object obj;
                JButton jbutton;

                obj = e.getSource();
                jbutton = new JButton();
                if (obj.getClass().isInstance(jbutton)) {
                    jbutton = (JButton) obj;
                    try {
                    	duration = Integer.parseInt(jbutton.getActionCommand());
                    	createScale() ;
                    } catch (NumberFormatException NFE) {
                        NFE.printStackTrace();
                    }
                }
                
            }
            
        }
        
        //private ReproductionControlToolBar RCT ;  
        
    	JToolBar TB;

    	JToggleButton playBtn;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList instruments;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;

    // End of variables declaration//GEN-END:variables
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent arg0) {
		if(!playing) {
			workerPlay = new SwingWorker() {
				public Object construct() {
					midi.play();
					playing = false ;
					playBtn.setSelected(false) ;
					return (null);
				}
			};
			playing = true ;
			workerPlay.start();
		}
		else {
			midi.stop() ;
			playing = false ;
		}
	}

    /* (non-Javadoc)
     * @see java.awt.event.WindowListener#windowActivated(java.awt.event.WindowEvent)
     */
    public void windowActivated(WindowEvent e) {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see java.awt.event.WindowListener#windowClosed(java.awt.event.WindowEvent)
     */
    public void windowClosed(WindowEvent e) {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see java.awt.event.WindowListener#windowClosing(java.awt.event.WindowEvent)
     */
    public void windowClosing(WindowEvent e) {
        if(this.workerPlay != null) {
            workerPlay.interrupt() ;
            midi.stop() ;
        }
        
    }

    /* (non-Javadoc)
     * @see java.awt.event.WindowListener#windowDeactivated(java.awt.event.WindowEvent)
     */
    public void windowDeactivated(WindowEvent e) {
        
    }

    /* (non-Javadoc)
     * @see java.awt.event.WindowListener#windowDeiconified(java.awt.event.WindowEvent)
     */
    public void windowDeiconified(WindowEvent e) {
        
    }

    /* (non-Javadoc)
     * @see java.awt.event.WindowListener#windowIconified(java.awt.event.WindowEvent)
     */
    public void windowIconified(WindowEvent e) {
    }

    /* (non-Javadoc)
     * @see java.awt.event.WindowListener#windowOpened(java.awt.event.WindowEvent)
     */
    public void windowOpened(WindowEvent e) {
        
    }
        
}