/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_GB.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfgGetBoolean
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Scan an option as boolean
he(ader files): 
lo(ng description): Checks if the current option applies to the boolean
	type and perform the actions, if so.\par
	On success the value of \para{*num} has been changed to:
	\item 0: on OFF
	\item 1: on ON
	\item 2: on TOGGLE
	\item else: any numerical specified as boolean option
	\nolist
pr(erequistes): 
re(lated to): 
se(condary subsystems): 
va: 0: on success\item else: on failure
xr(ef): 
im(port): 
fi(le): cfg_gb.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <limits.h>
#include <portable.h>
#include "dynstr.h"
#include "str.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_GB.C 1.5 1999/12/13 02:21:58 ska Exp ska $";
#endif

int cfgGetBoolean(struct Cfg_Getopt * const optstru, int * const num)
{	unsigned n;

	DBG_ENTER("cfgGetBoolean", Suppl_cmdline)

	assert(optstru);
	assert(num);

	switch(optArgType()) {
	case CFG_TERROR:
		DBG_RETURN_I( 1)		/* no argument at all */

	case CFG_TBOOLEAN:
		*num = optArgBoolean();
		DBG_RETURN_I( 0)

	case CFG_TINTEGER:
		*num = !!optArgInteger();
		DBG_RETURN_I( 0)

	default:		/* Unknown == string */
		switch(strbool(optArgString())) {
		case 0:		/* false */
				*num = 0;
				DBG_RETURN_I( 0)
		case 1:		/* true */
				*num = 1;
				DBG_RETURN_I( 0)
		case 2:		/* toggle */
			*num = !*num;
			DBG_RETURN_I( 0)
		case -1:	/* more than one word */
			DBG_RETURN_I( 2)
		}

		if(cfgGetUnsigned(optstru, &n, 0, UINT_MAX, 10) == 0) {
			*num = !!n;
			DBG_RETURN_I( 0)
		}

	}

	DBG_RETURN_I( 3)		/* failed */
}
