/*  allocateMemory():
 *
 *  This function allocates all memory that the new program needs.
 *  When allocating the main memory block, it will first try to use
 *  upper memory, and then it will try conventional memory.
 */

int allocateMemory(void)
{
   WORD strategy;
   int i;

   /* Set the UMB link */
   DosSetUMBLink(1);  /* Now the global variable umbLink = 1 if successful */
   DosSetStrategy(0);

   if (!umbLink && sw[sw_verbose])
       printf ("LOADHI: Upper memory not available, using conventional memory.\n");
 
   /* If the 'minSize' argument is zero, and the /S switch was used, block
      access to the region */
   for (i = 0; i < umbRegions; i++)
        if (!umbRegion[i].minSize)
            umbRegion[i].access = !sw[sw_shrink];

   /* number of paragraphs to allocate for environment: */
   envSize = sw[sw_noenv]? 0 : topara(myEnvSize + strlen(filename) + 3);

   if (alloc() != OK)
       return rc;

   if (sw[sw_verbose]) {
       if (envSeg)
           printf ("LOADHI: environment copy created at segment %04x\n", envSeg);

       printf ("LOADHI: PSP segment allocated at segment %04x, size = %04x\n",
                pspSeg, memSize);
   }
   return OK;
}

int alloc(void)
{   
    int i;
    struct UMBREGION far *region = umbRegion;
    struct freeBlock mem;
    availBlock = malloc(256 * sizeof(*availBlock));
    if (!availBlock)
        return err_alloc_all;
 
    /* Call to force DOS to catenate any successive free memory blocks */
    DosAlloc(0xffff);

    /* This loop sets up each UMB region as specified:
       If the 'L' switch was present on the command line, any memory
       region not listed there will be disabled for the program.
 
       If a minimal size was specified, the memory region will only be
       available to the program if it contains a free memory block of 
       at least this size.

       When the loop finishes, the array 'block' will contain memory
       handles for every free memory block that the program was not 
       allowed to access.

       The array 'availBlock' will contain the memory handles and the
       size about every memory block that the program can use.
     */


    for (i = 0; i < umbRegions; i++, region++) {
         struct MCB far *mcb = MK_FP(region->start, 0);
         WORD startBlock = availBlocks;
         struct freeBlock *theBlock = 0;
         int j;

         while (FP_SEG(mcb) < region->end) {
            if (!mcb->owner) {
                WORD bl = DosAlloc(mcb->size);
 
                if (bl != FP_SEG(mcb) + 1)
                    return err_mcb_chain;
 
                if (!region->access)
                    block[allocatedBlocks++] = bl;
                else {
                    if (!theBlock && mcb->size >= region->minSize) {
                        theBlock = availBlock + availBlocks;
                     
                        if (sw[sw_shrink])
                            DosResize(bl, region->minSize);
                    }
                    availBlock[availBlocks].address = bl;
                    availBlock[availBlocks++].size = mcb->size;
                }
            }
            FP_SEG(mcb) += mcb->size + 1;
         }

         if (region->access && region->minSize != 0xffff) 
             if (!theBlock || sw[sw_shrink]) {
                 for (j = startBlock; j < availBlocks; j++)
                      if (!theBlock || theBlock - availBlock != j)
                          block[allocatedBlocks++] = availBlock[j].address;
                 
                 availBlocks = startBlock;
                 if (theBlock)
                     availBlock[availBlocks++] = *theBlock;
             }
   }      
 
   
   /* Now, block[] contains the blocks that can't be used by the 
      program, and availBlock[] contains the blocks that can be used */

   /* determine which block to use for environment memory */
   /* for MS-DOS compatibility, allocate it in the first block possible */
   /* if the 'L' switch was present, try the blocks in the order they
      were listed at the command line */

   if (!(sw[sw_noenv])) {
       if (allocBlock(envSize, envSize, 0, &mem) != OK)
           return err_alloc_env;

       envSeg = mem.address;
   }

   if (allocBlock(memNeeded, memWanted, at_address, &mem) != OK)
       return err_prog_mem;

   pspSeg = mem.address;
   memSize = mem.size;

   inUMB = pspSeg > umbRegion[0].end;

   for (i = 0; i < availBlocks; i++)
        DosFree(availBlock[i].address);

   free(availBlock);
   return OK;
}

/*  This routine allocates the block, using several parameters.
 *
 *  If 'address' is != 0, it will first attempt to allocate the block
 *  at this segment address.
 *
 *  Otherwise, it will attempt to allocate the block in the memory regions
 *
 *  'minSz' contains the minimal size of the block. 'maxSz' contains the
 *  max size - if the block found is bigger, it will be shrunk to this
 *  size. 
 *
 *  'result' contains the starting address and the size of the allocated
 *  memory block.
 */


int allocBlock(WORD minSz, WORD maxSz, WORD address, struct freeBlock *result)
{
   int i = 0;
   int first = 0;
   struct freeBlock *bestBlock = 0;
   WORD blSize = 0;
   struct UMBREGION *r;
   int ro = 0;
   size_t addressEnd = 0;

   while (ro < umbRegions && !bestBlock) {
      size_t biggest = 0;

      if (address) {
         for (first = 0; first < availBlocks; first++) {
             size_t blEnd = availBlock[first].address + availBlock[first].size;

             if (availBlock[first].address && blEnd > address) {
                addressEnd = 0xffff;
                break;
             }
         }
         if (first == availBlocks) {
             address = 0;
             continue;
         }
      } else {
         r = umbRegion + regionOrder[ro++];
         for (first = 0; first < availBlocks; first++)
             if (availBlock[first].address >= r->start) {
                addressEnd = r->end;
                break;
             }
      }

      for (i = first; i < availBlocks; i++) {
          if (availBlock[i].address >= addressEnd) break;

          if (address && availBlock[i].address > address)
              address = 0;

          if (availBlock[i].size > minSz) {
             if (address) {
                 if (address < availBlock[i].address + availBlock[i].size &&
                     availBlock[i].size - (address - availBlock[i].address) >= minSz) {             
                     bestBlock = availBlock + i;
                     break;
                 }
             } else {
               if (availBlock[i].size >= maxSz) {
                   bestBlock = availBlock + i;
                   break;
               } else if (availBlock[i].size > biggest) {
                   bestBlock = availBlock + i;
                   biggest = bestBlock->size;
               }
             }
          }
      }
   } 

   if (!bestBlock) return err_prog_mem;

   /* We found a suitable block */
   *result = *bestBlock;

   if (address && address > result->address) {
       result->size -= address - result->address;
       bestBlock->size = address - result->address - 1;
       DosResize(result->address, bestBlock->size);
       result->address = DosAlloc(result->size);
       memmove(bestBlock + 2, bestBlock + 1, 
               (availBlocks - (bestBlock - availBlock) - 1) * sizeof(*bestBlock));
       availBlocks++; bestBlock++;
   }

   if (result->size > maxSz + 1 && maxSz != 0xffff) {
       DosResize(result->address, maxSz);
       bestBlock->size = result->size - maxSz - 1;
       bestBlock->address = DosAlloc(bestBlock->size);
       result->size = maxSz;
   } else {
     memmove(bestBlock, bestBlock + 1, 
             (availBlocks - (bestBlock - availBlock)) * sizeof(*bestBlock));
     availBlocks--;
   }
   return OK;
}
