TITLE dosfunc.asm

; This file contains DOS interface functions used by LOADHI.C

DGROUP GROUP _DATA

ASSUME CS:_TEXT, DS:DGROUP

_DATA SEGMENT WORD PUBLIC 'DATA'
   extrn _dos_error:WORD
   extrn _UMBLink:WORD
_DATA ENDS

_TEXT SEGMENT WORD PUBLIC 'CODE'

public _getCurrentPSP, _DosSeek, _DosOpen, _DosClose
public _DosSetUMBLink, _DosRead, _DosParseFCB
public _DosResize, _DosFree, _DosSetDTA, _DosFindFirst
public _DosSetStrategy, _DosGetCurrDrive, _DosGetCurrDir, _GetFirstMCB
public _DosAlloc, _DosStrupr, _DosLoadOverlay

extrn  _printf:NEAR

; This equate will point to the stack frame

frame equ [bp+4]

; Most of these functions are simply an interface between a C program and 
; the int 21h API. They load the registers from their parameters, and makes 
; an int 21h call.

_DosSetDTA PROC NEAR
  push  bp      
  mov   bp, sp
  push  ds
  mov   ah, 1ah
  lds   dx, frame
  call  calldos
  pop   ds
  pop   bp
  ret
_DosSetDTA ENDP

_DosFindFirst PROC NEAR
  push  bp
  mov   bp, sp
  push  ds

  mov   ax, 4e00h
  lds   dx, frame
  mov   cx, word ptr frame+4
  call  calldos
  jc    find_err
  xor   ax, ax

find_err:
  pop   ds
  pop   bp
  ret
_DosFindFirst ENDP

_DosLoadOverlay PROC NEAR
  push bp
  mov  bp, sp
  push ds

  lds  dx, dword ptr frame
  les  bx, dword ptr frame+4
  mov  ax, 4b03h
  call calldos
  jc   load_error
  xor  ax, ax

load_error:
  pop  ds
  pop  bp
  ret
_DosLoadOverlay ENDP

_DosAlloc PROC
  push  bp
  mov   bp, sp
  
  mov   ah, 48h
  mov   bx, frame
  call  calldos
  jnc   alloc_ok 
  xor   ax, ax

alloc_ok:
  pop   bp
  retn
_DosAlloc ENDP


_DosStrupr PROC
  push  bp
  mov   bp, sp
  push  ds

  lds   dx, frame
  mov   ax, 6522h
  call  calldos

  pop   ds
  pop   bp
_DosStrupr ENDP

_DosParseFCB PROC 
   push bp
   mov  bp, sp
   push ds
   push si
   push di

   mov  ax, 2900h
   lds  si, dword ptr frame      ; source filename
   les  di, dword ptr frame+4    ; destination FCB
   int  21h

   pop  di
   pop  si
   pop  ds
   pop  bp
   retn
_DosParseFCB ENDP

_DosRead PROC 
   push bp
   mov  bp, sp
   push ds

   mov ax, 3f00h
   mov bx, word ptr frame         ; file handle
   lds dx, dword ptr frame+2      ; pointer to buffer
   mov cx, word ptr frame+6       ; bytes to read
   call calldos
   jnc  read_ok
   sub ax, ax

read_ok:
   pop ds
   pop bp
   retn
_DosRead ENDP

; DosSetUMBLink:
;
; Set the UMB link. The global variable UMBLink will
; be set to the new state of the UMB link.
; The return value is the old state of the UMB link.

_DosSetUMBLink PROC 
   push bp
   mov  bp, sp
   push si

   mov ax, 5802h
   call calldos
   mov  si, ax
   and  si, 0ffh

   mov  ax, 5803h
   mov  bx, word ptr frame
   call calldos
   mov  ax, frame
   jnc  yup
   xor  ax, ax

yup:
   mov  DGROUP:_umbLink, ax
   mov  ax, si

   pop  si
   pop  bp
   retn
_DosSetUMBLink ENDP

_DosSetStrategy PROC 
; set the new, and return the old
   push bp
   mov  bp, sp
   push si
   push cs
   pop  ds

   mov  ax, 5800h
   call calldos
   mov  si, ax
   mov  ax, 5801h
   mov  bx, word ptr frame      ; new strategy
   call calldos

   mov  ax, si
   pop  si
   pop  bp
   retn
_DosSetStrategy ENDP

_DosFree PROC 
  push bp
  mov  bp, sp

  mov  es, word ptr frame    ; memory block to free
  mov  ah, 49h
  call calldos

  pop  bp
  ret
_DosFree ENDP

_DosResize PROC FAR
  push bp
  mov  bp, sp

  mov  es, word ptr frame     ; memory block to resize
  mov  bx, word ptr frame+2   ; new size
  mov  ah, 4ah
  call calldos
  jc   resize_err
  mov  ax, 0

resize_err:
  pop  bp
  retn
_DosResize ENDP

_DosSeek PROC 
  push bp
  mov  bp, sp

  mov  bx, word ptr frame       ; file handle
  mov  dx, word ptr frame+2     ; cx:dx = file offset 
  mov  cx, word ptr frame+4
  mov  ax, word ptr frame+6     ; seek strategy
  mov  ah, 42h
  call calldos
  jnc  seek_ok
  mov  ax, -1
  mov  dx, -1

seek_ok:
  pop  bp
  retn
_DosSeek ENDP

_DosClose PROC 
  push bp
  mov  bp, sp

  mov  bx, word ptr frame    ; file handle
  mov  ah, 3eh
  call calldos

  pop  bp
  retn
_DosClose ENDP

_getCurrentPSP PROC NEAR
  mov ah, 62h
  call near ptr calldos
  mov ax, bx

  retn
_getCurrentPSP ENDP

_DosOpen PROC NEAR
  push bp
  mov  bp, sp
  push ds
  
  lds  dx, dword ptr frame       ; filename
  mov  ax, word ptr frame+4      ; open mode 
  mov  ah, 3dh
  call calldos
  jnc  open_ok
  mov  ax, 0

open_ok:
  pop  ds
  pop  bp
  retn
_DosOpen ENDP

_DosGetCurrDrive PROC
  mov  ah, 19h
  call calldos
  retn
_DosGetCurrDrive ENDP

_DosGetCurrDir   PROC
  push  bp
  mov   bp, sp
  push  si
  push  ds

  mov   ah, 47h
  mov   dl, byte ptr frame     ; drive
  lds   si, dword ptr frame+2  ; buffer that receives the directory name 
  int   21h
  jc    err 
  xor   ax, ax

err:
  pop   ds
  pop   si
  pop   bp
  retn
_DosGetCurrDir   ENDP

_GetFirstMCB PROC
  mov ah, 52h
  call calldos
  mov ax, word ptr es:[bx-2]
  retn
_GetFirstMCB ENDP


; this routine is used to call DOS
; Some DOS versions don't always save all the necessary registers. 
; By using this function, this won't be a problem.

calldos PROC 
  push si
  push di
  push bp
  clc
  int  21h
  jnc  dosok
  
  mov  cs:_dos_error, ax

dosok:
  pop  bp
  pop  di
  pop  si
  retn
calldos ENDP

_TEXT ENDS
END
