/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_BNV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_brkNxtVal(FILE * const f)

	Read in the next line and try to interprete it as value

	Because the INI files were permanently filled with spurious
	newline characters (inserted to _ensure_ the such character
	really terminates the line in certain circumstances), empty
	lines are never returned. Because all internal function use
	this function to read in the next line and identify its
	contents, this will remove any empty lines from the INI file,
	if they are present in a section that is modified. There are,
	however, some exceptions when the INI file is not read line-
	by-line, but blockwise.

	As a side effect this function also removes newline characters
	inserted by the user. This means that the user should use
	a single comment sign, e.g. ';' or '#', to mark lines,
	which should remain empty, but present.

ob: cfgi_brkNxtVal
ty: L
su: inifile/2
sh: Read the next line from the INI file and try to interprete it as value
lo: Reads the next line from the INI file and tries to interprete it as
	a value.\par
	Empty lines are ignored completely.
re: 
fi: cfgi_bnv.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "supplio.h"
#include "dynstr.h"
#include "str.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_BNV.C 1.5 2001/02/27 01:27:47 ska Exp ska $";
#endif

int cfgi_brkNxtVal(FILE * const f)
{	DBG_ENTER("cfgi_brkNxtVal", Suppl_inifile2)

	assert(f);

	chkHeap
	if(FFgetpos(f, I(curpos)))
		DBG_RETURN_I( CFG_ERR_ACC)

	do {
		chkHeap
		if(!StrRepl(I(buf), Fgetline(f)))		/* out of memory */
			DBG_RETURN_I( CFG_ERR_MEM)
	} while(*skipws(I(buf)) == '\0');			/* skip empty lines */
	chkHeap
	if(!*I(buf)								/* EOF reached */
	 || cfgi_isSection(I(buf)) != 0)		/* end of section */
		DBG_RETURN_I( CFG_ERR_END)

	chkHeap
	DBG_RETURN_BI( cfgi_brkVal())
}
