/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_ACNT.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfgArgIndex
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Return the index of the next argument
he(ader files): 
lo(ng description): Return the index of the argument to be returned
	next
pr(erequistes): 
va(lue): index of next argument
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_acnt.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_ACNT.C 1.5 1999/12/13 02:21:56 ska Exp ska $";
#endif

#pragma argsused
static int incCnt(struct Cfg_Getopt * const optstru
	, struct Cfg_oStackGetopt * const ostk, void * const arg)
{	*((int *)arg) += O(cnt);
	return 0;				/* continue enumeration process */
}

#pragma argsused
static int incIdx(struct Cfg_Getopt * const optstru
	, struct Cfg_oStackGetopt * const ostk, void * const arg)
{	*((int *)arg) += O(idx);
	return 0;				/* continue enumeration process */
}

static int incInc(struct Cfg_Getopt *optstru
	, Cfg_ostkEnumFct fct)
{	int cnt;

	assert(optstru);
	assert(fct);

	cnt = 0;
	cfg_ostkEnum(optstru, fct, &cnt);

	return cnt;
}

int cfgArgCount(struct Cfg_Getopt *optstru)
{	DBG_ENTER("cfgArgIndex", Suppl_cmdline)
	DBG_RETURN_BI( incInc(optstru, aF(incCnt)))
}

int cfgArgIndex(struct Cfg_Getopt *optstru)
{	DBG_ENTER("cfgArgIndex", Suppl_cmdline)
	DBG_RETURN_BI( incInc(optstru, aF(incIdx)))
}
