/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIGVN.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgGetValName(const char * const name);

	Return the name of the value of the specified name.
	If name == NULL, the currently scanned value is processed.

	Return:
		NULL: on error
		else: pointer to internal buffer of value name

ob(ject): cfgGetValName
su(bsystem): inifile/2
sh(ort description): Return the name of a value
lo(ng description): Return a pointer to the name of the specified value as
 it is written within the INI file (first found).
	 If \para{name} == NULL, the current value is used.
wa: The returned string must not be modified.
va: NULL: on failure
re(lated to): 
fi(le): cfgigvn.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIGVN.C 1.4 2001/02/27 01:27:43 ska Exp ska $";
#endif

char *cfgGetValName(const char * const name)
{	DBG_ENTER("cfgGetValName", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	chkHeap
	DBG_RETURN_BS( cfgHasValue(name) == 0	/* fetch the specified value */
		?	I(value)			/* success */
		:	0)				/* failure */
}
