/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* Test getopt(), getopt_long(), getopt_long_only() */

#include <stdio.h>
#ifndef _MICROC_
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#endif
#include <portable.h>
#define SUPPL_DBG_HEAP
#define SUPPL_LOG_MEMORY
#define SUPPL_LOG_FUNCTION
#include "suppldbg.h"

#include "getopt.h"

void hlpScreen()
{	exit(127);
}

struct option lopts[] = {
	 { "long_n", 0, 0, 'n' }
	,{ "long_r", 1, 0, 'r' }
	,{ "long_o", 2, 0, 'o' }
	,{ 0, 0, 0, 0 }
};
#define SGL "NR:O::"

#define chr(ch) (((ch) > ' ' && (ch) < 255)? (ch): ' ')
main(int argc, char **argv)
{	int ch;
	int idx;

	puts("\nSupported single character options: " SGL);
	puts("Supported long options:");
	idx = -1;
	while(lopts[++idx].name) {
		printf("\t%s, returns %d ('%c'), ", lopts[idx].name, lopts[idx].val
		 , chr(lopts[idx].val));
		switch(lopts[idx].has_arg) {
		case 0:	puts("no argument"); break;
		case 1:	puts("required argument"); break;
		case 2:	puts("optional argument"); break;
		default: puts("Invalid argument setting"); break;
		}
	}
	puts("\nProcessed by getopt():");
	idx = 0;
	while((ch = getopt(argc, argv, SGL)) != EOF)
		printf("%d: rv = %d ('%c'), opt = %d ('%c'), arg = %s\n"
		 , ++idx, ch, chr(ch), optopt, chr(optopt)
		 , optarg? optarg: "none");

	getopt_init();
	puts("\nProcessed by getopt_long():");
	idx = 0;
	while((ch = getopt_long(argc, argv, SGL, aS(lopts), 0)) != EOF)
		printf("%d: rv = %d ('%c'), opt = %d ('%c'), arg = %s\n"
		 , ++idx, ch, chr(ch), optopt, chr(optopt)
		 , optarg? optarg: "none");

	getopt_init();
	puts("\nProcessed by getopt_long_only():");
	idx = 0;
	while((ch = getopt_long_only(argc, argv, SGL, aS(lopts), 0)) != EOF)
		printf("%d: rv = %d ('%c'), opt = %d ('%c'), arg = %s\n"
		 , ++idx, ch, chr(ch), optopt, chr(optopt)
		 , optarg? optarg: "none");

	return 0;
}
