/* GSnes9x -- romprefs.h
 * Copyright (C) 1999 Canek Pelez Valds <canek@abulafia.fciencias.unam.mx>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GSNES9X_ROM_PREFS_H
#define GSNES9X_ROM_PREFS_H

/* Callback. */
void          rom_preferences_cb          (GtkWidget *widget, GSnes9xData *gsnes_data);

/* Structs constructors. */
ROMInfo*      rom_info_new                ();
ROMPrefsData* rom_prefs_data_new          ();

/* Notebook pages. */
GtkWidget*    rom_prefs_info_ops          (ROMPrefsData *rpd);
GtkWidget*    rom_prefs_graphics_ops      (ROMPrefsData *rpd);
GtkWidget*    rom_prefs_sound_ops         (ROMPrefsData *rpd);
GtkWidget*    rom_prefs_cheat_ops         (ROMPrefsData *rpd);
GtkWidget*    rom_prefs_speed_ops         (ROMPrefsData *rpd);
GtkWidget*    rom_prefs_format_ops        (ROMPrefsData *rpd);
GtkWidget*    rom_prefs_joystick_ops      (ROMPrefsData *rpd);

/* Setup. */
void          rom_prefs_nosound_cb        (GtkWidget *widget, ROMPrefsData *rpd);
void          rom_prefs_nojoy_cb          (GtkWidget *widget, ROMPrefsData *rpd);
void          rom_prefs_dialog_changed_cb (GtkWidget *widget, ROMPrefsData *rpd);
void          rom_prefs_connect_changes   (ROMPrefsData *rpd);
void          rom_prefs_set_tooltips      (ROMPrefsData *rpd);
void          rom_prefs_dialog_set_status (ROMPrefsData *rpd);
void          rom_prefs_dialog_get_status (ROMPrefsData *rpd);

/* Dialog buttons. */
void          rom_prefs_apply_cb          (GtkWidget *widget, ROMPrefsData *rpd);
void          rom_prefs_close_cb          (GtkWidget *widget, ROMPrefsData *rpd);
void          rom_prefs_help_cb           (GtkWidget *widget, GtkWidget *notebook);
void          rom_load_defaults_cb        (GtkWidget *widget, ROMPrefsData *rpd);


/* Close functions. */
void          rom_prefs_destroy_cb        (GtkWidget *widget, ROMPrefsData *rpd);
gboolean      rom_prefs_delete_cb         (GtkWidget *widget);
void          rom_prefs_free_cb           (GtkWidget *widget, ROMPrefsData *rpd);

/* Messages. */
void          rom_repeated                (gchar *name, GtkWidget *parent);
void          no_rom_file                 (GtkWidget *parent);
void          no_snapfile                 (GtkWidget *parent);
void          no_correct_name             (GtkWidget *parent);

#endif

/* romprefs.h ends here. */
