#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <ctype.h>
#include <gtk/gtk.h>
#include <gmodule.h> // GModule

#include "platform.h"
#include "tilibs.h"

#include "struct.h"
#include "specific.h"
#include "extern.h"
#include "rcfile.h"
#include "version.h"

#include "gtk_about_dbox.h"
#include "gtk_about_cb.h"
#include "gtk_adbkpt_dbox.h"
#include "gtk_adbkpt_cb.h"
#include "gtk_colors_dbox.h"
#include "gtk_colors_cb.h"
#include "gtk_dbkpt_dbox.h"
#include "gtk_dbkpt_cb.h"
#include "gtk_debug_dbox.h"
#include "gtk_debug_cb.h"
#include "gtk_itick_dbox.h"
#include "gtk_itick_cb.h"
#include "gtk_link_dbox.h"
#include "gtk_link_cb.h"
#include "gtk_logaddr_dbox.h"
#include "gtk_logaddr_cb.h"
#include "gtk_msg_dbox.h"
#include "gtk_msg_cb.h"
#include "gtk_romv_dbox.h"
#include "gtk_romv_cb.h"
#include "gtk_trap_dbox.h"
#include "gtk_trap_cb.h"
#include "gtk_viewlog_dbox.h"
#include "gtk_viewlog_cb.h"
#include "gtk_dbgopt_dbox.h"
#include "gtk_dbgopt_cb.h"
#include "gtk_infos_dbox.h"
#include "gtk_infos_cb.h"
#include "gtk_pgmentbkpt_dbox.h"
#include "gtk_pgmentbkpt_cb.h"
#include "gtk_state_dbox.h"
#include "gtk_state_cb.h"
#include "gtk_bkpt_cause.h"
#include "gtk_dump_dbox.h"
#include "gtk_dump_cb.h"
#include "gtk_scopt_dbox.h"
#include "gtk_scopt_cb.h"
#include "gtk_user_dbox.h"
#include "gtk_user_cb.h"
#include "gtk_fsel_dbox.h"
#include "gtk_fsel_cb.h"
#include "gtk_help_dbox.h"
#include "gtk_help_cb.h"
#include "gtk_about_dbox.h"
#include "gtk_about_cb.h"
#include "gtk_manpage_dbox.h"
#include "gtk_manpage_cb.h"
#include "gtk_startup_dbox.h"
#include "gtk_startup_cb.h"
#include "gtk_thanks_dbox.h"
#include "gtk_thanks_cb.h"
#include "gtk_tiemu_dbox.h"

GtkWidget* display_popup_menu()
{
  GtkWidget *menu;
  gpointer user_data;
  gchar *s;
  GtkCheckMenuItem *i; 
  
  menu = create_popup_menu();

  user_data = gtk_object_get_data(GTK_OBJECT(menu), "popup_menu_header");
  s = g_strdup_printf("GtkTiEmu, version %s", GTKTIEMU_VERSION);
  gtk_label_set_text(GTK_LABEL(GTK_BIN(user_data)->child), s);
  g_free(s);

  user_data = gtk_object_get_data(GTK_OBJECT(menu), "sync1");
  i = (GtkCheckMenuItem *) user_data;
  gtk_check_menu_item_set_show_toggle(i, TRUE);
  gtk_check_menu_item_set_active(i, *(options.sync_one));

  user_data = gtk_object_get_data(GTK_OBJECT(menu), "restrict1");
  i = (GtkCheckMenuItem *) user_data;
  gtk_check_menu_item_set_show_toggle(i, TRUE);
  gtk_check_menu_item_set_active(i, !(*(options.background)));

  user_data = gtk_object_get_data(GTK_OBJECT(menu), "skin1");
  i = (GtkCheckMenuItem *) user_data;
  if(ti68k_getCalcType() & TI92)
    gtk_label_set_text(GTK_LABEL(GTK_BIN(user_data)->child), ("Skin 92"));
  else
    gtk_label_set_text(GTK_LABEL(GTK_BIN(user_data)->child), ("Skin 89"));
  //gtk_check_menu_item_set_show_toggle(i, TRUE);
  //gtk_check_menu_item_set_active(i, (*(options.background)));

  user_data = gtk_object_get_data(GTK_OBJECT(menu), "none1");
  i = (GtkCheckMenuItem *) user_data;
  //gtk_check_menu_item_set_show_toggle(i, TRUE);
  //gtk_check_menu_item_set_active(i, !(*(options.background)));


  return menu;
}

void
on_popup_menu_header                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  unsuspend();
}

gboolean
on_popup_menu_configure_event          (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  DISPLAY("configure\n");
  unsuspend();
  return FALSE;
}


void
on_tiemu__popup_menu1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  
}


void
on_item1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
}


void
on_load_file1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  msg_box(_("Information"), 
	  _("This function is not available yet."));
}

struct tilp_module
{
  int (*init_module)(LinkCable *lc);
  int (*main_module)(void);
  int (*exit_module)(void);
} tm;
//typedef struct ticable_link LINK_CABLE;

int (*init_module)(LinkCable *lc);
int (*main_module)(void);
int (*exit_module)(void);

void
on_single1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  /*
  GModule *module;
  LinkCable* old_lc = ti68k_getLinkCable();

  DISPLAY("\n\n");
  module = g_module_open("/usr/lib/libtilp.so", 0);
  
  g_module_symbol(module, "main_module", (gpointer *)(&init_module));
  printf("init_module = %p\n", init_module);
  g_module_symbol(module, "init_module", (gpointer *)(&main_module));
  printf("main_module = %p\n", main_module);
  g_module_symbol(module, "exit_module", (gpointer *)(&exit_module));
  printf("exit_module = %p\n", exit_module);

  fprintf(stdout, "calling main_module... "); fflush(stdout);
  main_module();
  fprintf(stdout, "done !\n");
  fprintf(stdout, "calling init_module... "); fflush(stdout);
  init_module(ti68k_getLinkCable());
  fprintf(stdout, "done !\n");
  */
}


void
on_group1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

/*
  Menu item has launched the debugger
*/
void
on_enter_debugger1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gint i;
  CODE_BKPT *s;

  // Suspend emulation core
  suspend();
/*
#ifdef __WIN32__
	msg_box("Information",
		"The debugger crashes in the Win32 version so it is has been temporarily disabled. It will be available in a next release.\n");
	unsuspend();
	return ;
#endif
*/
  
  // Remove all breakpoints so that we can 'single step'
  // Bkpts are restored when the debugger is exited
  for(i=0; i<g_list_length(bkpt_address_list); i++)
    {
      s = (CODE_BKPT *)g_list_nth_data(bkpt_address_list, i);
      
      ti68k_delBreakpointAddress(s->id);
    }

  // Launch debugger
  display_debugger_dbox();
}

int enter_gtk_debugger(void)
{
  on_enter_debugger1_activate(NULL, NULL);  

  return 0;
}

void
on_set_program_entry_breakpoint1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_show(create_pgmentrybkpt_dbox ());
}


void
on_reset_calc1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ti68k_resetLib68k();

  unsuspend();
}

void
on_load_state_image1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_fs_load_state();
}


void
on_save_state_image1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_fs_save_state();
}


void
on_revert_to_saved_state1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ti68k_loadState(options.ram_file);
  unsuspend();
}


void
on_state_file1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  msg_box(_("Information"), 
	  _("This function is not available yet."));
}


void
on_restrict_to_actual_speed1_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  /*
    msg_box(_("Information"), 
    _("This function is not available yet."));
  */
}


void
on_change_speed1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_tickrate_dbox();
}


void
on_cycle_rate1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_cyclerate_dbox();
}


void
on_itick1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_itick_dbox();
}


void
on_redefine_keys1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  msg_box(_("Information"), 
	  _("This function is not available yet."));
}


void
on_xtiger_keys1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  msg_box(_("Information"), 
	  _("This function is not available yet."));
}


void
on_vti_keys1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  msg_box(_("Information"), 
	  _("This function is not available yet."));
}


void
on_dump_rom1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_romdump_fileselection();
}


void
on_set_emulation_rom_version1_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_romversion_dbox ();
}


void
on_rom_file1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_rom_fileselection ();
}


void
on_internal_rom_file1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_rom_fileselection ();
}


void
on_external_rom_file1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_rom_fileselection ();
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_about_dbox ();
}


void
on_dialog_destroy                      (GtkObject       *object,
                                        gpointer         user_data)
{
  msg_box(_("Information"), 
	  _("This function is not available yet."));
}


void
on_save_config1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  write_rc_file();

#if defined(__LINUX__)
  msg_box(_("Information"), 
	  _("Configuration file saved (in ~/.gtktiemu)."));
#elif defined(__WIN32__)
  msg_box(_("Information"), 
	  _("Configuration file saved (in gtktiemu.ini)."));
#endif
}


void
on_load_config1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  read_rc_file();

  msg_box(_("Information"), 
	  _("Configuration file loaded."));
}


void
on_ram_file1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_fs_load_state();
}


void
on_dump_ram1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_ramdump_fileselection();
}


void
on_number_of_colors1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_ncolors_dbox();
}


void
on_dark___light_colors1_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_dlcolors_dbox();
}


void
on_sync1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(GTK_CHECK_MENU_ITEM(menuitem)->active != TRUE) 
    *(options.sync_one) = 0;
  else
    *(options.sync_one) = 1;

  unsuspend();
}


void
on_link_cable1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_linktype_dbox();
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ti68k_saveState(options.ram_file);
  if(!is_rcfile_exist())
    write_rc_file();

  ti68k_closeLib68k();
  //gtk_main_quit();
  exit(0);
}


void
on_button43_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_button44_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_send_file_to_gtktiemu1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_tifile_fileselection();
}

void enter_command(void);

void
on_command_shell1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  /*
  ticable_DISPLAY_settings(DSP_ON);
  suspend();
  enter_command();
  unsuspend();
  ticable_DISPLAY_settings(DSP_CLOSE);
  */
}


void
on_emulator_options1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
}


void
on_exit_without_saving_state1_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ti68k_closeLib68k();
  //gtk_main_quit();
  exit(0);
}


void
on_infos1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_infos_dbox();
}


void
on_set_rom1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_romversion_dbox ();
}


void
on_popup_menu_cancel                   (GtkMenuShell    *menushell,
                                        gpointer         user_data)
{
  // call when you press ESC during popup menu
  DISPLAY("cancel\n");
  unsuspend();
}


void
on_popup_menu_deactivate               (GtkMenuShell    *menushell,
                                        gpointer         user_data)
{
  // bug if we click outside of the rbm menu: we need to unsuspend the emulation
  // core although a menu item could have been clicked.
  //DISPLAY("deactivate !\n");
  //unsuspend();
}


void
on_calculator_image1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_skin1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  //DISPLAY("skin_activate\n");
  switch_with_skin();
  unsuspend();
}


void
on_none1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  //DISPLAY("none_activate\n");
  switch_without_skin();
  unsuspend();
}


void
on_rbm_options1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_scopt_dbox();
}


void
on_now__1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_screenshot(options.img_format, options.img_type, options.img_size, NULL);
  unsuspend();
}

void
on_convert_into_rom1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_ams_fileselection();
}



void
on_help3_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_help_dbox();
}


void
on_manpage1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_manpage_dbox();
}


void
on_changelog1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_startup_dbox();
}


void
on_thanks1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_thanks_dbox();
}

/**/

