/*  GtkTiEmu - a TI emulator
 *  Copyright (C) 2000, Thomas Corvazier, Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __SKNLOADER_H__
#define __SKNLOADER_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define SKINFILE_92  "ti92.skn"
#define SKINFILE_89  "ti89.skn"

typedef struct tagRECT_
{
  long left;
  long top;
  long right;
  long bottom;
} RECT_;

#define MAX_COLORS 128
extern unsigned char skinColormap[3][MAX_COLORS];
extern int skinNumberOfColors;

extern RECT_ rcLcd;			// screen coordinates in the skin file
extern RECT_ rcRectKeys[80]; // coordinates of the TI keys
extern unsigned char *pSkin;
extern int xSkin;
extern int ySkin;

extern char *sknKey;
extern char sknKey92[];
extern char sknKey89[];

int loadSkin(char *filename);

#endif


