/*
 *  HPTalx
 *  A PC<->HP48/49 communication program for Linux
 *
 *  (C) 1999, 2000 by Bruno Barberi Gnecco
 *
 * rev 2.0:	Added kermit/xmodem support
 */
 
/*
    Copyright note:

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef HPTALX_H
#define HPTALX_H

#include <gtk/gtk.h>
#include <stdio.h>
#include "gui_utils.h"

enum protocol_type {
	KERMIT, XMODEM
};
typedef enum protocol_type PROTOCOL_TYPE;

struct _pref { 
	int 		port;		/* COM1 = 0, 1, 2, 3 */
	int		delete_confirm;
	int		start_connected;
	int		start_after_dot;
	int		wait_connect;
	char		*editor;
	PROTOCOL_TYPE	protocol;
};
typedef struct _pref Pref;

struct data {
	char 		*dir;		/* current selection value in dirs */
	int 		last_dir_row;	/* last selected dir row */
	char 		*filename;	/* current selection value in files */
	int 		last_file_row;	/* last selected file row */
	char		*current; 	/* current working directory */
};

enum connection {
	ONLINE, OFFLINE
};
typedef enum connection CONNECTION;

enum vpaned {
	PC, HP, BOTH
};
typedef enum vpaned VPANED;

enum hpaned {
	FILES, DIRS
};
typedef enum hpaned HPANED;

enum calculator {
	UNKNOWN_CALC, HP49, HP48G
};
typedef enum calculator CALCULATOR;

enum transfer_type {
	AUTO=0, BINARY, ASCII
};
typedef enum transfer_type TRANSFER_TYPE;

extern GtkWidget *dir_pc, *dir_hp;
extern GtkWidget *files_pc, *files_hp;
extern GtkItemFactory *item_factory;
extern struct data data_pc, data_hp;
extern VPANED whereami;
extern HPANED panel;
extern CALCULATOR calc;
extern CONNECTION connected;
extern TRANSFER_TYPE ttype;
extern Pref preferences;
extern FILE *xmodem, *kermit;

#define wait_prompt()			do { \
					fgets( temp, BUFFERSIZE-1, kermit ); \
					} while ( !strstr( temp, "Kermit>") )

/* main.c */
void set_status ( char *message );
void get_pop_menu ( GtkWidget *popmenu );

/* io.c */
void clear_kinput ( void );
void transfer ( GtkWidget *w, gpointer data );
void move ( GtkWidget *w, gpointer data );
void edit ( GtkWidget *w, gpointer data );
void copy ( GtkWidget *w, gpointer data );
void renamew ( GtkWidget *w, gpointer data );
void unpack ( GtkWidget *w, gpointer data );
void delete ( GtkWidget *w, gpointer data );
void select_all ( GtkWidget *w, gpointer data );
void unselect_all ( GtkWidget *w, gpointer data );
void choose_dir ( GtkWidget *w, gpointer data );
void change_dir ( GtkWidget *w, gpointer data );
void create_dir ( GtkWidget *w, gpointer data );
void remove_dir ( GtkWidget *w, gpointer data );
void command ( GtkWidget *w, gpointer data );
void update_rom ( GtkWidget *w, gpointer data );
void backup ( GtkWidget *w, gpointer data );
void restore ( GtkWidget *w, gpointer data );

/* io2.c*/
int send_packet ( const unsigned char *header, const unsigned char *s );
void refreshall ( GtkWidget *w, gpointer data );
void refresh ( GtkWidget *w, gpointer data );
void hp_connect ( GtkWidget *w, gpointer data );
void disconnect ( GtkWidget *w, gpointer data );

/* setup.c */
void load_prefs ( void );
void setup ( GtkWidget *w, gpointer data );
void howtouse ( GtkWidget *w, gpointer data );
void about ( GtkWidget *w, gpointer data );

#endif
