#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/xpm.h>
#include <Xm/Xm.h>

#include "icons.h"

#include "xpm/cw.xpm"
#include "xpm/ccw.xpm"
#include "xpm/fliph.xpm"
#include "xpm/flipv.xpm"
#include "xpm/prev.xpm"
#include "xpm/next.xpm"
#include "xpm/zoomin.xpm"
#include "xpm/zoomout.xpm"
#include "xpm/exit.xpm"

#include "xpm/dir.xpm"
#include "xpm/file.xpm"
#include "xpm/unknown.xpm"

static void
add_pixmap(Display *dpy, unsigned long bg, char *name, char **data)
{
    XImage *image,*shape;
    XpmAttributes attr;
    int x,y;

    memset(&attr,0,sizeof(attr));
    XpmCreateImageFromData(dpy,data,&image,&shape,&attr);

    if (shape)
	for (y = 0; y < attr.height; y++)
	    for (x = 0; x < attr.width; x++)
		if (!XGetPixel(shape, x, y))
		    XPutPixel(image, x, y, bg);

    XmInstallImage(image,name);
}

void
x11_icons_init(Display *dpy, unsigned long bg)
{
    add_pixmap(dpy, bg, "rotcw",   cw_xpm);
    add_pixmap(dpy, bg, "rotccw",  ccw_xpm);
    add_pixmap(dpy, bg, "fliph",   fliph_xpm);
    add_pixmap(dpy, bg, "flipv",   flipv_xpm);
    add_pixmap(dpy, bg, "prev",    prev_xpm);
    add_pixmap(dpy, bg, "next",    next_xpm);
    add_pixmap(dpy, bg, "zoomin",  zoomin_xpm);
    add_pixmap(dpy, bg, "zoomout", zoomout_xpm);
    add_pixmap(dpy, bg, "exit",    exit_xpm);

    add_pixmap(dpy, bg, "dir",     dir_xpm);
    add_pixmap(dpy, bg, "file",    file_xpm);
    add_pixmap(dpy, bg, "unknown", unknown_xpm);
}
